/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.i18n.GrailsI18nizeQuickFixDialog;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.uast.UExpression;

public class GrailsI18nGroovyQuickFixHandler
implements I18nQuickFixHandler<UExpression> {
    private static final Logger LOG = Logger.getInstance(GrailsI18nGroovyQuickFixHandler.class);
    public static final GrailsI18nGroovyQuickFixHandler INSTANCE = new GrailsI18nGroovyQuickFixHandler();

    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        if (GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, psiFile) == null) {
            LOG.error("Method checkApplicability() must not be called if file is not applicable, GrailsI18nizeProvider must check applicable before returning GrailsI18nGroovyQuickFixHandler");
            throw new IncorrectOperationException("Failed to extract i18n property");
        }
    }

    private static TextRange rangeInnerString(@NotNull PsiElement element) {
        if (element == null) {
            GrailsI18nGroovyQuickFixHandler.$$$reportNull$$$0(0);
        }
        return ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getTextOffset());
    }

    @Nullable
    public static Trinity<String, String, PsiElement> calculatePropertyValue(Editor editor, PsiFile psiFile) {
        TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
        if (selectedRange == null) {
            return null;
        }
        PsiElement elementAt = psiFile.getViewProvider().findElementAt(selectedRange.getStartOffset());
        if (elementAt == null || elementAt.getLanguage() != GroovyLanguage.INSTANCE) {
            return null;
        }
        if ((elementAt = elementAt.getParent()) instanceof GrStringContent) {
            elementAt = elementAt.getParent();
        }
        if (elementAt instanceof GrLiteralImpl) {
            if (!selectedRange.equals((Object)elementAt.getTextRange()) && !selectedRange.equals((Object)GrailsI18nGroovyQuickFixHandler.rangeInnerString(elementAt))) {
                return null;
            }
            Object value = ((GrLiteralImpl)elementAt).getValue();
            if (!(value instanceof String)) {
                return null;
            }
            return Trinity.create((Object)((String)value), (Object)"", (Object)elementAt);
        }
        if (elementAt.getClass() == GrStringImpl.class) {
            if (editor.getSelectionModel().hasSelection() && !selectedRange.equals((Object)elementAt.getTextRange()) && !selectedRange.equals((Object)GrailsI18nGroovyQuickFixHandler.rangeInnerString(elementAt))) {
                return null;
            }
            GrStringImpl grString = (GrStringImpl)elementAt;
            StringBuilder propertyValueText = new StringBuilder();
            StringBuilder argsText = new StringBuilder();
            int injectionCount = 0;
            for (PsiElement e = grString.getFirstChild(); e != null; e = e.getNextSibling()) {
                GrExpression expression;
                if (PsiImplUtil.isLeafElementOfType((PsiElement)e, (IElementType)GroovyTokenTypes.mGSTRING_CONTENT) || e instanceof GrStringContent) {
                    propertyValueText.append(e.getText());
                    continue;
                }
                if (!(e instanceof GrStringInjection)) continue;
                propertyValueText.append('{').append(injectionCount++).append('}');
                if (argsText.length() > 0) {
                    argsText.append(", ");
                }
                if ((expression = ((GrStringInjection)e).getExpression()) == null) {
                    GrClosableBlock closableBlock = ((GrStringInjection)e).getClosableBlock();
                    if (closableBlock == null || closableBlock.hasParametersSection()) {
                        return null;
                    }
                    PsiElement rBrace = closableBlock.getRBrace();
                    if (rBrace == null) {
                        return null;
                    }
                    expression = rBrace.getPrevSibling();
                    if (!(expression instanceof GrExpression) || !(expression.getPrevSibling() instanceof GrParameterList)) {
                        return null;
                    }
                }
                argsText.append(expression.getText().trim());
            }
            return Trinity.create((Object)propertyValueText.toString(), (Object)argsText.toString(), (Object)elementAt);
        }
        return null;
    }

    public void performI18nization(PsiFile psiFile, Editor editor, UExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, UExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
        Project project = psiFile.getProject();
        Trinity<String, String, PsiElement> trinity = GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, psiFile);
        assert (trinity != null);
        TextRange textRange = ((PsiElement)trinity.third).getTextRange();
        propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
        editor.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)i18nizedText);
    }

    public UExpression getEnclosingLiteral(PsiFile file, Editor editor) {
        return I18nizeAction.getEnclosingStringLiteral((PsiFile)file, (Editor)editor);
    }

    public JavaI18nizeQuickFixDialog<UExpression> createDialog(Project project, Editor editor, PsiFile psiFile) {
        final Trinity<String, String, PsiElement> trinity = GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, psiFile);
        if (trinity == null) {
            return null;
        }
        return new GrailsI18nizeQuickFixDialog(project, psiFile, (String)trinity.first){

            @Override
            protected String getArgs() {
                return (String)trinity.second;
            }

            @Override
            @NotNull
            protected String getTemplateName() {
                return ((String)trinity.second).length() > 0 ? "I18nized Groovy string with injections.gsp" : "I18nized Groovy string.gsp";
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/i18n/GrailsI18nGroovyQuickFixHandler", "rangeInnerString"));
    }
}

