/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.fileType;

import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.xml.util.XmlUtil;
import icons.GroovyMvcIcons;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.directive.GspDirectiveAttributeValueImpl;
import org.jetbrains.plugins.groovy.GroovyEnabledFileType;

public final class GspFileType
extends XmlLikeFileType
implements GroovyEnabledFileType {
    public static final String GSP_EXTENSION = "gsp";
    public static final GspFileType GSP_FILE_TYPE = new GspFileType();

    private GspFileType() {
        super((Language)GspLanguage.INSTANCE);
    }

    @NotNull
    public String getDefaultExtension() {
        return GSP_EXTENSION;
    }

    @NotNull
    public String getDescription() {
        String string = GrailsBundle.message("language.gsp.full", new Object[0]);
        if (string == null) {
            GspFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return GroovyMvcIcons.Gsp_logo;
    }

    @NotNull
    public String getName() {
        return "GSP";
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    public Charset extractCharsetFromFileContent(Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        String name;
        Charset charset;
        if (content == null) {
            GspFileType.$$$reportNull$$$0(1);
        }
        if ((charset = CharsetToolkit.forName((String)(name = XmlUtil.extractXmlEncodingFromProlog((CharSequence)content)))) != null) {
            return charset;
        }
        charset = GspFileType.extractCharset(content);
        if (charset != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    @Nullable
    private static Charset extractCharset(@NotNull CharSequence content) {
        IElementType tokenType;
        ParserDefinition definition;
        if (content == null) {
            GspFileType.$$$reportNull$$$0(2);
        }
        if ((definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)GspLanguage.INSTANCE)) == null) {
            return null;
        }
        Lexer lexer = definition.createLexer(null);
        lexer.start(content);
        while ((tokenType = lexer.getTokenType()) != null) {
            String name;
            Charset charset;
            Matcher matcher;
            if (tokenType == GspTokenTypes.GSP_DIRECTIVE && (matcher = GspDirectiveAttributeValueImpl.CHARSET_PATTERN.matcher(lexer.getTokenSequence())).find() && (charset = CharsetToolkit.forName((String)(name = matcher.group(1)))) != null) {
                return charset;
            }
            lexer.advance();
        }
        return null;
    }

    static {
        PluginVerifier.verifyUltimatePlugin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/fileType/GspFileType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/fileType/GspFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

