/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.feature.forge;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableConsumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleParentProjectForm;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.feature.forge.CoverPane;
import org.jetbrains.plugins.grails.feature.forge.DomainKt;
import org.jetbrains.plugins.grails.feature.forge.FFeature;
import org.jetbrains.plugins.grails.feature.forge.FProfile;
import org.jetbrains.plugins.grails.feature.forge.FVersion;
import org.jetbrains.plugins.grails.feature.forge.GrailsForgeBundle;
import org.jetbrains.plugins.grails.feature.forge.ImplKt;

public class GrailsForgeOptionsForm
implements Disposable {
    private static final String FEATURE_KEY = "grails.application.forge.feature";
    private JPanel myMainPanel;
    private ComboBox<String> myProjectType;
    private ComboBox<FVersion> myVersions;
    private ComboBox<FProfile> myProfiles;
    private JPanel myFeaturesPanel;
    private JPanel myParentGradleProjectPane;
    @NotNull
    private final GradleParentProjectForm myGradleParentProjectForm;
    private final CoverPane myCoverPane;
    private final JBLoadingPanel myPanel;
    private boolean myLoadingFinished = false;

    public GrailsForgeOptionsForm(WizardContext context) {
        NullableConsumer nullableConsumer = p -> this.updateComponents();
        this.$$$setupUI$$$();
        this.myGradleParentProjectForm = new GradleParentProjectForm(context, nullableConsumer);
        this.myParentGradleProjectPane.add(this.myGradleParentProjectForm.getComponent());
        this.myVersions.addItemListener(e -> this.versionChanged());
        this.myProfiles.addItemListener(e -> this.profileChanged());
        this.myCoverPane = new CoverPane(this.myMainPanel);
        this.myCoverPane.hideContent();
        this.myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myPanel.add((Component)this.myCoverPane);
        this.myPanel.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){

            public void onLoadingFinish() {
                if (GrailsForgeOptionsForm.this.myLoadingFinished) {
                    GrailsForgeOptionsForm.this.myCoverPane.showContent();
                }
            }
        });
    }

    private void setVersions(@NotNull List<FVersion> versions) {
        if (versions == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(0);
        }
        this.myVersions.setModel((ComboBoxModel)new CollectionComboBoxModel(versions));
        FVersion latestVersion = DomainKt.findLatestNonSnapshotVersion(versions);
        if (latestVersion != null) {
            this.myVersions.setSelectedItem((Object)latestVersion);
        } else {
            this.versionChanged();
        }
        this.myLoadingFinished = true;
    }

    private void versionChanged() {
        this.setProfiles(this.getSelectedVersion().getProfiles());
    }

    private void setProfiles(@NotNull List<FProfile> profiles) {
        if (profiles == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(1);
        }
        this.myProfiles.setModel((ComboBoxModel)new CollectionComboBoxModel(profiles));
        FProfile webProfile = DomainKt.findWebProfile(profiles);
        if (webProfile != null) {
            this.myProfiles.setSelectedItem((Object)webProfile);
        } else {
            this.profileChanged();
        }
    }

    private void profileChanged() {
        FProfile profile = this.getSelectedProfile();
        @NlsSafe String profileDescription = profile.getDescription();
        this.myProfiles.setToolTipText(profileDescription);
        this.myFeaturesPanel.removeAll();
        List<FFeature> features = profile.getFeatures();
        if (features.isEmpty()) {
            return;
        }
        this.myFeaturesPanel.setLayout((LayoutManager)new GridLayoutManager(features.size(), 2));
        GridConstraints labelConstraints = new GridConstraints();
        labelConstraints.setUseParentLayout(true);
        labelConstraints.setFill(1);
        JBLabel label = new JBLabel("", 2);
        label.setLabelFor((Component)this.myFeaturesPanel);
        LabeledComponent.TextWithMnemonic mnemonic = LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)GrailsForgeBundle.message("label.features", new Object[0]));
        mnemonic.setToLabel((JLabel)label);
        this.myFeaturesPanel.add((Component)label, labelConstraints);
        GridConstraints constraints = new GridConstraints();
        constraints.setColumn(1);
        constraints.setUseParentLayout(true);
        constraints.setFill(1);
        for (FFeature feature : features) {
            JBCheckBox checkBox = new JBCheckBox();
            @NlsSafe String name = feature.getName();
            checkBox.setText(name);
            @NlsSafe String description = feature.getDescription();
            checkBox.setToolTipText(description);
            checkBox.setSelected(feature.getDefault() || feature.getRequired());
            checkBox.setEnabled(!feature.getRequired());
            checkBox.putClientProperty((Object)FEATURE_KEY, (Object)feature);
            this.myFeaturesPanel.add((Component)checkBox, constraints);
            constraints.setRow(constraints.getRow() + 1);
        }
        this.myFeaturesPanel.revalidate();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myGradleParentProjectForm);
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myPanel;
        if (jBLoadingPanel == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(2);
        }
        return jBLoadingPanel;
    }

    public boolean validate() {
        return this.myLoadingFinished;
    }

    @Nullable
    public ProjectData getParentProject() {
        return this.myGradleParentProjectForm.getParentProject();
    }

    @NotNull
    public String getSelectedProjectType() {
        String string = Objects.requireNonNull(StringUtil.toLowerCase((String)((String)this.myProjectType.getSelectedItem())));
        if (string == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public FVersion getSelectedVersion() {
        FVersion fVersion = (FVersion)Objects.requireNonNull(this.myVersions.getSelectedItem());
        if (fVersion == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(4);
        }
        return fVersion;
    }

    @NotNull
    public FProfile getSelectedProfile() {
        FProfile fProfile = (FProfile)Objects.requireNonNull(this.myProfiles.getSelectedItem());
        if (fProfile == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(5);
        }
        return fProfile;
    }

    @NotNull
    public List<String> getSelectedFeatures() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Component component : this.myFeaturesPanel.getComponents()) {
            FFeature feature;
            JBCheckBox checkBox;
            if (!(component instanceof JBCheckBox) || !(checkBox = (JBCheckBox)component).isSelected() || (feature = (FFeature)checkBox.getClientProperty((Object)FEATURE_KEY)) == null) continue;
            result2.add(feature.getName());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void init(@NotNull String serviceUrl) {
        if (serviceUrl == null) {
            GrailsForgeOptionsForm.$$$reportNull$$$0(7);
        }
        this.myPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<FVersion> versions = ImplKt.getForgeVersions(serviceUrl);
                SwingUtilities.invokeLater(() -> this.setVersions(versions));
            }
            catch (Throwable e) {
                SwingUtilities.invokeLater(() -> Messages.showErrorDialog((String)GrailsBundle.message("dialog.message.initialization.failed", serviceUrl, e.getMessage()), (String)GrailsBundle.message("dialog.title.grails.application.forge.error", new Object[0])));
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    this.myPanel.stopLoading();
                    this.myPanel.revalidate();
                });
            }
        });
        this.updateComponents();
    }

    public void updateComponents() {
        this.myGradleParentProjectForm.updateComponents();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProjectType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setVersions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProfiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 5, 0, 6), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsForgeOptionsForm.class).getString("form.label.project.type"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectType = comboBox3 = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Application");
        defaultComboBoxModel.addElement("Plugin");
        comboBox3.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/GrailsForgeBundle", GrailsForgeOptionsForm.class).getString("label.version"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersions = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/GrailsForgeBundle", GrailsForgeOptionsForm.class).getString("label.profile"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfiles = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myFeaturesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 2, 3, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myParentGradleProjectPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

