/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.tests.GrailsTestUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GenerateTestsAction
extends AnAction {
    private final boolean myIntegration;
    private final String myArtifactName;
    private final GrailsArtifact myArtifactType;

    public GenerateTestsAction(boolean integration, @NotNull String artifactName, GrailsArtifact artifactType) {
        if (artifactName == null) {
            GenerateTestsAction.$$$reportNull$$$0(0);
        }
        this.myIntegration = integration;
        this.myArtifactName = artifactName;
        this.myArtifactType = artifactType;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            GenerateTestsAction.$$$reportNull$$$0(1);
        }
        if ((module = (Module)e.getData(LangDataKeys.MODULE)) == null) {
            return;
        }
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        if (application == null) {
            return;
        }
        PsiClass testedClass = this.getTestedClass(module);
        if (testedClass == null) {
            switch (this.myArtifactType) {
                case DOMAIN: {
                    Messages.showErrorDialog((String)GrailsBundle.message("generate.domain.class.first", this.myArtifactName), (String)GrailsBundle.message("no.domain.class.found", new Object[0]));
                    break;
                }
                case CONTROLLER: {
                    Messages.showErrorDialog((String)GrailsBundle.message("generate.controller.first", this.myArtifactName), (String)GrailsBundle.message("no.controller.found", new Object[0]));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return;
        }
        String qualifiedName = testedClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        MvcCommand mvcCommand = new MvcCommand(this.myIntegration ? "create-integration-test" : "create-unit-test", new String[]{qualifiedName});
        GrailsCommandExecutorUtil.execute(application, mvcCommand, () -> {
            if (!testedClass.isValid()) {
                return;
            }
            PsiClass testClass = this.findTestClass(testedClass);
            if (testClass != null) {
                testClass.navigate(true);
            }
        }, true, new String[0]);
    }

    @Nullable
    private PsiClass findTestClass(PsiClass testedClass) {
        for (PsiClass aClass : GrailsTestUtils.getTestsForArtifact(testedClass, true)) {
            String testType = GrailsTestUtils.getTestType(aClass);
            if (!(this.myIntegration ? "integration".equals(testType) : "unit".equals(testType))) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private PsiClass getTestedClass(@NotNull Module module) {
        Collection<GrClassDefinition> instances;
        if (module == null) {
            GenerateTestsAction.$$$reportNull$$$0(2);
        }
        if ((instances = this.myArtifactType.getInstances(module, this.myArtifactName)).isEmpty()) {
            return null;
        }
        return (PsiClass)instances.iterator().next();
    }

    private boolean isEnabled(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null || !GrailsUtils.hasSupport(module)) {
            return false;
        }
        PsiClass testedClass = this.getTestedClass(module);
        if (testedClass == null) {
            return false;
        }
        return this.findTestClass(testedClass) == null;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation;
        if (e == null) {
            GenerateTestsAction.$$$reportNull$$$0(3);
        }
        if (!(presentation = e.getPresentation()).isEnabled()) {
            return;
        }
        if (!this.isEnabled(e)) {
            presentation.setEnabledAndVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/editor/GenerateTestsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestedClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

