/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.GrailsGenerateViewAction;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GenerateViewIntention
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(GenerateViewIntention.class);

    @NotNull
    public String getText() {
        String string = GrailsBundle.message("intention.text.create.view.gsp.page", new Object[0]);
        if (string == null) {
            GenerateViewIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            GenerateViewIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static Pair<PsiClass, String> getActionController(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethod) && !(element instanceof GrField)) {
            return null;
        }
        PsiMember member = (PsiMember)element;
        if (!GrailsArtifact.CONTROLLER.isInstance(member.getContainingClass())) {
            return null;
        }
        return GrailsGenerateViewAction.getActionControllerToGenerate(member);
    }

    @Nullable
    private static PsiElement getElementAtCaret(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        return element.getParent();
    }

    @Nullable
    private static Trinity<PsiClass, String, String> getWebFlowState(@Nullable PsiElement element) {
        GrMethodCall stateDeclarration;
        if (!(element instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof GrMethodCall && WebFlowUtils.isStateDeclaration(stateDeclarration = (GrMethodCall)parent, true)) {
            GrField actionField = WebFlowUtils.getActionByStateDeclaration(stateDeclarration);
            PsiClass controller = actionField.getContainingClass();
            String stateName = WebFlowUtils.getStateNameByStateDeclaration(stateDeclarration);
            String actionName = StringUtil.trimEnd((String)actionField.getName(), (String)"Flow");
            return Trinity.create((Object)controller, (Object)actionName, (Object)stateName);
        }
        return null;
    }

    private static boolean isEnabledWebFlowCreateViewAction(@Nullable Trinity<PsiClass, String, String> trinity) {
        if (trinity == null) {
            return false;
        }
        VirtualFile controllerViewFolder = GrailsUtils.getControllerGspDir((PsiClass)trinity.first);
        if (controllerViewFolder == null) {
            return true;
        }
        VirtualFile flowDir = controllerViewFolder.findChild((String)trinity.second);
        if (flowDir == null) {
            return true;
        }
        if (!flowDir.isDirectory()) {
            return false;
        }
        return flowDir.findChild((String)trinity.third + ".gsp") == null && flowDir.findChild((String)trinity.third + ".jsp") == null;
    }

    private static void createWebFlowView(PsiClass controller, String actionName, String stateName) {
        VirtualFile grailsApp = GrailsArtifact.CONTROLLER.getGrailsApp(controller);
        if (grailsApp == null) {
            return;
        }
        try {
            PsiDirectory psiDirectory;
            VirtualFile actionFlowFolder;
            String controllerName;
            VirtualFile controllerGspFolder;
            VirtualFile viewDirectory = grailsApp.findChild("views");
            if (viewDirectory == null) {
                viewDirectory = grailsApp.createChildDirectory(null, "views");
            }
            if ((controllerGspFolder = viewDirectory.findChild(controllerName = GrailsArtifact.CONTROLLER.getArtifactName(controller))) == null) {
                controllerGspFolder = viewDirectory.createChildDirectory(null, controllerName);
            }
            if ((actionFlowFolder = controllerGspFolder.findChild(actionName)) == null) {
                actionFlowFolder = controllerGspFolder.createChildDirectory(null, actionName);
            }
            if ((psiDirectory = controller.getManager().findDirectory(actionFlowFolder)) == null) {
                return;
            }
            String viewName = stateName + ".gsp";
            PsiFile psiFile = GroovyTemplatesFactory.createFromTemplate((PsiDirectory)psiDirectory, (String)viewName, (String)viewName, (String)"Groovy Server Page.gsp", (boolean)true, (String[])new String[0]);
            if (psiFile == null) {
                return;
            }
            psiFile.navigate(true);
        }
        catch (IOException e1) {
            LOG.warn((Throwable)e1);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element;
        if (project == null) {
            GenerateViewIntention.$$$reportNull$$$0(2);
        }
        return GrailsGenerateViewAction.isEnabled(GenerateViewIntention.getActionController(element = GenerateViewIntention.getElementAtCaret(editor, file))) || GenerateViewIntention.isEnabledWebFlowCreateViewAction(GenerateViewIntention.getWebFlowState(element));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        Trinity<PsiClass, String, String> trinity;
        if (project == null) {
            GenerateViewIntention.$$$reportNull$$$0(3);
        }
        if ((trinity = GenerateViewIntention.getWebFlowState(element = GenerateViewIntention.getElementAtCaret(editor, file))) != null) {
            GenerateViewIntention.createWebFlowView((PsiClass)trinity.first, (String)trinity.second, (String)trinity.third);
            return;
        }
        Pair<PsiClass, String> pair = GenerateViewIntention.getActionController(element);
        GrailsGenerateViewAction.createAction(pair);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/actions/GenerateViewIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/actions/GenerateViewIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

