/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import a.b.lb;
import java.math.BigInteger;

public class RSAEncoder {
    private final BigInteger g;
    private final BigInteger b;
    private final int f;
    private final int a;
    private int e = 0;
    private final BigInteger d;
    private final boolean c;
    private static final long h = lb.a(4948343739507454291L, 2310652242603736827L, null).a(269541638211524L);

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.g = privateExponent;
        this.b = privateModulus;
        this.c = addDashes;
        int n2 = privateModulus.bitLength();
        this.d = new BigInteger(String.valueOf(alphabetSize));
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.a = n3;
        this.f = n2 / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] byArray;
        long l2 = h ^ 0x77E3F805905CL;
        long l3 = l2 ^ 0x5231512E1B02L;
        int n2 = (int)(l3 >>> 48);
        int n3 = (int)(l3 << 16 >>> 48);
        int n4 = (int)(l3 << 32 >>> 32);
        int n5 = data.length % this.f;
        if (n5 == 0) {
            byArray = data;
        } else {
            byArray = new byte[data.length + this.f - n5];
            System.arraycopy(data, 0, byArray, this.f - n5, data.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < byArray.length; i10 += this.f) {
            this.a(byArray, stringBuilder, (short)n2, (char)n3, i10, this.f, n4);
        }
        return stringBuilder.toString();
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, short s2, char c10, int n2, int n3, int n4) {
        long l2 = ((long)s2 << 48 | (long)c10 << 48 >>> 16 | (long)n4 << 32 >>> 32) ^ h;
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.f];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.b) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.g, this.b);
        this.a(stringBuilder, this.b(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i10));
        }
    }

    private CharSequence b(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.a; ++i10) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.d)));
            bigInteger = bigInteger.divide(this.d);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.e > 0 && this.e % 5 == 0) {
            if (this.e % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.c) {
                stringBuilder.append('-');
            }
        }
        ++this.e;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c10 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c10;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence sequence) {
            this.a = sequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int index) {
            return this.a.charAt(this.a.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int n2 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n2 - end, n2 - start2));
        }
    }
}

