/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.requests;

import a.b.lb;
import com.jetbrains.ls.requests.AbstractObtainTicketRequest;
import com.jetbrains.ls.responses.ObtainPermanentTicketGroupResponse;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ObtainPermanentTicketGroupRequest
extends AbstractObtainTicketRequest<ObtainPermanentTicketGroupResponse> {
    public static final String ACTION_NAME = "obtainPermanentTicketGroup.action";
    private String o;
    private String n;
    private Collection<ProductSelector> p;
    private static final long q = lb.a(-5749124077416157624L, 4440237319378739297L, MethodHandles.lookup().lookupClass()).a(9420796701314L);

    public ObtainPermanentTicketGroupRequest() {
    }

    public ObtainPermanentTicketGroupRequest(long salt, Collection<ProductSelector> productSelectors, String machineId, String hostName, String userName, String email, String activationCode) {
        super(salt, ObtainPermanentTicketGroupRequest.a(productSelectors), machineId, hostName, userName, 0, 0, false);
        this.o = email;
        this.n = activationCode;
        this.p = productSelectors;
    }

    public String getEmail() {
        return this.o;
    }

    public void setEmail(String email) {
        this.o = email;
    }

    public String getActivationCode() {
        return this.n;
    }

    public void setActivationCode(String activationCode) {
        this.n = activationCode;
    }

    public String getProductSelectors() {
        if (this.p == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : this.p) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.toString());
        }
        return stringBuilder.toString();
    }

    public void setProductSelectors(String selectors) {
        ArrayList<ProductSelector> arrayList = new ArrayList<ProductSelector>();
        if (selectors != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(selectors, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                ProductSelector productSelector = ProductSelector.fromString(string, 0);
                if (productSelector == null) continue;
                arrayList.add(productSelector);
            }
        }
        this.p = arrayList.isEmpty() ? null : arrayList;
    }

    @NotNull
    public Collection<ProductSelector> getAllProductSelectors() {
        return this.p == null ? Collections.emptyList() : this.p;
    }

    @Override
    public String getActionName() {
        long l2 = q ^ 0x479922FD9599L;
        return ACTION_NAME;
    }

    private static String a(Collection<ProductSelector> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.getProductFamilyId());
        }
        return stringBuilder.toString();
    }

    public static final class ProductSelector {
        public final String productFamilyId;
        public final int version;
        public final int buildDate;
        public final String edition;
        private static final long a = lb.a(231305949390754119L, 4937469769955597696L, MethodHandles.lookup().lookupClass()).a(265439700039776L);

        public ProductSelector(String productFamilyId, int version, int buildDate, String edition) {
            long l2 = a ^ 0xB5D912E727L;
            this.productFamilyId = productFamilyId;
            this.version = version;
            this.buildDate = buildDate;
            this.edition = edition == null || edition.length() == 0 || "null".equalsIgnoreCase(edition) ? null : edition;
        }

        public String getProductFamilyId() {
            return this.productFamilyId;
        }

        public int getVersion() {
            return this.version;
        }

        public int getBuildDate() {
            return this.buildDate;
        }

        public String getEdition() {
            return this.edition;
        }

        public String toString() {
            return "{" + this.productFamilyId + "|" + this.version + "|" + this.buildDate + "|" + this.edition + "}";
        }

        public static ProductSelector fromString(String str, int start2) {
            int n2;
            if (start2 >= str.length()) {
                return null;
            }
            if (str.charAt(start2) != '{') {
                return null;
            }
            if ((n2 = str.indexOf(124, ++start2)) < 0) {
                return null;
            }
            String string = str.substring(start2, n2).trim();
            start2 = n2 + 1;
            if ((n2 = str.indexOf(124, start2)) < 0) {
                return null;
            }
            String string2 = str.substring(start2, n2).trim();
            start2 = n2 + 1;
            if ((n2 = str.indexOf(124, start2)) < 0) {
                return null;
            }
            String string3 = str.substring(start2, n2).trim();
            start2 = n2 + 1;
            if ((n2 = str.indexOf(125, start2)) < 0) {
                return null;
            }
            String string4 = str.substring(start2, n2).trim();
            try {
                return new ProductSelector(string, Integer.parseInt(string2), Integer.parseInt(string3), string4);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

