/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.b.lb;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTableModel
extends AbstractTableModel {
    public static final int LIB_ENABLED_COL = 0;
    public static final int LIB_NAME_COL = 1;
    public static final int LIB_TYPE_COL = 2;
    private final ScriptingLibraryManager d;
    private LibraryScope[] c;
    private final ScriptingLibraryMappings a;
    private boolean b;
    private static final long e = lb.a(-4585771868187119680L, 5038244047749078630L, MethodHandles.lookup().lookupClass()).a(202201900606460L);

    public ScriptingLibraryTableModel(ScriptingLibraryManager libManager, ScriptingLibraryMappings mappings) {
        this.d = libManager;
        this.a = mappings;
        this.b = false;
        this.c = this.getLibrariesScopes();
    }

    public void resetTable() {
        this.a.reset();
        this.c = this.getLibrariesScopes();
        this.b = false;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.c.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LibraryScope libraryScope = this.c[rowIndex];
        assert (libraryScope != null);
        switch (columnIndex) {
            case 0: {
                return libraryScope.myState;
            }
            case 1: {
                return libraryScope.myLibrary.getName();
            }
            case 2: {
                return ScriptingLibraryTableModel.getLibraryLevelName(libraryScope.myLibrary.getLibraryLevel());
            }
        }
        return "?";
    }

    public static String getLibraryLevelName(@NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        long l2 = e ^ 0xB59B84E967BL;
        if (libraryLevel == null) {
            ScriptingLibraryTableModel.a(0);
        }
        switch (libraryLevel) {
            case PREDEFINED: {
                return WebCoreBundle.message((String)"library.level.predefined.name", (Object[])new Object[0]);
            }
            case GLOBAL: {
                return WebCoreBundle.message((String)"library.level.global.name", (Object[])new Object[0]);
            }
            case PROJECT: {
                return WebCoreBundle.message((String)"library.level.project.name", (Object[])new Object[0]);
            }
        }
        throw new IllegalStateException("Unknown library level: " + libraryLevel);
    }

    @NotNull
    public static String getLongestLibraryLevelName() {
        String string = "";
        for (ScriptingLibraryModel.LibraryLevel libraryLevel : ScriptingLibraryModel.LibraryLevel.values()) {
            String string2 = ScriptingLibraryTableModel.getLibraryLevelName(libraryLevel);
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        String string3 = string;
        if (string3 == null) {
            ScriptingLibraryTableModel.a(1);
        }
        return string3;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.b = true;
        if (columnIndex == 0 && aValue instanceof Boolean) {
            LibraryScope libraryScope = this.c[rowIndex];
            libraryScope.myState = Boolean.TRUE.equals(aValue) ? EnabledState.ON : EnabledState.OFF;
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        long l2 = e ^ 0x24CFEA550C68L;
        switch (column) {
            case 0: {
                return WebCoreBundle.message((String)"library.table.enabled.column.name", (Object[])new Object[0]);
            }
            case 1: {
                return WebCoreBundle.message((String)"library.table.name.column.name", (Object[])new Object[0]);
            }
            case 2: {
                return WebCoreBundle.message((String)"library.table.type.column.name", (Object[])new Object[0]);
            }
        }
        throw new IllegalStateException("Unknown column: " + column);
    }

    public void applyChanges() {
        Set set = this.a.getMappings().keySet();
        for (LibraryScope libraryScope : this.c) {
            String string = libraryScope.myLibrary.getName();
            if (libraryScope.myState == EnabledState.ON && !this.a.isAssociatedWithProject(string)) {
                this.a.associate(null, string, libraryScope.myLibrary.isPredefined());
                continue;
            }
            if (libraryScope.myState != EnabledState.OFF) continue;
            this.a.disassociate(null, string);
            for (VirtualFile virtualFile : set) {
                if (!this.a.isAssociatedWith(virtualFile, string)) continue;
                this.a.disassociate(virtualFile, string);
            }
        }
    }

    public void applyMappings() {
        Map map2 = this.a.getMappings();
        for (Map.Entry entry : map2.entrySet()) {
            if (!(entry.getValue() instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)entry.getValue();
            List list2 = ContainerUtil.map((Collection)compoundLibrary.getLibraries(), scriptingLibraryModel -> scriptingLibraryModel.getName());
            for (LibraryScope libraryScope : this.c) {
                if (libraryScope.myState == EnabledState.OFF && list2.contains(libraryScope.myLibrary.getName())) {
                    compoundLibrary.toggleLibrary(libraryScope.myLibrary);
                    continue;
                }
                if (libraryScope.myState != EnabledState.ON || entry.getKey() != null || list2.contains(libraryScope.myLibrary.getName())) continue;
                compoundLibrary.toggleLibrary(libraryScope.myLibrary);
            }
        }
    }

    public ScriptingLibraryModel createLibrary(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel level, boolean isOnByDefault) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.d.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
            this.fireLibTableChanged(true);
            for (int i10 = 0; i10 < this.c.length; ++i10) {
                LibraryScope libraryScope = this.c[i10];
                if (libraryScope.myLibrary != scriptingLibraryModel) continue;
                this.setValueAt(Boolean.TRUE, i10, 0);
                break;
            }
            return scriptingLibraryModel;
        });
    }

    @Nullable
    public ScriptingLibraryModel getLibrary(String name) {
        ScriptingLibraryTable scriptingLibraryTable = this.d.getScriptingLibraryTable();
        return scriptingLibraryTable.getLibraryByName(name);
    }

    public int getLibraryIndex(String name) {
        int n2 = 0;
        for (LibraryScope libraryScope : this.c) {
            if (libraryScope.myLibrary.getName().equals(name)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeLibrary(String name) {
        ScriptingLibraryModel scriptingLibraryModel = this.getLibrary(name);
        if (scriptingLibraryModel != null) {
            this.d.removeLibrary(scriptingLibraryModel);
            this.fireLibTableChanged(true);
        }
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String oldName, String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.d.updateLibrary(oldName, name, sourceFiles, compactFiles, docUrls);
            this.b = true;
            this.fireTableDataChanged();
            return scriptingLibraryModel;
        });
    }

    public void fireLibTableChanged(boolean keepMappings) {
        this.b = true;
        LibraryScope[] libraryScopeArray = this.getLibrariesScopes();
        if (keepMappings) {
            for (LibraryScope libraryScope : libraryScopeArray) {
                for (LibraryScope libraryScope2 : this.c) {
                    if (!libraryScope2.myLibrary.getName().equals(libraryScope.myLibrary.getName())) continue;
                    libraryScope.myState = libraryScope2.myState;
                }
            }
        }
        this.c = libraryScopeArray;
        this.fireTableDataChanged();
    }

    @Nullable
    public String getLibNameAt(int row) {
        ScriptingLibraryModel scriptingLibraryModel = this.c[row].myLibrary;
        return scriptingLibraryModel != null ? scriptingLibraryModel.getName() : null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryAt(int row) {
        return this.c[row].myLibrary;
    }

    public boolean isChanged() {
        return this.b;
    }

    private static ScriptingLibraryModel[] a(ScriptingLibraryTable scriptingLibraryTable) {
        ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel scriptingLibraryModel3 : scriptingLibraryTable.getAllLibraries()) {
            if (scriptingLibraryModel3 == null) continue;
            arrayList.add(scriptingLibraryModel3);
        }
        arrayList.sort((scriptingLibraryModel, scriptingLibraryModel2) -> {
            if (scriptingLibraryModel.isPredefined() != scriptingLibraryModel2.isPredefined()) {
                return (scriptingLibraryModel.isPredefined() ? 1 : 0) - (scriptingLibraryModel2.isPredefined() ? 1 : 0);
            }
            return scriptingLibraryModel.getName().compareToIgnoreCase(scriptingLibraryModel2.getName());
        });
        return arrayList.toArray(ScriptingLibraryModel.EMPTY_ARRAY);
    }

    public LibraryScope[] getLibrariesScopes() {
        Object object;
        Object object2;
        Map map2 = this.a.getMappings();
        HashMap<String, HashSet<VirtualFile>> hashMap = new HashMap<String, HashSet<VirtualFile>>();
        for (Map.Entry libraryScopeArray2 : map2.entrySet()) {
            VirtualFile i10 = (VirtualFile)libraryScopeArray2.getKey();
            object2 = (ScriptingLibraryModel)libraryScopeArray2.getValue();
            if (!(object2 instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            object = (ScriptingLibraryMappings.CompoundLibrary)object2;
            Collection collection = object.getLibraries();
            VirtualFile virtualFile = collection.iterator();
            while (virtualFile.hasNext()) {
                ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)virtualFile.next();
                HashSet<VirtualFile> hashSet = (HashSet<VirtualFile>)hashMap.get(scriptingLibraryModel.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<VirtualFile>();
                    hashMap.put(scriptingLibraryModel.getName(), hashSet);
                }
                hashSet.add(i10);
            }
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryTableModel.a(this.d.getScriptingLibraryTable());
        LibraryScope[] libraryScopeArray = new LibraryScope[scriptingLibraryModelArray.length];
        for (int i10 = 0; i10 < scriptingLibraryModelArray.length; ++i10) {
            object2 = EnabledState.OFF;
            object = scriptingLibraryModelArray[i10].getName();
            if (hashMap.containsKey(object)) {
                if (this.a.isAssociatedWithProject((String)object)) {
                    object2 = EnabledState.ON;
                } else {
                    for (VirtualFile virtualFile : (Set)hashMap.get(object)) {
                        if (virtualFile == null) continue;
                        object2 = EnabledState.PARTLY;
                        break;
                    }
                }
            }
            libraryScopeArray[i10] = new LibraryScope(scriptingLibraryModelArray[i10], (EnabledState)((Object)object2));
        }
        return libraryScopeArray;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x781F48B32830L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryLevel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ScriptingLibraryTableModel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibraryTableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongestLibraryLevelName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryLevelName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LibraryScope {
        public ScriptingLibraryModel myLibrary;
        public EnabledState myState;

        private LibraryScope(ScriptingLibraryModel library, EnabledState state) {
            this.myLibrary = library;
            this.myState = state;
        }
    }

    public static final class EnabledState
    extends Enum<EnabledState> {
        public static final /* enum */ EnabledState ON;
        public static final /* enum */ EnabledState PARTLY;
        public static final /* enum */ EnabledState OFF;
        private static final /* synthetic */ EnabledState[] a;

        public static EnabledState[] values() {
            return (EnabledState[])a.clone();
        }

        public static EnabledState valueOf(String name) {
            return Enum.valueOf(EnabledState.class, name);
        }

        static {
            long l2 = lb.a(1395211937921037261L, 6124025575812151008L, MethodHandles.lookup().lookupClass()).a(203963832746386L) ^ 0x6AEFA056757CL;
            ON = new EnabledState();
            PARTLY = new EnabledState();
            OFF = new EnabledState();
            a = new EnabledState[]{ON, PARTLY, OFF};
        }
    }
}

