/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.b.lb;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibrariesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private static final int w = 0;
    private static final int k = 1;
    private final String n;
    private final String l;
    private static final Comparator<VirtualFilePointer> h;
    private JPanel s;
    private JTextField b;
    private final JBTable t;
    private final JBList<String> m;
    private JComboBox q;
    private JTextField e;
    private JRadioButton v;
    private JRadioButton i;
    private JPanel r;
    private JPanel g;
    private final Project u;
    private final FileTableModel p;
    private final LangScriptingContextProvider x;
    private final MyDocUrlListModel y;
    private ScriptingFrameworkDescriptor o;
    private final Icon d;
    private final Icon j;
    private final AnActionButton a;
    private final AnActionButton c;
    private final FileChooserDescriptor f;
    private static final long z;

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project) {
        long l2 = z ^ 0x44CB378044D8L;
        super(true);
        this.b();
        this.f = new FileChooserDescriptor(this, true, true, false, true, false, true){
            final /* synthetic */ EditLibraryDialog this$0;
            private static final long a = lb.a(-2396261774229905335L, 2619947409820971286L, MethodHandles.lookup().lookupClass()).a(203284705375243L);
            {
                long l2 = a ^ 0x37AEE56C6650L;
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5);
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile file) {
                if (!file.isDirectory() && !this.this$0.x.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && !this.this$0.x.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileVisible(file, showHiddenFiles);
            }
        };
        this.d = provider.getFileIcon();
        this.j = AllIcons.Nodes.Folder;
        this.x = provider;
        this.u = project;
        this.t = new JBTable();
        this.t.setShowGrid(false);
        this.t.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.t).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List<AnAction> list2 = EditLibraryDialog.this.j();
                if (list2.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2.toArray(AnAction.EMPTY_ARRAY));
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                RelativePoint relativePoint = button.getPreferredPopupPoint();
                if (relativePoint != null) {
                    listPopup.show(relativePoint);
                } else {
                    listPopup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.d();
            }
        }).createPanel();
        this.r.add((Component)jPanel, "Center");
        this.setTitle(title);
        this.n = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.SOURCES));
        this.l = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.CLASSES));
        this.p = new FileTableModel();
        this.t.setRowHeight((int)((double)this.t.getRowHeight() * 1.2));
        this.t.setModel((TableModel)this.p);
        new TableSpeedSearch((JTable)this.t);
        this.y = new MyDocUrlListModel();
        this.m = new JBList((ListModel)this.y);
        this.y.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e10) {
                EditLibraryDialog.this.m();
            }

            @Override
            public void intervalRemoved(ListDataEvent e10) {
                Object object = e10.getSource();
                if (object instanceof MyDocUrlListModel && ((MyDocUrlListModel)object).getDocUrls().length == 0) {
                    EditLibraryDialog.this.m();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e10) {
            }
        });
        this.m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                EditLibraryDialog.this.c.setEnabled(EditLibraryDialog.this.m.getSelectedIndex() >= 0);
            }
        });
        this.a = new AnActionButton(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.download", (Object[])new Object[0]), AllIcons.Actions.Download){
            private static final long a = lb.a(7163610290901381066L, 4544694191673672026L, MethodHandles.lookup().lookupClass()).a(30784256329452L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    5.a(0);
                }
                EditLibraryDialog.this.n();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x71ED18951016L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
            }
        };
        this.c = new AnActionButton(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.edit", (Object[])new Object[0]), AllIcons.Actions.Edit){
            private static final long a = lb.a(7015431061092293403L, 1026501260041390957L, MethodHandles.lookup().lookupClass()).a(38354961577891L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(0);
                }
                EditLibraryDialog.this.i();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2A1C244598C1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
            }
        };
        this.g.add((Component)ToolbarDecorator.createDecorator(this.m).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.e();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.k();
            }
        }).addExtraAction(this.c).addExtraAction(this.a).createPanel(), "Center");
        this.a.setEnabled(false);
        this.c.setEnabled(false);
        this.f();
        this.e.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e10) {
                EditLibraryDialog.this.l();
            }
        });
        this.init();
        TableColumn tableColumn = this.t.getColumnModel().getColumn(1);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, JBUI.scale((int)80));
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel a = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.p.a(row);
                VirtualFile virtualFile = EditLibraryDialog.b(virtualFilePointer);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.a.setText("");
                    this.a.setIcon(null);
                } else {
                    this.a.setText(String.valueOf(value));
                    if (isSelected) {
                        this.a.setSelectionIcon();
                    } else {
                        this.a.setRegularIcon();
                    }
                }
                this.a.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.a.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                return this.a;
            }
        });
        TableColumn tableColumn2 = this.t.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> j() {
        long l2 = z ^ 0x1019789FC9C4L;
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.d){
            private static final long a = lb.a(-8352191954341443422L, -7527953966813450863L, MethodHandles.lookup().lookupClass()).a(132528621765620L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    11.a(0);
                }
                EditLibraryDialog.this.g();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3079B51BA108L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.j){
            private static final long a = lb.a(3794378054470587400L, -8400791834764259177L, MethodHandles.lookup().lookupClass()).a(120804758097690L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    12.a(0);
                }
                EditLibraryDialog.this.c();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x32BA871CEF17L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            EditLibraryDialog.a(0);
        }
        return arrayList;
    }

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project, ScriptingLibraryModel lib) {
        this(title, provider, project);
        this.b.setText(lib.getName());
        this.p.setFiles(lib.getSourceFilePointers(), lib.getCompactFilePointers());
        Set set = lib.getDocUrls();
        this.y.setDocUrls(set);
        if (lib.getFrameworkDescriptor() != null) {
            this.a(lib.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.v);
        buttonGroup.add(this.i);
        if (lib.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.i.setSelected(true);
        } else {
            this.v.setSelected(true);
        }
        this.m();
    }

    private void a(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.o = scriptingFrameworkDescriptor;
        this.e.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i10 = 0; i10 < this.q.getItemCount(); ++i10) {
            Object e10 = this.q.getItemAt(i10);
            if (!(e10 instanceof ScriptingFrameworkDescriptor) || !scriptingFrameworkDescriptor.getFrameworkName().equals(((ScriptingFrameworkDescriptor)e10).getFrameworkName())) continue;
            this.q.setSelectedItem(e10);
        }
    }

    private void m() {
        for (String string : this.getDocUrls()) {
            if (this.x.getOfflineDocUrl(string) == null) continue;
            this.a.setEnabled(true);
            return;
        }
        this.a.setEnabled(false);
    }

    private void f() {
        long l2 = z ^ 0x149676860463L;
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = this.x.getSupportedFrameworks(this.u);
        arrayList.add(new String("<Custom>"));
        if (scriptingFrameworkDescriptorArray != null) {
            arrayList.addAll(Arrays.asList(scriptingFrameworkDescriptorArray));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(arrayList));
        this.q.setModel(defaultComboBoxModel);
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                Object object = EditLibraryDialog.this.q.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.o == null || !string.equals(EditLibraryDialog.this.o.getFrameworkName())) {
                        EditLibraryDialog.this.o = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.e.setText("");
                    }
                } else {
                    EditLibraryDialog.this.o = null;
                    EditLibraryDialog.this.e.setText("");
                }
            }
        });
    }

    private void n() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getDocUrls()) {
            String string2 = this.x.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.a(new LinkedList<String>(linkedHashSet), this.getRootPane());
    }

    private void a(@NotNull Queue<String> queue, @Nullable Component component2) {
        if (queue == null) {
            EditLibraryDialog.a(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = queue.poll();
        if (string != null) {
            this.x.downloadOfflineDoc(this.u, string, component2, (Consumer<? super File>)((Consumer)file -> {
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.y.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.a(queue, component2);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.s;
    }

    public String getLibName() {
        return this.b.getText();
    }

    private void g() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.f, (Project)this.u, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.a(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void c() {
        long l2 = z ^ 0x197371F48335L;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.u, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void a(@NotNull List<VirtualFile> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(2);
        }
        this.b(ContainerUtil.map(list2, virtualFile -> new LightFilePointer(virtualFile)));
    }

    private void b(@NotNull List<VirtualFilePointer> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(3);
        }
        list2.sort(h);
        int n2 = 0;
        for (VirtualFilePointer virtualFilePointer2 : list2) {
            this.a(virtualFilePointer2, n2++ == list2.size() - 1);
        }
        this.h();
        if (this.b.getText().isEmpty() && !list2.isEmpty()) {
            list2.stream().map(virtualFilePointer -> virtualFilePointer.getFileName()).findFirst().ifPresent(string -> this.b.setText((String)string));
        }
    }

    private void a(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private static final long a = lb.a(8757525476467130634L, -4462083268953980061L, MethodHandles.lookup().lookupClass()).a(165568399665940L);

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    14.a(0);
                }
                if (file.isValid() && !file.isDirectory() && EditLibraryDialog.this.x.acceptsExtension(file.getExtension())) {
                    collection.add(file);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5EED1921C803L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
            }
        });
    }

    private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
        if (virtualFilePointer == null) {
            EditLibraryDialog.a(4);
        }
        int n2 = this.p.a(virtualFilePointer);
        this.t.setRowSelectionInterval(n2, n2);
        if (bl2) {
            TableUtil.scrollSelectionToVisible((JTable)this.t);
        }
    }

    @Nullable
    private static VirtualFile b(@Nullable VirtualFilePointer virtualFilePointer) {
        return virtualFilePointer != null ? virtualFilePointer.getFile() : null;
    }

    private void d() {
        int[] nArray = this.t.getSelectedRows();
        ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
        for (int n2 : nArray) {
            arrayList.add(this.p.a(n2));
        }
        this.p.a(arrayList);
    }

    @NotNull
    public List<String> getSourceFileUrls() {
        List list2 = ContainerUtil.map(this.p.a(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(5);
        }
        return list2;
    }

    @NotNull
    public List<String> getCompactFileUrls() {
        List list2 = ContainerUtil.map(this.p.getCompactFilePointers(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(6);
        }
        return list2;
    }

    public String[] getDocUrls() {
        return this.y.getDocUrls();
    }

    protected void doOKAction() {
        long l2 = z ^ 0xECF92745FFFL;
        if (!EditLibraryDialog.b(this.b.getText())) {
            Messages.showErrorDialog((Project)this.u, (String)WebCoreBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)WebCoreBundle.message((String)"dialog.title.error", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
    }

    private static boolean b(String string) {
        long l2 = z ^ 0x52C31C5C9E57L;
        return string != null && string.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void i() {
        String string = (String)this.m.getSelectedValue();
        int n2 = this.m.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.s, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.y.replaceUrl(string, string2);
            this.m.ensureIndexIsVisible(n2);
            this.m.setSelectedIndex(n2);
            this.m();
        }
    }

    private void e() {
        VirtualFile virtualFile;
        String string = null;
        if (this.o == null) {
            this.h();
        }
        if (this.o != null) {
            string = this.a();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.s, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.y.addUrl(string2);
            this.m.ensureIndexIsVisible(n2);
            this.m.setSelectedIndex(n2);
            this.m();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.b;
    }

    @Nullable
    private String a() {
        String string = this.x.getDefaultDocUrl(this.o);
        if (string != null && !this.y.contains(string)) {
            return string;
        }
        return null;
    }

    private void k() {
        this.y.remove((String)this.m.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.o;
    }

    private void h() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ContainerUtil.map(this.p.getCompactFilePointers(), virtualFilePointer -> virtualFilePointer.getFile()));
        arrayList.addAll(ContainerUtil.map(this.p.a(), virtualFilePointer -> virtualFilePointer.getFile()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.x.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.e.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.a(scriptingFrameworkDescriptor);
            if (this.b.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.b.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void l() {
        if (this.o != null) {
            this.o.setFrameworkVersion(this.e.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.i.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.a(7);
        }
        return libraryLevel;
    }

    static {
        z = lb.a(8199596179719880519L, 5011601012156765774L, MethodHandles.lookup().lookupClass()).a(64851208149172L);
        h = (virtualFilePointer, virtualFilePointer2) -> virtualFilePointer.getUrl().compareToIgnoreCase(virtualFilePointer2.getUrl());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = z ^ 0x6A7256E98EF8L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactFileUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilePointers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSingleFilePointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void b() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        long l2 = z ^ 0x167DBF2E6321L;
        this.s = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.b = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.framework_type.name"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.q = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.a(jLabel3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.version.name"));
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.e = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        this.a(jLabel4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.visibility.name"));
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.v = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.a(jRadioButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.project.name"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.i = jRadioButton = new JRadioButton();
        this.a(jRadioButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.global.name"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.r = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.g = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.s;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c10);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel<String> {
        private final List<String> a = new ArrayList<String>();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> urls) {
            if (urls != null && urls.size() > 0) {
                this.a.addAll(urls);
            }
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.a.get(index);
        }

        public int addUrl(String url) {
            if (!this.a.contains(url)) {
                this.a.add(url);
                int n2 = this.a.indexOf(url);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.a.indexOf(url);
        }

        public void replaceUrl(String oldUrl, String newUrl) {
            if (oldUrl == null || !this.a.contains(oldUrl)) {
                return;
            }
            int n2 = this.a.indexOf(oldUrl);
            this.a.remove(oldUrl);
            this.a.add(n2, newUrl);
        }

        public int indexOf(String url) {
            return this.a.indexOf(url);
        }

        public void remove(String url) {
            if (url == null || !this.a.contains(url)) {
                return;
            }
            int n2 = this.a.indexOf(url);
            this.a.remove(url);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String url) {
            return this.a.contains(url);
        }

        public String[] getDocUrls() {
            return ArrayUtilRt.toStringArray(this.a);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFilePointer> a = new SortedList(h);
        private final Set<VirtualFilePointer> b = new HashSet<VirtualFilePointer>();
        private static final long c = lb.a(5583139334262002059L, -4274858598386061818L, MethodHandles.lookup().lookupClass()).a(48016956903486L);

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            long l2 = c ^ 0x5B4FF6695EB0L;
            switch (column) {
                case 0: {
                    return WebCoreBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return WebCoreBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            VirtualFile virtualFile;
            return columnIndex == 1 && (virtualFile = EditLibraryDialog.b(virtualFilePointer = this.a(rowIndex))) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            if (columnIndex == 1 && (virtualFilePointer = EditLibraryDialog.this.p.a(rowIndex)) != null && aValue instanceof String) {
                this.a(virtualFilePointer, EditLibraryDialog.this.l.equals(aValue));
            }
        }

        private int a(@NotNull VirtualFilePointer virtualFilePointer) {
            int n2;
            if (virtualFilePointer == null) {
                FileTableModel.b(0);
            }
            if ((n2 = this.a.indexOf((Object)virtualFilePointer)) == -1) {
                this.a.add((Object)virtualFilePointer);
                VirtualFile virtualFile = virtualFilePointer.getFile();
                if (virtualFile != null && !virtualFile.isDirectory() && EditLibraryDialog.this.x.isCompact(virtualFile)) {
                    this.b.add(virtualFilePointer);
                }
                this.fireTableDataChanged();
                n2 = this.a.indexOf((Object)virtualFilePointer);
            }
            return n2;
        }

        public void setFiles(@NotNull Set<VirtualFilePointer> sourceFilePointers, @NotNull Set<VirtualFilePointer> compactFilePointers) {
            if (sourceFilePointers == null) {
                FileTableModel.b(1);
            }
            if (compactFilePointers == null) {
                FileTableModel.b(2);
            }
            this.a.clear();
            this.a.addAll(sourceFilePointers);
            this.a.addAll(compactFilePointers);
            for (VirtualFilePointer virtualFilePointer : sourceFilePointers) {
                this.a(virtualFilePointer, false, false);
            }
            for (VirtualFilePointer virtualFilePointer : compactFilePointers) {
                this.a(virtualFilePointer, true, false);
            }
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
            if (virtualFilePointer == null) {
                FileTableModel.b(3);
            }
            this.a(virtualFilePointer, bl2, true);
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2, boolean bl3) {
            if (virtualFilePointer == null) {
                FileTableModel.b(4);
            }
            boolean bl4 = false;
            VirtualFile virtualFile = virtualFilePointer.getFile();
            if (virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()) {
                bl2 = false;
            }
            if (bl2) {
                if (!this.b.contains(virtualFilePointer)) {
                    this.b.add(virtualFilePointer);
                    bl4 = true;
                }
            } else if (this.b.contains(virtualFilePointer)) {
                this.b.remove(virtualFilePointer);
                bl4 = true;
            }
            if (bl4 && bl3) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)this.a.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return virtualFilePointer.getFileName();
                }
                case 1: {
                    return this.b.contains(virtualFilePointer) ? EditLibraryDialog.this.l : EditLibraryDialog.this.n;
                }
            }
            return "";
        }

        @Nullable
        private VirtualFilePointer a(int n2) {
            if (n2 < 0 || n2 >= this.a.size()) {
                return null;
            }
            return (VirtualFilePointer)this.a.get(n2);
        }

        private void a(@NotNull List<VirtualFilePointer> list2) {
            if (list2 == null) {
                FileTableModel.b(5);
            }
            if (this.a.removeAll(list2)) {
                this.fireTableDataChanged();
            }
        }

        @NotNull
        private List<VirtualFilePointer> a(boolean bl2) {
            ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
            for (VirtualFilePointer virtualFilePointer : this.a) {
                if (this.b.contains(virtualFilePointer) != bl2) continue;
                arrayList.add(virtualFilePointer);
            }
            ArrayList<VirtualFilePointer> arrayList2 = arrayList;
            if (arrayList2 == null) {
                FileTableModel.b(6);
            }
            return arrayList2;
        }

        @NotNull
        public List<VirtualFilePointer> getCompactFilePointers() {
            return this.a(true);
        }

        @NotNull
        private List<VirtualFilePointer> a() {
            return this.a(false);
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x4922A46A799L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFilePointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compactFilePointers";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePointers";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFilePointer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFilePointers";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent a = new JBComboBoxTableCellEditorComponent();

        TypeCellEditor() {
            this.a.setOptions(new Object[]{EditLibraryDialog.this.n, EditLibraryDialog.this.l});
            this.a.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.a.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.p.a(row);
            this.a.setCell(table, row, column);
            if (virtualFilePointer != null) {
                Object object = EditLibraryDialog.this.p.getValueAt(row, 1);
                this.a.setDefaultValue(object);
            }
            return this.a;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            Component component2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.p.a(row);
            if (virtualFilePointer != null) {
                this.setToolTipText(virtualFilePointer.getPresentableUrl());
                VirtualFile virtualFile = EditLibraryDialog.b(virtualFilePointer);
                this.setIcon(virtualFile == null ? AllIcons.FileTypes.Unknown : (virtualFile.isDirectory() ? EditLibraryDialog.this.j : EditLibraryDialog.this.d));
                if (!(virtualFile != null && virtualFile.isValid() || isSelected)) {
                    this.setForeground((Color)JBColor.red);
                }
            }
            this.setBorder(null);
            return component2;
        }
    }
}

