/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import a.b.lb;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DomFileMetaData
extends AbstractExtensionPointBean {
    static final ExtensionPointName<DomFileMetaData> EP_NAME;
    @Attribute(value="implementation")
    @RequiredElement
    public String implementation;
    @Attribute(value="rootTagName")
    @Nullable
    public String rootTagName;
    @Attribute(value="domVersion")
    public int domVersion;
    @Attribute(value="stubVersion")
    @Nullable
    public Integer stubVersion;
    volatile DomFileDescription<?> lazyInstance;

    public DomFileMetaData() {
    }

    public DomFileMetaData(DomFileDescription<?> description) {
        this.lazyInstance = description;
        this.implementation = description.getClass().getName();
        this.rootTagName = description.acceptsOtherRootTagNames() ? null : description.getRootTagName();
        this.domVersion = description.getVersion();
        this.stubVersion = description.hasStubs() ? Integer.valueOf(description.getStubVersion()) : null;
    }

    DomFileDescription<?> getDescription() {
        DomFileDescription domFileDescription = this.lazyInstance;
        if (domFileDescription == null) {
            try {
                domFileDescription = (DomFileDescription)DomFileMetaData.instantiate((Class)this.findExtensionClass(this.implementation), (PicoContainer)ApplicationManager.getApplication().getPicoContainer());
                if (StringUtil.isEmpty((String)this.rootTagName)) {
                    if (!domFileDescription.acceptsOtherRootTagNames()) {
                        throw new PluginException(this.implementation + " should either specify 'rootTagName' in XML, or return true from 'acceptsOtherRootTagNames'", this.getPluginId());
                    }
                } else if (!this.rootTagName.equals(domFileDescription.getRootTagName())) {
                    throw new PluginException(this.implementation + " XML declaration should have '" + domFileDescription.getRootTagName() + "' for 'rootTagName'", this.getPluginId());
                }
                DomApplicationComponent.getInstance().initDescription(domFileDescription);
                this.lazyInstance = domFileDescription;
            }
            catch (PluginException | ProcessCanceledException throwable) {
                throw throwable;
            }
            catch (Exception exception) {
                throw new PluginException((Throwable)exception, this.getPluginId());
            }
        }
        return domFileDescription;
    }

    public boolean hasStubs() {
        return this.stubVersion != null;
    }

    static {
        long l2 = lb.a(2124975053943535372L, -9034036781608435063L, MethodHandles.lookup().lookupClass()).a(168872308454738L) ^ 0xBE0931755E9L;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileMetaData");
    }
}

