/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIUtil {
    @NonNls
    private static final String a = "structuralsearchgroup";
    @NonNls
    public static final String SSR_NOTIFICATION_GROUP_ID = "Structural Search";
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String TYPE_REGEX = "TYPE REGEX";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    @NonNls
    public static final String CONTEXT = "CONTEXT";
    private static final long b = lb.a(867192556233091194L, -3671563969929713690L, MethodHandles.lookup().lookupClass()).a(266581299524812L);

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.a(0);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color color = editorColorsScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (color == null) {
                color = editorColorsScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(color);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.a(1);
        }
        return editor2;
    }

    public static void setContent(@NotNull Editor editor, String text2) {
        long l2 = b ^ 0x10A721AE1D20L;
        if (editor == null) {
            UIUtil.a(2);
        }
        String string = text2 != null ? text2 : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, @NotNull String text2) {
        long l2 = b ^ 0x520232BC305BL;
        if (editor == null) {
            UIUtil.a(3);
        }
        if (text2 == null) {
            UIUtil.a(4);
        }
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)text2), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(@NotNull Configuration config, @NotNull SearchContext context) {
        if (config == null) {
            UIUtil.a(5);
        }
        if (context == null) {
            UIUtil.a(6);
        }
        StructuralSearchAction.triggerAction(config, context, !(config instanceof SearchConfiguration));
    }

    @NotNull
    public static MatchVariableConstraint getOrAddVariableConstraint(@NotNull String varName, @NotNull Configuration configuration) {
        MatchOptions matchOptions;
        MatchVariableConstraint matchVariableConstraint;
        if (varName == null) {
            UIUtil.a(7);
        }
        if (configuration == null) {
            UIUtil.a(8);
        }
        if ((matchVariableConstraint = (matchOptions = configuration.getMatchOptions()).getVariableConstraint(varName)) != null) {
            MatchVariableConstraint matchVariableConstraint2 = matchVariableConstraint;
            if (matchVariableConstraint2 == null) {
                UIUtil.a(9);
            }
            return matchVariableConstraint2;
        }
        MatchVariableConstraint matchVariableConstraint3 = configuration.getMatchOptions().addNewVariableConstraint(varName);
        if (matchVariableConstraint3 == null) {
            UIUtil.a(10);
        }
        return matchVariableConstraint3;
    }

    @NotNull
    public static ReplacementVariableDefinition getOrAddReplacementVariable(@NotNull String varName, @NotNull Configuration configuration) {
        ReplaceOptions replaceOptions;
        ReplacementVariableDefinition replacementVariableDefinition;
        if (varName == null) {
            UIUtil.a(11);
        }
        if (configuration == null) {
            UIUtil.a(12);
        }
        if ((replacementVariableDefinition = (replaceOptions = configuration.getReplaceOptions()).getVariableDefinition(varName)) != null) {
            ReplacementVariableDefinition replacementVariableDefinition2 = replacementVariableDefinition;
            if (replacementVariableDefinition2 == null) {
                UIUtil.a(13);
            }
            return replacementVariableDefinition2;
        }
        ReplacementVariableDefinition replacementVariableDefinition3 = replaceOptions.addNewVariableDefinition(varName);
        if (replacementVariableDefinition3 == null) {
            UIUtil.a(14);
        }
        return replacementVariableDefinition3;
    }

    public static boolean isTarget(@NotNull String varName, @NotNull MatchOptions matchOptions) {
        long l2 = b ^ 0x2BD64D4C28E3L;
        if (varName == null) {
            UIUtil.a(15);
        }
        if (matchOptions == null) {
            UIUtil.a(16);
        }
        if ("__context__".equals(varName)) {
            for (String string : matchOptions.getVariableConstraintNames()) {
                if (string.equals("__context__") || !matchOptions.getVariableConstraint(string).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            return false;
        }
        return matchVariableConstraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(@NotNull Supplier<? extends Configuration> configurationProducer) {
        if (configurationProducer == null) {
            UIUtil.a(17);
        }
        return UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final @NotNull JLabel completeMatchInfo, final @NotNull Supplier<? extends Configuration> configurationProducer, final @Nullable Consumer<? super String> linkConsumer) {
        if (completeMatchInfo == null) {
            UIUtil.a(18);
        }
        if (configurationProducer == null) {
            UIUtil.a(19);
        }
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){
            private static final long a = lb.a(-4675865786106950494L, -295301073042264164L, MethodHandles.lookup().lookupClass()).a(119543766529219L);

            @Override
            public void mouseEntered(MouseEvent ignore) {
                long l2 = a ^ 0x1C775DDCD59L;
                if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
                    return;
                }
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint matchVariableConstraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    matchVariableConstraint.setPartOfSearchResults(true);
                }
                String string = StringUtil.escapeXmlEntities((String)SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(matchVariableConstraint, linkConsumer == null)));
                if (linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName())) {
                    string = SubstitutionShortInfoHandler.appendLinkText(string, "__context__");
                }
                HyperlinkListener hyperlinkListener = hyperlinkEvent -> {
                    long l2 = a ^ 0xF2AA119B622L;
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltipWithClickableLinks = new TooltipWithClickableLinks((JComponent)completeMatchInfo, string, hyperlinkListener);
                Rectangle rectangle = completeMatchInfo.getBounds();
                tooltipWithClickableLinks.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltipWithClickableLinks, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        JLabel jLabel = completeMatchInfo;
        if (jLabel == null) {
            UIUtil.a(20);
        }
        return jLabel;
    }

    @NotNull
    public static EditorTextField createTextComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x3C2F9A4D2FF6L;
        if (text2 == null) {
            UIUtil.a(21);
        }
        if (project == null) {
            UIUtil.a(22);
        }
        return UIUtil.createEditorComponent(text2, "1.txt", project);
    }

    @NotNull
    public static EditorTextField createRegexComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x43AB6DB47CEFL;
        if (text2 == null) {
            UIUtil.a(23);
        }
        if (project == null) {
            UIUtil.a(24);
        }
        return UIUtil.createEditorComponent(text2, "1.regexp", project);
    }

    @NotNull
    public static EditorTextField createScriptComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x736206049F4DL;
        if (text2 == null) {
            UIUtil.a(25);
        }
        if (project == null) {
            UIUtil.a(26);
        }
        return UIUtil.createEditorComponent(text2, "1.groovy", project);
    }

    @NotNull
    public static EditorTextField createEditorComponent(@NotNull String text2, @NotNull String fileName, @NotNull Project project) {
        if (text2 == null) {
            UIUtil.a(27);
        }
        if (fileName == null) {
            UIUtil.a(28);
        }
        if (project == null) {
            UIUtil.a(29);
        }
        FileType fileType = UIUtil.a(fileName);
        Document document = UIUtil.createDocument(fileType, text2, project);
        return new EditorTextField(document, project, fileType);
    }

    @NotNull
    public static Document createDocument(@NotNull FileType fileType, @NotNull String text2, @NotNull Project project) {
        if (fileType == null) {
            UIUtil.a(30);
        }
        if (text2 == null) {
            UIUtil.a(31);
        }
        if (project == null) {
            UIUtil.a(32);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text2, -1L, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            UIUtil.a(33);
        }
        return document2;
    }

    @NotNull
    private static FileType a(@NotNull String string) {
        FileType fileType;
        if (string == null) {
            UIUtil.a(34);
        }
        if ((fileType = FileTypeManager.getInstance().getFileTypeByFileName(string)) == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            UIUtil.a(35);
        }
        return fileType2;
    }

    @NotNull
    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile structuralSearchProfile;
        if (searchContext == null) {
            UIUtil.a(36);
        }
        PsiFile psiFile = searchContext.getFile();
        PsiElement psiElement = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && psiFile != null) {
            int n2 = editor.getCaretModel().getOffset();
            psiElement = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(psiFile, n2);
            if (psiElement == null) {
                psiElement = psiFile.findElementAt(n2);
            }
            if (psiElement != null) {
                psiElement = psiElement.getParent();
            }
            if (psiElement == null) {
                psiElement = psiFile;
            }
        }
        if (psiElement != null && (structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(language = psiElement.getLanguage())) != null) {
            LanguageFileType languageFileType = structuralSearchProfile.detectFileType(psiElement);
            if (languageFileType == null) {
                languageFileType = language.getAssociatedFileType();
            }
            if (languageFileType != null) {
                LanguageFileType languageFileType2 = languageFileType;
                if (languageFileType2 == null) {
                    UIUtil.a(37);
                }
                return languageFileType2;
            }
        }
        LanguageFileType languageFileType = StructuralSearchUtil.getDefaultFileType();
        if (languageFileType == null) {
            UIUtil.a(38);
        }
        return languageFileType;
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text2, @NotNull StructuralSearchProfile profile) {
        String string;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x270867DAFCBBL;
        if (project == null) {
            UIUtil.a(39);
        }
        if (fileType == null) {
            UIUtil.a(40);
        }
        if (text2 == null) {
            UIUtil.a(41);
        }
        if (profile == null) {
            UIUtil.a(42);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, string = patternContext == null ? null : patternContext.getId())) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            Document document2 = document;
            if (document2 == null) {
                UIUtil.a(43);
            }
            return document2;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        if (document == null) {
            UIUtil.a(44);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text2, boolean editable, @NotNull StructuralSearchProfile profile) {
        Document document;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x2A7C5785A172L;
        if (project == null) {
            UIUtil.a(45);
        }
        if (fileType == null) {
            UIUtil.a(46);
        }
        if (text2 == null) {
            UIUtil.a(47);
        }
        if (profile == null) {
            UIUtil.a(48);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, null)) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)psiCodeFragment, false);
        } else {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        return UIUtil.createEditor(document, project, editable, UIUtil.getTemplateContextType(profile));
    }

    private static PsiFile a(@NotNull Project project, @NotNull LanguageFileType languageFileType, Language language, @NotNull String string) {
        if (project == null) {
            UIUtil.a(49);
        }
        if (languageFileType == null) {
            UIUtil.a(50);
        }
        if (string == null) {
            UIUtil.a(51);
        }
        String string2 = "__dummy." + languageFileType.getDefaultExtension();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return language == null ? psiFileFactory.createFileFromText(string2, (FileType)languageFileType, (CharSequence)string, LocalTimeCounter.currentTime(), true, true) : psiFileFactory.createFileFromText(string2, language, (CharSequence)string, true, true);
    }

    public static TemplateContextType getTemplateContextType(@NotNull StructuralSearchProfile profile) {
        if (profile == null) {
            UIUtil.a(52);
        }
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])((TemplateContextType[])TemplateContextType.EP_NAME.getExtensions()), clazz);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x6795963A60FAL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 41: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationProducer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeMatchInfo";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 30: 
            case 40: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 42: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddVariableConstraint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddReplacementVariable";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "installCompleteMatchInfo";
                break;
            }
            case 33: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddVariableConstraint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddReplacementVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTarget";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCompleteMatchInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installCompleteMatchInfo";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTextComponent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createRegexComponent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createScriptComponent";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateContextType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 20: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

