/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> f;
    private static final TooltipGroup h;
    private long d;
    private final List<String> a;
    private final Editor g;
    private final boolean e;
    @Nullable
    private final Consumer<? super String> b;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY;
    private final Map<String, Inlay<FilterRenderer>> c;
    private static final long i;

    private SubstitutionShortInfoHandler(@NotNull Editor _editor, boolean canBeReplace, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.a(0);
        }
        this.a = new SmartList();
        this.c = new HashMap<String, Inlay<FilterRenderer>>();
        this.g = _editor;
        this.e = canBeReplace;
        this.b = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e10) {
        if (e10 == null) {
            SubstitutionShortInfoHandler.a(1);
        }
        this.a(e10.getLogicalPosition(), false);
    }

    private void a(LogicalPosition logicalPosition, boolean bl2) {
        Object object;
        long l2 = i ^ 0x79EFD16A3F70L;
        Configuration configuration = (Configuration)this.g.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        Document document = this.g.getDocument();
        int n2 = document.getLineCount();
        if (logicalPosition.line >= n2) {
            return;
        }
        int n3 = document.getLineStartOffset(logicalPosition.line);
        int n4 = document.getLineEndOffset(logicalPosition.line);
        CharSequence charSequence = document.getCharsSequence().subSequence(n3, n4);
        TextRange textRange = TemplateImplUtil.findVariableAtOffset((CharSequence)charSequence, (int)logicalPosition.column);
        if (textRange == null) {
            if (bl2) {
                if (this.b != null) {
                    this.b.accept("__context__");
                }
                configuration.setCurrentVariableName("__context__");
            }
            return;
        }
        String string = textRange.subSequence(charSequence).toString();
        NamedScriptableDefinition namedScriptableDefinition = configuration.findVariable(string);
        String string2 = StringUtil.escapeXmlEntities((String)SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition, false));
        if (!this.g.isViewer() && !string.equals(configuration.getCurrentVariableName())) {
            string2 = SubstitutionShortInfoHandler.appendLinkText(string2, string);
        }
        boolean bl3 = namedScriptableDefinition instanceof ReplacementVariableDefinition || this.e && namedScriptableDefinition == null && configuration instanceof ReplaceConfiguration;
        Object object2 = object = bl3 ? string + "$replacement" : string;
        if (bl2) {
            if (this.b != null) {
                this.b.accept((String)object);
            }
            configuration.setCurrentVariableName((String)object);
        }
        if (!string2.isEmpty()) {
            LogicalPosition logicalPosition2 = new LogicalPosition(logicalPosition.line, textRange.getStartOffset() + (textRange.getEndOffset() - textRange.getStartOffset() >> 1));
            SubstitutionShortInfoHandler.a(this.g, logicalPosition2, string2);
        }
    }

    @NotNull
    static String appendLinkText(String text2, String variableName) {
        String string = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor());
        String string2 = text2 + "<br><a style=\"color:" + string + "\" href=\"#ssr_edit_filters/" + variableName + "\">Edit filters</a>";
        if (string2 == null) {
            SubstitutionShortInfoHandler.a(2);
        }
        return string2;
    }

    private void a() {
        Document document = this.g.getDocument();
        if (this.d != document.getModificationStamp()) {
            this.a.clear();
            this.a.addAll(TemplateImplUtil.parseVariableNames((CharSequence)document.getCharsSequence()));
            this.d = document.getModificationStamp();
            this.updateEditorInlays();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e10) {
        if (e10 == null) {
            SubstitutionShortInfoHandler.a(3);
        }
        this.a(e10.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SubstitutionShortInfoHandler.a(4);
        }
        this.a(this.g.getCaretModel().getLogicalPosition(), true);
        this.updateEditorInlays();
    }

    public List<String> getVariables() {
        this.a();
        return this.a;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition, boolean verbose) {
        Object object;
        long l2 = i ^ 0x38C6829D647L;
        if (namedScriptableDefinition == null) {
            return verbose ? SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]) : "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            object = (MatchVariableConstraint)namedScriptableDefinition;
            String string = ((NamedScriptableDefinition)object).getName();
            if (!"__context__".equals(string)) {
                int n2 = ((MatchVariableConstraint)object).getMaxCount();
                int n3 = ((MatchVariableConstraint)object).getMinCount();
                if (verbose || n3 != 1 || n2 != 1) {
                    SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("min.occurs.tooltip.message", n3, n2 == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(n2)));
                }
            }
            if (((MatchVariableConstraint)object).isPartOfSearchResults() && verbose) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (!((MatchVariableConstraint)object).getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("text.tooltip.message", ((MatchVariableConstraint)object).isInvertRegExp() ? 1 : 0, ((MatchVariableConstraint)object).getRegExp(), ((MatchVariableConstraint)object).isWholeWordsOnly() ? 1 : 0, ((MatchVariableConstraint)object).isWithinHierarchy() ? 1 : 0));
            } else if (((MatchVariableConstraint)object).isWithinHierarchy()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)((MatchVariableConstraint)object).getReferenceConstraint())) {
                String string2 = StringUtil.unquoteString((String)((MatchVariableConstraint)object).getReferenceConstraintName());
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("reference.target.tooltip.message", ((MatchVariableConstraint)object).isInvertReference() ? 1 : 0, string2));
            }
            if (!((MatchVariableConstraint)object).getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("exprtype.tooltip.message", ((MatchVariableConstraint)object).isInvertExprType() ? 1 : 0, ((MatchVariableConstraint)object).isRegexExprType() ? ((MatchVariableConstraint)object).getNameOfExprType() : ((MatchVariableConstraint)object).getExpressionTypes(), ((MatchVariableConstraint)object).isExprTypeWithinHierarchy() ? 1 : 0));
            }
            if (!((MatchVariableConstraint)object).getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("expected.type.tooltip.message", ((MatchVariableConstraint)object).isInvertFormalType() ? 1 : 0, ((MatchVariableConstraint)object).isRegexFormalType() ? ((MatchVariableConstraint)object).getNameOfFormalArgType() : ((MatchVariableConstraint)object).getExpectedTypes(), ((MatchVariableConstraint)object).isFormalArgTypeWithinHierarchy() ? 1 : 0));
            }
            if (StringUtil.isNotEmpty((String)((MatchVariableConstraint)object).getWithinConstraint())) {
                String string3 = StringUtil.unquoteString((String)((MatchVariableConstraint)object).getWithinConstraint());
                SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("within.constraints.tooltip.message", ((MatchVariableConstraint)object).isInvertWithinConstraint() ? 1 : 0, string3));
            }
        }
        if (((String)(object = namedScriptableDefinition.getScriptCodeConstraint())).length() > 2) {
            SubstitutionShortInfoHandler.a(stringBuilder, SSRBundle.message("script.tooltip.message", new Object[0]));
        }
        if (stringBuilder.length() == 0 && verbose) {
            stringBuilder.append(SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]));
        }
        String string = stringBuilder.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.a(5);
        }
        return string;
    }

    private static void a(StringBuilder stringBuilder, String string) {
        long l2 = i ^ 0x3671A6687526L;
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    private static void a(@NotNull Editor editor, LogicalPosition logicalPosition, @NotNull String string) {
        long l2 = i ^ 0x45146AE3D163L;
        if (editor == null) {
            SubstitutionShortInfoHandler.a(6);
        }
        if (string == null) {
            SubstitutionShortInfoHandler.a(7);
        }
        if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Point point = editor.logicalPositionToXY(logicalPosition);
        point.y += editor.getLineHeight();
        Point point2 = SwingUtilities.convertPoint(editor.getContentComponent(), point, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hintHint = new HintHint(editor, point).setAwtTooltip(true).setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, point2, string, rectangle.width, false, h, hintHint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return editor == null ? null : (SubstitutionShortInfoHandler)editor.getUserData(f);
    }

    static void install(Editor editor, Disposable disposable) {
        SubstitutionShortInfoHandler.install(editor, null, disposable, false);
    }

    static void install(Editor editor, @Nullable Consumer<? super String> currentVariableCallback, Disposable disposable, boolean replace) {
        SubstitutionShortInfoHandler substitutionShortInfoHandler = new SubstitutionShortInfoHandler(editor, replace, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)substitutionShortInfoHandler, disposable);
        editor.getDocument().addDocumentListener((DocumentListener)substitutionShortInfoHandler, disposable);
        editor.getCaretModel().addCaretListener((CaretListener)substitutionShortInfoHandler, disposable);
        editor.putUserData(f, (Object)substitutionShortInfoHandler);
    }

    static void updateEditorInlays(Editor editor) {
        SubstitutionShortInfoHandler substitutionShortInfoHandler = SubstitutionShortInfoHandler.retrieve(editor);
        if (substitutionShortInfoHandler != null) {
            substitutionShortInfoHandler.updateEditorInlays();
        }
    }

    void updateEditorInlays() {
        Inlay<FilterRenderer> inlay;
        long l2 = i ^ 0x5C6C6ACA44D5L;
        if (!Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        String string = this.g.getDocument().getText();
        Template template = TemplateManager.getInstance((Project)this.g.getProject()).createTemplate("", "", string);
        int n2 = template.getSegmentsCount();
        InlayModel inlayModel = this.g.getInlayModel();
        HashSet<String> hashSet = new HashSet<String>(this.c.keySet());
        Configuration configuration = (Configuration)this.g.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        int n3 = 0;
        for (int i10 = 0; i10 < n2; ++i10) {
            int n4 = template.getSegmentOffset(i10);
            inlay = template.getSegmentName(i10);
            n3 += inlay.length() + 2;
            NamedScriptableDefinition object2 = configuration.findVariable((String)inlay);
            String string2 = SubstitutionShortInfoHandler.getShortParamString(object2, false);
            if (string2.isEmpty()) continue;
            hashSet.remove(inlay);
            Inlay<FilterRenderer> inlay2 = this.c.get(inlay);
            if (inlay2 == null) {
                this.c.put((String)inlay, (Inlay<FilterRenderer>)inlayModel.addInlineElement(n4 + n3, (EditorCustomElementRenderer)new FilterRenderer(string2)));
                continue;
            }
            FilterRenderer filterRenderer = (FilterRenderer)inlay2.getRenderer();
            filterRenderer.setText(string2);
            inlay2.update();
        }
        NamedScriptableDefinition namedScriptableDefinition = configuration.findVariable("__context__");
        String string3 = SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition, false);
        if (!string3.isEmpty()) {
            hashSet.remove("__context__");
            inlay = this.c.get("__context__");
            if (inlay == null) {
                this.c.put("__context__", (Inlay<FilterRenderer>)inlayModel.addBlockElement(string.length() + n3, true, false, 0, (EditorCustomElementRenderer)new FilterRenderer("whole template: " + string3)));
            } else {
                FilterRenderer filterRenderer = (FilterRenderer)inlay.getRenderer();
                filterRenderer.setText("whole template: " + string3);
                inlay.update();
            }
        }
        for (String string4 : hashSet) {
            Disposer.dispose((Disposable)((Disposable)this.c.remove(string4)));
        }
    }

    static {
        i = lb.a(-1149511763233081341L, -6317122403807007304L, MethodHandles.lookup().lookupClass()).a(115165664333763L);
        long l2 = i ^ 0x20B519C54E1BL;
        f = Key.create((String)"sslistener.key");
        h = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
        CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x58AB59541F7AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLinkText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilterRenderer
    implements EditorCustomElementRenderer {
        private String a;
        private static final long b = lb.a(-6225288990932900618L, -1795484200908382295L, MethodHandles.lookup().lookupClass()).a(208270024842206L);

        FilterRenderer(String text2) {
            this.a = text2;
        }

        public void setText(String text2) {
            this.a = text2;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                FilterRenderer.a(0);
            }
            return FilterRenderer.a(inlay.getEditor()).stringWidth(this.a) + 12;
        }

        private static Font a() {
            long l2 = b ^ 0x3040F51B406DL;
            return UIManager.getFont("Label.font");
        }

        private static FontMetrics a(Editor editor) {
            return editor.getContentComponent().getFontMetrics(FilterRenderer.a());
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g10, @NotNull Rectangle r2, @NotNull TextAttributes textAttributes) {
            Object object;
            Editor editor;
            TextAttributes textAttributes2;
            if (inlay == null) {
                FilterRenderer.a(1);
            }
            if (g10 == null) {
                FilterRenderer.a(2);
            }
            if (r2 == null) {
                FilterRenderer.a(3);
            }
            if (textAttributes == null) {
                FilterRenderer.a(4);
            }
            if ((textAttributes2 = (editor = inlay.getEditor()).getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) == null) {
                return;
            }
            FontMetrics fontMetrics = FilterRenderer.a(editor);
            Color color = textAttributes2.getBackgroundColor();
            if (color != null) {
                object = GraphicsUtil.setupAAPainting((Graphics)g10);
                GraphicsUtil.paintWithAlpha((Graphics)g10, (float)0.55f);
                g10.setColor(color);
                g10.fillRoundRect(r2.x + 2, r2.y, r2.width - 4, r2.height, 8, 8);
                object.restore();
            }
            if ((object = textAttributes2.getForegroundColor()) != null) {
                g10.setColor((Color)object);
                g10.setFont(FilterRenderer.a());
                g10.drawString(this.a, r2.x + 6, r2.y + fontMetrics.getAscent());
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x707162233452L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler$FilterRenderer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

