/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    @NotNull
    protected final SearchContext mySearchContext;
    @NotNull
    protected final Configuration myConfiguration;
    private FindUsagesProcessPresentation a;
    private static final long d = lb.a(1904762711515026862L, -7485082955189036393L, MethodHandles.lookup().lookupClass()).a(210055103338767L);

    public SearchCommand(@NotNull Configuration configuration, @NotNull SearchContext searchContext) {
        if (configuration == null) {
            SearchCommand.a(0);
        }
        if (searchContext == null) {
            SearchCommand.a(1);
        }
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    @NotNull
    protected UsageViewContext createUsageViewContext() {
        Runnable runnable = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, runnable);
    }

    public void startSearching() {
        final UsageViewContext usageViewContext = this.createUsageViewContext();
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        usageViewContext.configure(usageViewPresentation);
        this.a = new FindUsagesProcessPresentation(usageViewPresentation);
        this.a.setShowNotFoundMessage(true);
        this.a.setShowPanelIfOnlyOneUsage(true);
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget configurableUsageTarget = usageViewContext.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(configurableUsageTarget);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{configurableUsageTarget}, () -> processor -> this.findUsages((Processor<? super Usage>)processor), this.a, usageViewPresentation, new UsageViewManager.UsageViewStateListener(){
            private static final long a = lb.a(-7962260204975802838L, -9213394980665013562L, MethodHandles.lookup().lookupClass()).a(56175779877684L);

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    1.a(0);
                }
                usageViewContext.setUsageView(usageView);
                usageViewContext.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x60D9F0A99355L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/structuralsearch/plugin/ui/SearchCommand$1", "usageViewCreated"));
            }
        });
    }

    public void findUsages(final @NotNull Processor<? super Usage> processor) {
        long l2 = d ^ 0x4F69EC4503EEL;
        if (processor == null) {
            SearchCommand.a(2);
        }
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        MatchResultSink matchResultSink = new MatchResultSink(){
            int count;
            private static final long a = lb.a(5808237293175874826L, 8364529987237492655L, MethodHandles.lookup().lookupClass()).a(229344126119275L);

            @Override
            public void setMatchingProcess(@NotNull MatchingProcess _process) {
                if (_process == null) {
                    2.a(0);
                }
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(@NotNull PsiFile element2) {
                VirtualFile virtualFile;
                long l2 = a ^ 0x69A8E422F8B8L;
                if (element2 == null) {
                    2.a(1);
                }
                if ((virtualFile = element2.getVirtualFile()) != null) {
                    progressIndicator.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                long l2 = a ^ 0x6B7E25DBEFD9L;
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progressIndicator.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progressIndicator;
            }

            @Override
            public void newMatch(@NotNull MatchResult result) {
                UsageInfo usageInfo;
                long l2 = a ^ 0x14D0D3472B35L;
                if (result == null) {
                    2.a(2);
                }
                if ("__multi_line__".equals(result.getName())) {
                    int n2 = -1;
                    int n3 = -1;
                    PsiElement psiElement = result.getMatch().getParent();
                    for (MatchResult matchResult : result.getChildren()) {
                        int n4;
                        PsiElement psiElement2 = matchResult.getMatch();
                        int n5 = psiElement2.getTextRange().getStartOffset();
                        if (n2 == -1 || n2 > n5) {
                            n2 = n5;
                        }
                        if ((n4 = n5 + psiElement2.getTextLength()) <= n3) continue;
                        n3 = n4;
                    }
                    int n6 = psiElement.getTextRange().getStartOffset();
                    int n7 = n2 - n6;
                    usageInfo = new UsageInfo(psiElement, n7, n3 - n6);
                } else {
                    PsiElement psiElement = result.getMatch();
                    if (!psiElement.isPhysical()) {
                        return;
                    }
                    usageInfo = new UsageInfo(psiElement);
                }
                UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
                SearchCommand.this.foundUsage(result, (Usage)usageInfo2UsageAdapter);
                processor.process((Object)usageInfo2UsageAdapter);
                ++this.count;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x2F58730F2AB7L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_process";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SearchCommand$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setMatchingProcess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "newMatch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject(), this.myConfiguration.getMatchOptions()).findMatches(matchResultSink);
        }
        catch (StructuralSearchException structuralSearchException) {
            this.a.setShowNotFoundMessage(false);
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Structural Search");
            notificationGroup.createNotification(NotificationType.ERROR).setContent(structuralSearchException instanceof StructuralSearchScriptException ? SSRBundle.message("search.script.problem", structuralSearchException.getCause()) : SSRBundle.message("search.template.problem", structuralSearchException.getMessage())).setImportant(true).notify(this.mySearchContext.getProject());
        }
    }

    protected void findStarted() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(true);
    }

    protected void findEnded() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(false);
    }

    protected void foundUsage(MatchResult result, Usage usage) {
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x3A9F5835425CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SearchCommand";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

