/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.b.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    private static final int b = 30;
    @NonNls
    private static final String e = "searchConfiguration";
    @NonNls
    private static final String c = "replaceConfiguration";
    @NonNls
    private static final String h = "history";
    private final List<Configuration> a = new SmartList();
    private final List<Configuration> f = new SmartList();
    private final ConfigurationManagerState d;
    private final Project g;
    private static final long i = lb.a(9115180030201081794L, 8780312594135501882L, MethodHandles.lookup().lookupClass()).a(260231776759363L);

    public static ConfigurationManager getInstance(@NotNull Project project) {
        if (project == null) {
            ConfigurationManager.a(0);
        }
        return (ConfigurationManager)ServiceManager.getService((Project)project, ConfigurationManager.class);
    }

    public ConfigurationManager(Project project) {
        this.g = project;
        this.d = ConfigurationManagerState.getInstance();
    }

    public Element getState() {
        long l2 = i ^ 0x37F38D4F4843L;
        Element element2 = new Element("state");
        ConfigurationManager.b(element2, this.a, this.f);
        return element2;
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            ConfigurationManager.a(1);
        }
        this.a.clear();
        this.f.clear();
        SmartList smartList = new SmartList();
        ConfigurationManager.a(element2, this.a, (Collection<? super Configuration>)smartList);
        this.a(this.a);
        for (Configuration configuration : smartList) {
            configuration.getMatchOptions().initScope(this.g);
            this.addHistoryConfiguration(configuration);
        }
        Collections.reverse(this.f);
    }

    private void a(@NotNull List<? extends Configuration> list2) {
        if (list2 == null) {
            ConfigurationManager.a(2);
        }
        if (list2.isEmpty()) {
            return;
        }
        block0: for (Configuration configuration : list2) {
            Configuration configuration2 = this.d.get(configuration.getRefName());
            while (configuration2 != null) {
                if (configuration.equals(configuration2)) continue block0;
                configuration.setName(configuration.getName() + "~");
                configuration2 = this.d.get(configuration.getRefName());
            }
            this.d.add(configuration);
        }
    }

    public void addHistoryConfiguration(@NotNull Configuration configuration) {
        Configuration configuration2;
        if (configuration == null) {
            ConfigurationManager.a(3);
        }
        if ((configuration = configuration.copy()).getCreated() <= 0L) {
            configuration.setCreated(System.currentTimeMillis());
        }
        if ((configuration2 = ConfigurationManager.a(this.f, configuration)) != null) {
            this.f.remove(configuration2);
        }
        this.f.add(0, configuration);
        while (this.f.size() > 30) {
            this.f.remove(this.f.size() - 1);
        }
    }

    public Configuration getMostRecentConfiguration() {
        return this.f.isEmpty() ? null : this.f.get(0);
    }

    @TestOnly
    public void addConfiguration(Configuration configuration) {
        this.d.add(configuration);
    }

    public void removeConfiguration(Configuration configuration) {
        long l2 = i ^ 0x32E487DAD9F8L;
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            this.d.remove(configuration.getRefName());
        }
        this.a.remove(configuration);
    }

    public static void writeConfigurations(@NotNull Element element2, @NotNull Collection<? extends Configuration> configurations) {
        if (element2 == null) {
            ConfigurationManager.a(4);
        }
        if (configurations == null) {
            ConfigurationManager.a(5);
        }
        ConfigurationManager.b(element2, configurations, Collections.emptyList());
    }

    private static void b(@NotNull Element element2, @NotNull Collection<? extends Configuration> collection, @NotNull Collection<? extends Configuration> collection2) {
        long l2 = i ^ 0x414B7AFE1318L;
        if (element2 == null) {
            ConfigurationManager.a(6);
        }
        if (collection == null) {
            ConfigurationManager.a(7);
        }
        if (collection2 == null) {
            ConfigurationManager.a(8);
        }
        for (Configuration configuration : collection) {
            configuration.getMatchOptions().setScope(null);
            ConfigurationManager.a(element2, configuration);
        }
        for (Configuration configuration : collection2) {
            Element element3 = ConfigurationManager.a(element2, configuration);
            element3.setAttribute(h, "1");
        }
    }

    @NotNull
    private static Element a(@NotNull Element element2, @NotNull Configuration configuration) {
        long l2 = i ^ 0x443FB8BD1B01L;
        if (element2 == null) {
            ConfigurationManager.a(9);
        }
        if (configuration == null) {
            ConfigurationManager.a(10);
        }
        Element element3 = new Element(configuration instanceof SearchConfiguration ? e : c);
        element2.addContent(element3);
        configuration.writeExternal(element3);
        Element element4 = element3;
        if (element4 == null) {
            ConfigurationManager.a(11);
        }
        return element4;
    }

    public static void readConfigurations(@NotNull Element element2, @NotNull Collection<? super Configuration> configurations) {
        if (element2 == null) {
            ConfigurationManager.a(12);
        }
        if (configurations == null) {
            ConfigurationManager.a(13);
        }
        ConfigurationManager.a(element2, configurations, (Collection<? super Configuration>)new SmartList());
    }

    private static void a(@NotNull Element element2, @NotNull Collection<? super Configuration> collection, @NotNull Collection<? super Configuration> collection2) {
        long l2 = i ^ 0x67A207C0B3F5L;
        if (element2 == null) {
            ConfigurationManager.a(14);
        }
        if (collection == null) {
            ConfigurationManager.a(15);
        }
        if (collection2 == null) {
            ConfigurationManager.a(16);
        }
        for (Element element3 : element2.getChildren()) {
            Configuration configuration = ConfigurationManager.a(element3);
            if (configuration == null) continue;
            if (element3.getAttribute(h) != null) {
                collection2.add(configuration);
                continue;
            }
            collection.add(configuration);
        }
    }

    private static Configuration a(@NotNull Element element2) {
        Configuration configuration;
        String string;
        long l2 = i ^ 0x2E66832B9437L;
        if (element2 == null) {
            ConfigurationManager.a(17);
        }
        if ((string = element2.getName()).equals(e)) {
            configuration = new SearchConfiguration();
        } else if (string.equals(c)) {
            configuration = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)configuration).readExternal(element2);
        return configuration;
    }

    public List<String> getAllConfigurationNames() {
        Stream<Configuration> stream2 = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.getConfigurations().stream());
        return stream2.map(configuration -> configuration.getRefName()).collect(Collectors.toList());
    }

    public List<Configuration> getAllConfigurations() {
        Stream<Configuration> stream2 = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.getConfigurations().stream());
        return stream2.collect(Collectors.toList());
    }

    @NotNull
    public Collection<Configuration> getConfigurations() {
        long l2 = i ^ 0x7CFD95D7132CL;
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            Collection<Configuration> collection = this.d.getAll();
            if (collection == null) {
                ConfigurationManager.a(18);
            }
            return collection;
        }
        List<Configuration> list2 = Collections.unmodifiableList(this.a);
        if (list2 == null) {
            ConfigurationManager.a(19);
        }
        return list2;
    }

    @Nullable
    public Configuration findConfigurationByName(String name) {
        long l2 = i ^ 0x26A3EFDBE2FBL;
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            Configuration configuration = this.d.get(name);
            if (configuration != null) {
                return configuration;
            }
        } else {
            Configuration configuration = ConfigurationManager.a(this.a, name);
            if (configuration != null) {
                return configuration;
            }
        }
        return ConfigurationManager.a(StructuralSearchUtil.getPredefinedTemplates(), name);
    }

    @Nullable
    private static Configuration a(Collection<? extends Configuration> collection, String string) {
        return (Configuration)ContainerUtil.find(collection, configuration -> configuration.getRefName().equals(string));
    }

    @Nullable
    private static Configuration a(@NotNull Collection<? extends Configuration> collection, Configuration configuration) {
        if (collection == null) {
            ConfigurationManager.a(20);
        }
        return (Configuration)ContainerUtil.find(collection, configuration2 -> {
            if (configuration instanceof ReplaceConfiguration) {
                return configuration2 instanceof ReplaceConfiguration && configuration2.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern()) && configuration2.getReplaceOptions().getReplacement().equals(configuration.getReplaceOptions().getReplacement());
            }
            return configuration2 instanceof SearchConfiguration && configuration2.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern());
        });
    }

    @NotNull
    public List<Configuration> getHistoryConfigurations() {
        List<Configuration> list2 = Collections.unmodifiableList(this.f);
        if (list2 == null) {
            ConfigurationManager.a(21);
        }
        return list2;
    }

    public boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration) {
        long l2 = i ^ 0x12B768E90A3DL;
        if (newConfiguration == null) {
            ConfigurationManager.a(22);
        }
        if (Registry.is((String)"ssr.save.templates.to.ide.instead.of.project.workspace")) {
            return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, this.g, string -> this.d.get((String)string) != null, configuration -> {
                this.d.add((Configuration)configuration);
                this.a.remove(configuration);
                this.a.add((Configuration)configuration);
            });
        }
        return ConfigurationManager.showSaveTemplateAsDialog(this.a, newConfiguration, this.g);
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration, @NotNull Project project, @NotNull Predicate<? super String> nameExistsPredicate, @NotNull Consumer<? super Configuration> namedConfigurationConsumer) {
        int n2;
        long l2 = i ^ 0x641E76DD6ABL;
        if (newConfiguration == null) {
            ConfigurationManager.a(23);
        }
        if (project == null) {
            ConfigurationManager.a(24);
        }
        if (nameExistsPredicate == null) {
            ConfigurationManager.a(25);
        }
        if (namedConfigurationConsumer == null) {
            ConfigurationManager.a(26);
        }
        String string = ConfigurationManager.a(newConfiguration.getName(), project);
        while (string != null && nameExistsPredicate.test(string) && (n2 = Messages.showYesNoDialog((Project)project, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", string), (String)SSRBundle.message("button.replace", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon())) != 0) {
            string = ConfigurationManager.a(string, project);
        }
        if (string != null) {
            newConfiguration.setName(string);
            newConfiguration.setUuid(null);
            namedConfigurationConsumer.accept(newConfiguration.copy());
            return true;
        }
        return false;
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Collection<Configuration> configurations, @NotNull Configuration newConfiguration, @NotNull Project project) {
        if (configurations == null) {
            ConfigurationManager.a(27);
        }
        if (newConfiguration == null) {
            ConfigurationManager.a(28);
        }
        if (project == null) {
            ConfigurationManager.a(29);
        }
        return ConfigurationManager.showSaveTemplateAsDialog(newConfiguration, project, string -> ConfigurationManager.a((Collection<? extends Configuration>)configurations, string) != null, configuration -> {
            configurations.remove(configuration);
            configurations.add((Configuration)configuration);
        });
    }

    @Nullable
    private static String a(@NotNull String string, @NotNull Project project) {
        long l2 = i ^ 0xD779EE415BL;
        if (string == null) {
            ConfigurationManager.a(30);
        }
        if (project == null) {
            ConfigurationManager.a(31);
        }
        return Messages.showInputDialog((Project)project, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)string, null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x436F77F6E634L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyConfigurations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 22: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfiguration";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExistsPredicate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedConfigurationConsumer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "saveConfiguration";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryConfigurations";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeConfigurations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveConfiguration";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showSaveTemplateAsDialog";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="StructuralSearch", storages={@Storage(value="structuralSearch.xml")})
    private static class ConfigurationManagerState
    implements PersistentStateComponent<Element> {
        public final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();
        private static final long a = lb.a(3433002118149025840L, -2239107632211261866L, MethodHandles.lookup().lookupClass()).a(214940439260109L);

        private ConfigurationManagerState() {
        }

        public static ConfigurationManagerState getInstance() {
            return (ConfigurationManagerState)ApplicationManager.getApplication().getService(ConfigurationManagerState.class);
        }

        public static ConfigurationManagerState getInstance(Project project) {
            return (ConfigurationManagerState)ServiceManager.getService((Project)project, ConfigurationManagerState.class);
        }

        public void add(Configuration configuration) {
            configuration.getMatchOptions().setScope(null);
            this.configurations.put(configuration.getRefName(), configuration);
        }

        public Configuration get(String name) {
            return this.configurations.get(name);
        }

        public void remove(String name) {
            this.configurations.remove(name);
        }

        public Collection<Configuration> getAll() {
            return Collections.unmodifiableCollection(this.configurations.values());
        }

        @Nullable
        public Element getState() {
            long l2 = a ^ 0x21DC08C00DB3L;
            Element element2 = new Element("state");
            for (Configuration configuration : this.configurations.values()) {
                ConfigurationManager.a(element2, configuration);
            }
            return element2;
        }

        public void loadState(@NotNull Element state) {
            if (state == null) {
                ConfigurationManagerState.a(0);
            }
            for (Element element2 : state.getChildren()) {
                Configuration configuration = ConfigurationManager.a(element2);
                if (configuration == null) continue;
                this.configurations.put(configuration.getRefName(), configuration);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x351EBCAE8E63L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/structuralsearch/plugin/ui/ConfigurationManager$ConfigurationManagerState", "loadState"));
        }
    }
}

