/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import a.b.lb;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project c;
    @NotNull
    private final ReplaceOptions b;
    private final StructuralReplaceHandler e;
    private final ReplacementBuilder d;
    private PsiElement a;
    private static final long f = lb.a(5908312993430537080L, -7528974570720200038L, MethodHandles.lookup().lookupClass()).a(124039937927545L);

    public Replacer(@NotNull Project project, @NotNull ReplaceOptions options) {
        if (project == null) {
            Replacer.a(0);
        }
        if (options == null) {
            Replacer.a(1);
        }
        this.c = project;
        this.b = options;
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(options.getMatchOptions().getFileType());
        assert (structuralSearchProfile != null);
        this.e = structuralSearchProfile.getReplaceHandler(project, options);
        assert (this.e != null);
        this.d = new ReplacementBuilder(this.c, this.b);
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result, int offset, ParameterInfo info, String image) {
        if (!image.isEmpty()) {
            result.insert(offset + info.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions options, Project project) {
        return Replacer.testReplace(in2, what, by2, options, project, false);
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions options, Project project, boolean sourceIsFile) {
        LanguageFileType languageFileType = options.getMatchOptions().getFileType();
        return Replacer.testReplace(in2, what, by2, options, project, sourceIsFile, false, languageFileType, languageFileType.getLanguage());
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions replaceOptions, Project project, boolean sourceIsFile, boolean createPhysicalFile, @NotNull LanguageFileType sourceFileType, @NotNull Language sourceDialect) {
        if (sourceFileType == null) {
            Replacer.a(2);
        }
        if (sourceDialect == null) {
            Replacer.a(3);
        }
        replaceOptions.setReplacement(by2);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project, matchOptions);
        Replacer.checkReplacementPattern(project, replaceOptions);
        Replacer replacer = new Replacer(project, replaceOptions);
        Matcher matcher = new Matcher(project, matchOptions);
        try {
            PsiElement psiElement;
            PsiElement psiElement2;
            PsiElement psiElement3;
            PsiElement psiElement4;
            Object object;
            if (matchOptions.getScope() == null) {
                object = MatcherImplUtil.createTreeFromText(in2, new PatternContextInfo(sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block), sourceFileType, sourceDialect, project, createPhysicalFile);
                psiElement4 = object[0];
                psiElement3 = object[((PsiElement[])object).length - 1];
                psiElement2 = psiElement4.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement[])object));
            } else {
                psiElement2 = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                psiElement4 = psiElement2.getFirstChild();
                psiElement3 = psiElement2.getLastChild();
            }
            object = new CollectingMatchResultSink();
            matcher.testFindMatches((MatchResultSink)object);
            SmartList smartList = new SmartList();
            for (MatchResult matchResult : ((CollectingMatchResultSink)object).getMatches()) {
                smartList.add(replacer.buildReplacement(matchResult));
            }
            int n2 = psiElement4.getTextRange().getStartOffset();
            int n3 = sourceIsFile ? 0 : psiElement2.getTextLength() - psiElement3.getTextRange().getEndOffset();
            PsiElement psiElement5 = psiElement4.getPrevSibling();
            if (psiElement5 instanceof PsiWhiteSpace) {
                n2 -= psiElement5.getTextLength();
            }
            if ((psiElement = psiElement3.getNextSibling()) instanceof PsiWhiteSpace) {
                n3 -= psiElement.getTextLength();
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)smartList);
            if (psiElement4 == psiElement3 && psiElement4 instanceof PsiFile) {
                String string = psiElement4.getText();
                return string;
            }
            String string = psiElement2.getText();
            String string2 = string.substring(n2, string.length() - n3);
            return string2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IncorrectOperationException((Throwable)exception);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        long l2 = f ^ 0x4204798C4CEAL;
        for (ReplacementInfo replacementInfo : infos) {
            this.e.prepare(replacementInfo);
        }
        ((ApplicationEx)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.c, null, progressIndicator -> {
            progressIndicator.setIndeterminate(false);
            try {
                int n2 = infos.size();
                VirtualFile virtualFile = null;
                for (int i10 = 0; i10 < n2; ++i10) {
                    progressIndicator.checkCanceled();
                    progressIndicator.setFraction((double)((float)(i10 + 1) / (float)n2));
                    ReplacementInfo replacementInfo = (ReplacementInfo)infos.get(i10);
                    PsiElement psiElement = replacementInfo.getMatch(0);
                    if (psiElement == null) continue;
                    VirtualFile virtualFile2 = psiElement.getContainingFile().getVirtualFile();
                    if (virtualFile2 != null && !virtualFile2.equals(virtualFile)) {
                        progressIndicator.setText2(virtualFile2.getPresentableUrl());
                        virtualFile = virtualFile2;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement psiElement = this.a(replacementInfo);
                        if (psiElement != this.a) {
                            if (this.a != null) {
                                this.a(this.a);
                            }
                            this.a = psiElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.a(this.a));
            }
        });
    }

    public void replace(@NotNull ReplacementInfo info) {
        if (info == null) {
            Replacer.a(4);
        }
        this.e.prepare(info);
        this.a(this.a(info));
    }

    @Nullable
    private PsiElement a(@NotNull ReplacementInfo replacementInfo) {
        PsiElement psiElement;
        if (replacementInfo == null) {
            Replacer.a(5);
        }
        if ((psiElement = replacementInfo.getMatch(0)) == null || !psiElement.isWritable() || !psiElement.isValid()) {
            return null;
        }
        PsiElement psiElement2 = StructuralSearchUtil.getPresentableElement(psiElement).getParent();
        CodeStyleManager.getInstance((Project)this.c).performActionWithFormatterDisabled(() -> this.e.replace(replacementInfo, this.b));
        if (!psiElement2.isValid() || !psiElement2.isWritable()) {
            return null;
        }
        return psiElement2;
    }

    private void a(PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && this.b.isToReformatAccordingToStyle()) {
            Document document;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
                PsiDocumentManager.getInstance((Project)this.c).commitDocument(document);
            }
            int n2 = psiElement.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.c).reformatRange((PsiElement)psiFile, n2, n2 + psiElement.getTextLength(), true);
        }
        this.e.postProcess(psiElement, this.b);
    }

    public static void handleComments(PsiElement el2, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement psiElement3 = el2.getLastChild();
        if (psiElement3 instanceof PsiComment && replacementInfo.getVariableName(psiElement3) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            psiElement2 = psiElement3;
            for (psiElement = psiElement2.getPrevSibling(); psiElement != null && (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment); psiElement = psiElement.getPrevSibling()) {
                psiElement2 = psiElement;
            }
            replacement.addRangeAfter(psiElement2, psiElement3, replacement.getLastChild());
        }
        if ((psiElement2 = el2.getFirstChild()) instanceof PsiComment && !(psiElement2 instanceof PsiDocCommentBase) && replacementInfo.getVariableName(psiElement2) == null) {
            psiElement = psiElement2;
            for (PsiElement psiElement4 = psiElement.getNextSibling(); psiElement4 != null && (psiElement4 instanceof PsiWhiteSpace || psiElement4 instanceof PsiComment); psiElement4 = psiElement4.getNextSibling()) {
                psiElement = psiElement4;
            }
            replacement.addRangeBefore(psiElement2, psiElement, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options) {
        long l2 = f ^ 0x1C41F4834B80L;
        if (project == null) {
            Replacer.a(6);
        }
        if (options == null) {
            Replacer.a(7);
        }
        try {
            String string = options.getMatchOptions().getSearchPattern();
            String string2 = options.getReplacement();
            LanguageFileType languageFileType = options.getMatchOptions().getFileType();
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", string);
            Template template2 = TemplateManager.getInstance((Project)project).createTemplate("", "", string2);
            int n2 = template2.getSegmentsCount();
            for (int i10 = 0; i10 < n2; ++i10) {
                Object object;
                int n3;
                String string3 = template2.getSegmentName(i10);
                int n4 = template.getSegmentsCount();
                for (n3 = 0; n3 < n4 && !string3.equals(object = template.getSegmentName(n3)); ++n3) {
                    if (!string3.startsWith((String)object) || string3.charAt(((String)object).length()) != '_') continue;
                    try {
                        Integer.parseInt(string3.substring(((String)object).length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n3 != n4) continue;
                object = options.getVariableDefinition(string3);
                if (object == null || ((NamedScriptableDefinition)object).getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", string3));
                }
                String string4 = ScriptSupport.checkValidScript(StringUtil.unquoteString((String)((NamedScriptableDefinition)object).getScriptCodeConstraint()), options.getMatchOptions());
                if (string4 == null) continue;
                throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", string3, string4));
            }
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(languageFileType);
            assert (structuralSearchProfile != null);
            ReadAction.run(() -> structuralSearchProfile.checkReplacementPattern(project, options));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    @NotNull
    public ReplacementInfo buildReplacement(@NotNull MatchResult result) {
        if (result == null) {
            Replacer.a(8);
        }
        ReplacementInfoImpl replacementInfoImpl = new ReplacementInfoImpl(result, this.c);
        replacementInfoImpl.setReplacement(this.d.process(result, replacementInfoImpl, this.b.getMatchOptions().getFileType()));
        ReplacementInfoImpl replacementInfoImpl2 = replacementInfoImpl;
        if (replacementInfoImpl2 == null) {
            Replacer.a(9);
        }
        return replacementInfoImpl2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x92FBC7886A2L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildReplacement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "testReplace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doReplace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

