/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.List;

public final class XmlMatchUtil {
    private XmlMatchUtil() {
    }

    public static boolean isWhiteSpace(PsiElement element2) {
        return element2 instanceof PsiWhiteSpace || element2 instanceof XmlText && element2.getFirstChild() == element2.getLastChild() && element2.getFirstChild() instanceof PsiWhiteSpace;
    }

    public static List<PsiElement> getElementsToMatch(XmlTagChild[] elements) {
        SmartList smartList = new SmartList();
        for (XmlTagChild xmlTagChild : elements) {
            if (xmlTagChild instanceof XmlText) {
                for (PsiElement psiElement : xmlTagChild.getChildren()) {
                    if (XmlUtil.isXmlToken((PsiElement)psiElement, (IElementType)XmlTokenType.XML_DATA_CHARACTERS)) {
                        smartList.add(psiElement);
                        continue;
                    }
                    if (!(psiElement instanceof XmlComment)) continue;
                    smartList.add(psiElement);
                }
                continue;
            }
            smartList.add(xmlTagChild);
        }
        return smartList;
    }
}

