/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import a.b.lb;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.lang.invoke.MethodHandles;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String e = ".$|()[]{}^?*+\\";
    private static final Pattern g;
    private static final Comparator<? super Configuration> a;
    private static LanguageFileType f;
    private static boolean b;
    private static final Map<String, StructuralSearchProfile> c;
    private static List<Configuration> d;
    private static final long h;

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        b = useUniversalMatchingAlgorithm;
        c.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchUtil.a(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element2.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            StructuralSearchUtil.a(1);
        }
        return StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String string;
        if (language == null) {
            StructuralSearchUtil.a(2);
        }
        if (c.containsKey(string = language.getID())) {
            return c.get(string);
        }
        for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.c()) {
            if (!structuralSearchProfile.isMyLanguage(language)) continue;
            c.put(string, structuralSearchProfile);
            return structuralSearchProfile;
        }
        c.put(string, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element2);
        return structuralSearchProfile != null && structuralSearchProfile.isIdentifier(element2);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element2) {
        return StructuralSearchUtil.isIdentifier(element2) ? element2.getParent() : element2;
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(element2);
        return structuralSearchProfile == null ? element2 : structuralSearchProfile.getPresentableElement(element2);
    }

    private static StructuralSearchProfile[] b() {
        SmartList smartList = new SmartList();
        for (StructuralSearchProfile structuralSearchProfile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(structuralSearchProfile instanceof StructuralSearchProfileBase)) continue;
            smartList.add(structuralSearchProfile);
        }
        smartList.add(new XmlStructuralSearchProfile());
        return smartList.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] c() {
        return b ? StructuralSearchUtil.b() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (f == null) {
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.c()) {
                f = structuralSearchProfile.getDefaultFileType(f);
            }
            if (f == null) {
                f = XmlFileType.INSTANCE;
            }
        }
        LanguageFileType languageFileType = f;
        if (languageFileType == null) {
            StructuralSearchUtil.a(3);
        }
        return languageFileType;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        if (name == null) {
            StructuralSearchUtil.a(4);
        }
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    public static LanguageFileType @NotNull [] getSuitableFileTypes() {
        Object[] objectArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Set set = (Set)StreamEx.of((Object[])objectArray).select(LanguageFileType.class).collect(Collectors.toSet());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType languageFileType = language.getAssociatedFileType();
            if (languageFileType == null) continue;
            set.add(languageFileType);
        }
        LanguageFileType[] languageFileTypeArray = set.toArray(new LanguageFileType[0]);
        if (languageFileTypeArray == null) {
            StructuralSearchUtil.a(5);
        }
        return languageFileTypeArray;
    }

    public static boolean containsRegExpMetaChar(String s2) {
        return s2.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch2) {
        long l2 = h ^ 0x702308608F1CL;
        return e.indexOf(ch2) >= 0;
    }

    @NotNull
    public static String shieldRegExpMetaChars(@NotNull String word) {
        if (word == null) {
            StructuralSearchUtil.a(6);
        }
        String string = StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
        if (string == null) {
            StructuralSearchUtil.a(7);
        }
        return string;
    }

    public static String makeExtremeSpacesOptional(String word) {
        if (word.trim().isEmpty()) {
            return word;
        }
        Object object = word;
        if (word.startsWith(" ")) {
            object = "(?:\\s|\\b)" + ((String)object).substring(1);
        }
        if (word.endsWith(" ")) {
            object = ((String)object).substring(0, ((String)object).length() - 1) + "(?:\\s|\\b)";
        }
        return object;
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int n2 = word.length();
        for (int i10 = 0; i10 < n2; ++i10) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i10))) {
                out.append("\\");
            }
            out.append(word.charAt(i10));
        }
        StringBuilder stringBuilder = out;
        if (stringBuilder == null) {
            StructuralSearchUtil.a(8);
        }
        return stringBuilder;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        Pattern[] patternArray = new Pattern[prefixes.length];
        for (int i10 = 0; i10 < prefixes.length; ++i10) {
            String string = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i10]);
            patternArray[i10] = Pattern.compile("\\b(" + string + "\\w+)\\b");
        }
        return patternArray;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (d == null) {
            ArrayList arrayList = new ArrayList();
            for (StructuralSearchProfile structuralSearchProfile : StructuralSearchUtil.c()) {
                Collections.addAll(arrayList, structuralSearchProfile.getPredefinedTemplates());
            }
            Collections.sort(arrayList, a);
            d = Collections.unmodifiableList(arrayList);
        }
        return d;
    }

    public static boolean isDocCommentOwner(@NotNull PsiElement match) {
        StructuralSearchProfile structuralSearchProfile;
        if (match == null) {
            StructuralSearchUtil.a(9);
        }
        return (structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(match)) != null && structuralSearchProfile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return structuralSearchProfile != null ? structuralSearchProfile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(@NotNull PsiElement matchedNode, @NotNull String previousText) {
        StructuralSearchProfile structuralSearchProfile;
        if (matchedNode == null) {
            StructuralSearchUtil.a(10);
        }
        if (previousText == null) {
            StructuralSearchUtil.a(11);
        }
        return (structuralSearchProfile = StructuralSearchUtil.getProfileByPsiElement(matchedNode)) != null ? structuralSearchProfile.getAlternativeText(matchedNode, previousText) : null;
    }

    @NotNull
    public static String normalizeWhiteSpace(@NotNull String text2) {
        if (text2 == null) {
            StructuralSearchUtil.a(12);
        }
        text2 = text2.trim();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        int n2 = text2.length();
        for (int i10 = 0; i10 < n2; ++i10) {
            char c10 = text2.charAt(i10);
            if (StringUtil.isWhiteSpace((char)c10)) {
                if (bl2) continue;
                stringBuilder.append(' ');
                bl2 = true;
                continue;
            }
            bl2 = false;
            stringBuilder.append(c10);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            StructuralSearchUtil.a(13);
        }
        return string;
    }

    @NotNull
    public static String stripAccents(@NotNull String input) {
        if (input == null) {
            StructuralSearchUtil.a(14);
        }
        String string = g.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
        if (string == null) {
            StructuralSearchUtil.a(15);
        }
        return string;
    }

    @NotNull
    public static String normalize(@NotNull String text2) {
        if (text2 == null) {
            StructuralSearchUtil.a(16);
        }
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text2));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.a(17);
        }
        return StructuralSearchUtil.findPatternContextByID(id2, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id2, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> list2 = profile.getPatternContexts();
        if (list2.isEmpty()) {
            return null;
        }
        if (id2 == null) {
            return list2.get(0);
        }
        return list2.stream().filter(patternContext -> patternContext.getId().equals(id2)).findFirst().orElse(list2.get(0));
    }

    static {
        h = lb.a(-6729171580560703995L, -7662851635256861956L, MethodHandles.lookup().lookupClass()).a(85499859052950L);
        long l2 = h ^ 0x374449046C9EL;
        g = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        a = Comparator.comparing(Configuration::getCategory, NaturalComparator.INSTANCE).thenComparing(Configuration::getName, NaturalComparator.INSTANCE);
        c = new HashMap<String, StructuralSearchProfile>();
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> {
            d = null;
            f = null;
            c.clear();
        }, null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x5FC60C177CBL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "shieldRegExpMetaChars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "stripAccents";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByFileType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shieldRegExpMetaChars";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWhiteSpace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "stripAccents";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternContextByID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

