/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import a.b.lb;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RsyncService;
import com.intellij.ssh.SSHUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSyncUtil {
    private static final Logger a;
    @NlsSafe
    public static final String RSYNC = "rsync";
    public static final String RSYNC_OPTIONS = "-zarv";
    public static final String RSYNC_SSH_PORT_OPTION = "-e";
    public static final String RSYNC_PORT_OPTION = "-p %s";
    public static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    public static final String RSYNC_SSH_OPTIONS = "ssh %s %s";
    private static final String b = "--log-file=%s";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private static final long c;

    public static boolean checkRsyncInstalled() {
        return RsyncService.getInstance().checkIfRSyncCommandExists();
    }

    public static boolean shouldInstallRSync() {
        long l2 = c ^ 0x8635D099FADL;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            return false;
        }
        if (!PlatformUtils.isRubyMine()) {
            return false;
        }
        return !RSyncUtil.checkRsyncInstalled();
    }

    public static boolean canUseRSync() {
        long l2 = c ^ 0x6ABB3EFC2314L;
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync") || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.checkRsyncInstalled();
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (progressIndicator == null) {
            RSyncUtil.a(0);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, RSyncUtil.wrap(progressIndicator));
    }

    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (indicatorWrapper == null) {
            RSyncUtil.a(1);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, true, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, boolean omitRemoteLastDirectoryNameIfNeeded, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        if (indicatorWrapper == null) {
            RSyncUtil.a(2);
        }
        RSyncUtil.uploadWithRSync(localPath, remotePath, credentials, null, omitRemoteLastDirectoryNameIfNeeded, indicatorWrapper);
    }

    @ApiStatus.Experimental
    public static void uploadWithRSync(String localPath, String remotePath, RemoteCredentials credentials, @Nullable List<String> excludeElements, boolean omitRemoteLastDirectoryNameIfNeeded, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        Pair<String, List<String>> pair;
        if (indicatorWrapper == null) {
            RSyncUtil.a(3);
        }
        if (omitRemoteLastDirectoryNameIfNeeded && (pair = PathUtilRt.getFileName((String)remotePath)).equals((Object)PathUtilRt.getFileName((String)localPath))) {
            remotePath = remotePath.substring(0, remotePath.length() - pair.length());
        }
        pair = RSyncUtil.getRSyncCommandAndParameters(localPath, remotePath, credentials, null, null, excludeElements, true);
        RSyncUtil.a((String)pair.first, (List)pair.second, indicatorWrapper, credentials);
    }

    public static void testConnection(RemoteCredentials credentials, @NotNull IndicatorWrapper indicatorWrapper) throws ExecutionException {
        long l2 = c ^ 0x6B1DBD057D21L;
        if (indicatorWrapper == null) {
            RSyncUtil.a(4);
        }
        String string = Ssh.wrapIPv6Address(credentials.getHost());
        String string2 = RSyncUtil.a(credentials);
        String string3 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string4 = String.format(RSYNC_SSH_OPTIONS, string3, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-n");
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string4);
        arrayList.add(String.format("%s@%s:%s", credentials.getUserName(), string, ""));
        Pair pair = Pair.create((Object)RSYNC, arrayList);
        RSyncUtil.a((String)pair.first, (List)pair.second, indicatorWrapper, credentials);
    }

    private static String a(RemoteCredentials remoteCredentials) {
        long l2 = c ^ 0x5E618A0F564L;
        return !StringUtil.isEmpty((String)remoteCredentials.getPrivateKeyFile()) ? String.format(RSYNC_PUBLIC_KEY_OPTION, remoteCredentials.getPrivateKeyFile()) : "";
    }

    public static void downloadWithRSync(@NotNull String localPath, @NotNull String remotePath, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator, @Nullable File fileListPath, @Nullable String logfilePath) throws ExecutionException {
        if (localPath == null) {
            RSyncUtil.a(5);
        }
        if (remotePath == null) {
            RSyncUtil.a(6);
        }
        if (credentials == null) {
            RSyncUtil.a(7);
        }
        if (progressIndicator == null) {
            RSyncUtil.a(8);
        }
        if (!((String)remotePath).endsWith(File.separator)) {
            remotePath = (String)remotePath + File.separator;
        }
        FileUtil.createDirectory((File)new File(localPath));
        Pair<String, List<String>> pair = RSyncUtil.getRSyncCommandAndParameters(localPath, (String)remotePath, credentials, fileListPath, logfilePath, null, false);
        RSyncUtil.a((String)pair.first, (List)pair.second, RSyncUtil.wrap(progressIndicator), credentials);
    }

    public static void download(@NotNull List<? extends PathMappingSettings.PathMapping> pathMappings, @NotNull RemoteCredentials credentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        long l2 = c ^ 0x3D19B9E58259L;
        if (pathMappings == null) {
            RSyncUtil.a(9);
        }
        if (credentials == null) {
            RSyncUtil.a(10);
        }
        if (progressIndicator == null) {
            RSyncUtil.a(11);
        }
        Notification notification = null;
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"rsync_download", (String)".log");
            for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
                RSyncUtil.downloadWithRSync(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot(), credentials, progressIndicator, null, file.getPath());
            }
        }
        catch (IOException iOException) {
        }
        catch (SshRemoteHostIdentificationHasChangedException sshRemoteHostIdentificationHasChangedException) {
            String string = sshRemoteHostIdentificationHasChangedException.getMessage() + "\n" + SshBundle.message("rsync.ssh.remote.host.identification.has.changed.message", new Object[0]);
            notification = NOTIFICATION_GROUP.createNotification(string, null, null, NotificationType.ERROR);
        }
        if (notification == null) {
            notification = NOTIFICATION_GROUP.createNotification(SshBundle.message("rsync.download.complete.title", new Object[0]), null, null, NotificationType.INFORMATION);
            if (file != null) {
                final String string = file.getPath();
                a.debug(SshBundle.message("rsync.download.complete.message", string));
                notification.addAction((AnAction)new DumbAwareAction(SshBundle.messagePointer("action.Anonymous.text.log.file", new Object[0])){
                    private static final long a = lb.a(-138833354116948472L, -3860141488794329844L, MethodHandles.lookup().lookupClass()).a(223120201892557L);

                    public void actionPerformed(@NotNull AnActionEvent e10) {
                        if (e10 == null) {
                            1.a(0);
                        }
                        RevealFileAction.openFile((File)new File(string));
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x3A15442DEF79L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/RSyncUtil$1", "actionPerformed"));
                    }
                });
            }
        }
        notification.notify(null);
    }

    private static void a(@NotNull String string, @NotNull List<String> list2, final @NotNull IndicatorWrapper indicatorWrapper, final @NotNull RemoteCredentials remoteCredentials) throws ExecutionException {
        File file;
        if (string == null) {
            RSyncUtil.a(12);
        }
        if (list2 == null) {
            RSyncUtil.a(13);
        }
        if (indicatorWrapper == null) {
            RSyncUtil.a(14);
        }
        if (remoteCredentials == null) {
            RSyncUtil.a(15);
        }
        if ((file = PathEnvironmentVariableUtil.findExecutableInPathOnAnyOS((String)string)) == null) {
            a.warn("Command " + string + " not found in PATH");
            return;
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine().withConsoleMode(false);
        ptyCommandLine.setExePath(file.getPath());
        ptyCommandLine.addParameters(list2);
        final OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)ptyCommandLine);
        final PrintWriter printWriter = new PrintWriter(oSProcessHandler.getProcessInput());
        final Ref ref = new Ref();
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = lb.a(1652629170831975087L, 1234074299716709657L, MethodHandles.lookup().lookupClass()).a(221438045121089L);

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                long l2 = a ^ 0x42331AE3F419L;
                if (event == null) {
                    2.a(0);
                }
                if (outputType == null) {
                    2.a(1);
                }
                try {
                    indicatorWrapper.checkCanceled();
                }
                catch (ProcessCanceledException processCanceledException) {
                    oSProcessHandler.destroyProcess();
                }
                String string = event.getText();
                if (string == null) {
                    return;
                }
                indicatorWrapper.addText(string, outputType);
                if (outputType == ProcessOutputTypes.STDERR && !string.contains("No such file or directory")) {
                    a.info(string);
                }
                if (SSHUtil.PASSPHRASE_PROMPT.matcher(string).matches()) {
                    this.a(remoteCredentials.getPassphrase());
                } else if (string.toLowerCase(Locale.getDefault()).contains("remote host identification has changed")) {
                    ref.set((Object)new SshRemoteHostIdentificationHasChangedException());
                    oSProcessHandler.destroyProcess();
                } else if (RSyncUtil.isPasswordRequired(string)) {
                    String string2 = remoteCredentials.getPassword() != null ? remoteCredentials.getPassword() : remoteCredentials.getUserName();
                    this.a(string2);
                } else if (string.contains("Are you sure you want to continue connecting")) {
                    this.a("yes");
                }
            }

            private void a(String string) {
                printWriter.println(string != null ? string : "");
                printWriter.flush();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.a(2);
                }
                indicatorWrapper.finished(event.getExitCode());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x68581CACF247L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ssh/RSyncUtil$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        oSProcessHandler.startNotify();
        while (!oSProcessHandler.waitFor(200L)) {
            if (indicatorWrapper.isCanceled()) {
                oSProcessHandler.destroyProcess();
            }
            indicatorWrapper.checkCanceled();
        }
        oSProcessHandler.waitFor();
        if (!indicatorWrapper.isCanceled() && oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() != 0) {
            a.warn("RSync exited with code: " + oSProcessHandler.getExitCode() + "\n\t" + ptyCommandLine.getCommandLineString());
        }
        if (!ref.isNull()) {
            throw (ExecutionException)((Object)ref.get());
        }
    }

    public static IndicatorWrapper wrap(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RSyncUtil.a(16);
        }
        return new IndicatorWrapper(){
            private static final long a = lb.a(-8934875511346887409L, 7133941950231648551L, MethodHandles.lookup().lookupClass()).a(252100574655651L);

            @Override
            public boolean isCanceled() {
                return indicator.isCanceled();
            }

            @Override
            public void checkCanceled() throws ProcessCanceledException {
                indicator.checkCanceled();
            }

            @Override
            public void addText(@NotNull @Nls String text2, @NotNull Key<?> key) {
                if (text2 == null) {
                    3.a(0);
                }
                if (key == null) {
                    3.a(1);
                }
                if (key == ProcessOutputType.STDOUT && text2.contains(File.separator)) {
                    indicator.setText(text2);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x799D158D6EDEL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$3";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static boolean isPasswordRequired(String text2) {
        long l2 = c ^ 0x256668DF3CAEL;
        String string = text2.trim().toLowerCase(Locale.getDefault());
        return string.startsWith("password for") || string.endsWith("password:");
    }

    static Pair<String, List<String>> getRSyncCommandAndParameters(String localPath, String remotePath, RemoteCredentials credentials, @Nullable File fileListPath, @Nullable String logfilePath, @Nullable List<String> excludeElements, boolean isServerSideModification) {
        String string;
        String string2;
        long l2 = c ^ 0x64E39B764A19L;
        if (Platform.current() == Platform.UNIX) {
            remotePath = StringUtil.escapeChars((String)remotePath, (char[])new char[]{' '});
        }
        String string3 = Ssh.wrapIPv6Address(credentials.getHost());
        String string4 = String.format("%s@%s:%s", credentials.getUserName(), string3, remotePath);
        if (isServerSideModification) {
            string2 = localPath;
            string = string4;
        } else {
            string2 = string4;
            string = localPath;
        }
        String string5 = RSyncUtil.a(credentials);
        String string6 = String.format(RSYNC_PORT_OPTION, credentials.getPort());
        String string7 = String.format(RSYNC_SSH_OPTIONS, string6, string5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(RSYNC_OPTIONS);
        arrayList.add(RSYNC_SSH_PORT_OPTION);
        arrayList.add(string7);
        if (logfilePath != null) {
            arrayList.add(String.format(b, logfilePath));
        }
        if (fileListPath != null) {
            arrayList.add("--files-from=" + FileUtil.toSystemIndependentName((String)fileListPath.getPath()));
        }
        if (excludeElements != null) {
            for (String string8 : excludeElements) {
                arrayList.add("--exclude=" + string8);
            }
        }
        arrayList.add(string2);
        arrayList.add(string);
        return Pair.create((Object)RSYNC, arrayList);
    }

    static {
        c = lb.a(3350554418538296038L, 677565591714567186L, MethodHandles.lookup().lookupClass()).a(146233105962699L);
        long l2 = c ^ 0x35995A4A6435L;
        a = Logger.getInstance(RSyncUtil.class);
        NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Remote Transfer", (String)SshBundle.message("notification.group.name", new Object[0]));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x6FCA813EDAC6L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/RSyncUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadWithRSync";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "testConnection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadWithRSync";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "download";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndListenBashCommand";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface IndicatorWrapper {
        public boolean isCanceled();

        public void checkCanceled() throws ProcessCanceledException;

        public void addText(@NotNull @Nls String var1, @NotNull Key<?> var2);

        default public void finished(int exitCode) {
        }
    }
}

