/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import a.b.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import java.io.File;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0016\u0010\u0014\u001a\u00020\u000f*\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/FileBasedProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ProfilerProcessBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "k", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;Ljava/io/File;)V", "getDumpFileWhenTargetProcessFinished", "()Ljava/io/File;", "onTargetProcessTerminated", "", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readPreparedDumpAndReportStatistics", "asProfilerState", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "writer", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "intellij.profiler.common"})
public abstract class FileBasedProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends ProfilerProcessBase<TargetProcess> {
    @NotNull
    private final File k;
    private static final long l = lb.a(-3331426423065730678L, -4277500584458003917L, MethodHandles.lookup().lookupClass()).a(163744854910587L);

    @Override
    protected void onTargetProcessTerminated() {
        if (this.getState() != Attached.INSTANCE) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ FileBasedProfilerProcess this$0;

            public final void run() {
                if (this.this$0.getState() != Attached.INSTANCE) {
                    return;
                }
                this.this$0.changeStateAndNotifyAsync(ReadingData.INSTANCE);
                this.this$0.runUnderDumpReadIndicator((Function1<ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this){
                    final /* synthetic */ onTargetProcessTerminated.1 this$0;
                    private static final long a;

                    public final void invoke(@NotNull ProgressIndicator indicator) {
                        long l2 = a ^ 0x1CD19A712CAEL;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProfilerState profilerState = this.this$0.this$0.readPreparedDumpAndReportStatistics(this.this$0.this$0.getDumpFileWhenTargetProcessFinished(), indicator);
                        if (profilerState instanceof DataReady) {
                            ProfileHistoryConfiguration profileHistoryConfiguration = ProfileHistoryConfiguration.Companion.getInstance(this.this$0.this$0.getProject());
                            File file = this.this$0.this$0.getDumpFileWhenTargetProcessFinished();
                            StringBuilder stringBuilder = new StringBuilder().append(this.this$0.this$0.getTargetProcess().getPrettyHumanReadableNameWithoutPid()).append(" with '");
                            String string = this.this$0.this$0.getProfilerConfiguration().getDisplayName();
                            if (string == null) {
                                string = this.this$0.this$0.getDumpFileWhenTargetProcessFinished().getName();
                            }
                            profileHistoryConfiguration.register(file, stringBuilder.append(string).append('\'').toString());
                        }
                        this.this$0.this$0.changeStateAndNotifyAsync(profilerState);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    static {
                        a = lb.a(-7311703151091673160L, 8581682587515725776L, MethodHandles.lookup().lookupClass()).a(164937156464686L);
                    }
                }));
            }
            {
                this.this$0 = fileBasedProfilerProcess;
            }
        });
    }

    @NotNull
    protected final ProfilerState readPreparedDumpAndReportStatistics(@NotNull File dump, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        long l2 = l ^ 0x3C112FC73D4FL;
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        long l3 = System.currentTimeMillis();
        ProfilerState profilerState = this.readPreparedDump(dump, indicator);
        long l5 = System.currentTimeMillis() - l3;
        ProfilerUsageTriggerCollector.Companion.reportSnapshotGenerated(dump.length(), l5, this.getProfilerConfiguration().getConfigurationTypeId());
        return profilerState;
    }

    @NotNull
    protected abstract ProfilerState readPreparedDump(@NotNull File var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException;

    @NotNull
    protected final ProfilerState asProfilerState(@NotNull ProfilerDumpFileParsingResult $this$asProfilerState, @Nullable ProfilerDumpWriter writer) {
        ProfilerState profilerState;
        long l2 = l ^ 0x385FAFF52019L;
        Intrinsics.checkNotNullParameter((Object)$this$asProfilerState, (String)"$this$asProfilerState");
        ProfilerDumpFileParsingResult profilerDumpFileParsingResult = $this$asProfilerState;
        if (profilerDumpFileParsingResult instanceof Success) {
            profilerState = new DataReady(((Success)$this$asProfilerState).getData(), writer);
        } else if (profilerDumpFileParsingResult instanceof Failure) {
            profilerState = new ProfilerError(((Failure)$this$asProfilerState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return profilerState;
    }

    @NotNull
    protected final File getDumpFileWhenTargetProcessFinished() {
        return this.k;
    }

    public FileBasedProfilerProcess(@NotNull Project project, @NotNull TargetProcess targetProcess, @NotNull File dumpFileWhenTargetProcessFinished) {
        long l2 = l ^ 0x49809BA51B89L;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)dumpFileWhenTargetProcessFinished, (String)"dumpFileWhenTargetProcessFinished");
        super(project, targetProcess);
        this.k = dumpFileWhenTargetProcessFinished;
    }
}

