/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import java.awt.Point;

public class NodeFactoryImpl
extends NodeFactory {
    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName) {
        Graph2D graph2D = builder.getGraph();
        Graph2DView graph2DView = builder.getView();
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)builder).getDataMaps();
        Node node2 = GraphImplUtil.createNode((Graph)graph2D, graphDataMaps, nodeName, nodeObject);
        GraphImplUtil.setNodeObject(graphDataMaps, node2, nodeObject);
        builder.getGraph().setRealizer(node2, builder.getGraphPresentationModel().getNodeRealizer(nodeObject));
        GraphViewUtil.setRenderedNodeSizes((Graph2D)graph2D, (Graph2DView)graph2DView, (Node)node2);
        return node2;
    }

    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        Graph2D graph2D = builder.getGraph();
        Graph2DView graph2DView = builder.getView();
        Node node2 = this.createNode(builder, nodeObject, nodeName);
        graph2D.setLocation(node2, graph2DView.toWorldCoordX((int)location.getX()), graph2DView.toWorldCoordY((int)location.getY()));
        return node2;
    }

    public <N, E> Node createDraggedNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        Node node2 = this.createNode(builder, nodeObject, nodeName, location);
        GraphBuilderImpl graphBuilderImpl = (GraphBuilderImpl)builder;
        GraphImplUtil.setNodeWasDragged(graphBuilderImpl.getDataMaps(), node2);
        builder.updateGraph();
        return node2;
    }
}

