/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import a.b.lb;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphImplUtil {
    public static Key NODE_DRAGGED_INFO;
    private static final long a;

    private GraphImplUtil() {
    }

    @Nullable
    public static Node getExistedNode(@NotNull GraphDataMaps dataMaps, @NotNull String name, Object[] equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.a(0);
        }
        if (name == null) {
            GraphImplUtil.a(1);
        }
        ComparableNode comparableNode = GraphImplUtil.a(name, equalityObjects);
        Map<Node, ComparableNode> map2 = dataMaps.getNodeEqualityDataMap();
        for (Node node2 : map2.keySet()) {
            if (!comparableNode.equals(map2.get(node2))) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    public static <N, E> Edge getExistedEdge(GraphDataMaps<N, E> dataMaps, Node node1, Node node2, @NotNull String name, Object ... equalityObjects) {
        if (name == null) {
            GraphImplUtil.a(2);
        }
        ComparableEdge comparableEdge = GraphImplUtil.a(dataMaps, name, node1, node2, equalityObjects);
        Map<Edge, ComparableEdge> map2 = dataMaps.getEdgeEqualityDataMap();
        for (Edge edge : map2.keySet()) {
            if (!comparableEdge.equals(map2.get(edge))) continue;
            return edge;
        }
        return null;
    }

    public static List<Node> getNodes(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        for (Node node2 : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node2)) continue;
            arrayList.addAll(GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node2)));
        }
        return arrayList;
    }

    public static List<Edge> getEdges(Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        for (Node node2 : graph.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node2)) continue;
            arrayList.addAll(GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node2)));
        }
        return arrayList;
    }

    public static Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (graph == null) {
            GraphImplUtil.a(3);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(4);
        }
        if (name == null) {
            GraphImplUtil.a(5);
        }
        return GraphImplUtil.createNode(graph, null, dataMaps, name, equalityObjects);
    }

    public static Node createNode(@NotNull Graph rootGraph, @Nullable Graph innerGraph, @NotNull GraphDataMaps dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (rootGraph == null) {
            GraphImplUtil.a(6);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(7);
        }
        if (name == null) {
            GraphImplUtil.a(8);
        }
        Node node2 = innerGraph == null ? rootGraph.createNode() : innerGraph.createNode();
        GraphImplUtil.setNodeName(dataMaps, node2, name);
        dataMaps.getNodeEqualityDataMap().put(node2, GraphImplUtil.a(name, equalityObjects));
        return node2;
    }

    private static ComparableNode a(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(9);
        }
        return new ComparableNode("", objectArray);
    }

    private static <N, E> ComparableEdge a(GraphDataMaps<N, E> graphDataMaps, @NotNull String string, Node node2, Node node3, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(10);
        }
        return new ComparableEdge(string, GraphImplUtil.b(graphDataMaps, node2), GraphImplUtil.b(graphDataMaps, node3), objectArray);
    }

    private static <N, E> ComparableNode b(GraphDataMaps<N, E> graphDataMaps, Node node2) {
        return GraphImplUtil.a(GraphImplUtil.getNodeName(graphDataMaps, node2), GraphImplUtil.a(graphDataMaps, node2));
    }

    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node2) {
        String string;
        if (graphDataMaps == null) {
            GraphImplUtil.a(11);
        }
        if (node2 == null) {
            GraphImplUtil.a(12);
        }
        String string2 = (string = graphDataMaps.getNodeNameDataMap().get(node2)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.a(13);
        }
        return string2;
    }

    public static void setNodeName(GraphDataMaps dataMaps, Node node2, @NotNull String name) {
        if (name == null) {
            GraphImplUtil.a(14);
        }
        dataMaps.getNodeNameDataMap().put(node2, name);
    }

    public static <N, E> void setNodeObject(GraphDataMaps<N, E> graphDataMaps, Node node2, N nodeObject) {
        graphDataMaps.getNodeObjectDataMap().put((Object)node2, nodeObject);
    }

    public static <N, E> Node getOrCreateGroupNode(Graph2D graph, HierarchyManager hierarchyManager, NodesGroup group2, GraphDataMaps<N, E> dataMaps) {
        Node node2 = GraphImplUtil.a(graph, group2, hierarchyManager, dataMaps);
        if (node2 != null) {
            return node2;
        }
        NodesGroup nodesGroup = group2.getParent();
        if (nodesGroup != null) {
            Node node3 = GraphImplUtil.a(graph, nodesGroup, hierarchyManager, dataMaps);
            if (node3 == null) {
                node3 = GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, group2.getParent(), dataMaps);
            }
            return GraphImplUtil.a(hierarchyManager, graph, group2, node3, dataMaps);
        }
        return GraphImplUtil.a(hierarchyManager, graph, group2, dataMaps);
    }

    @Nullable
    public static <N, E> NodesGroup getGroup(GraphDataMaps<N, E> dataMaps, Node groupNode) {
        return dataMaps.getGroupNodeDataMap().get(groupNode);
    }

    private static <N, E> Node a(HierarchyManager hierarchyManager, Graph2D graph2D, NodesGroup nodesGroup, GraphDataMaps<N, E> graphDataMaps) {
        return GraphImplUtil.a(hierarchyManager, graph2D, nodesGroup, null, graphDataMaps);
    }

    private static <N, E> Node a(HierarchyManager hierarchyManager, Graph2D graph2D, NodesGroup nodesGroup, Node node2, GraphDataMaps<N, E> graphDataMaps) {
        Node node3 = node2 == null ? hierarchyManager.createGroupNode((Graph)graph2D) : hierarchyManager.createGroupNode(node2);
        graph2D.setLabelText(node3, nodesGroup.getGroupName());
        if (nodesGroup.getGroupNodeRealizer() != null) {
            graph2D.setRealizer(node3, (NodeRealizer)nodesGroup.getGroupNodeRealizer());
        }
        graphDataMaps.getGroupNodeDataMap().put(node3, nodesGroup);
        return node3;
    }

    @Nullable
    private static <N, E> Node a(Graph2D graph2D, @NotNull NodesGroup nodesGroup, HierarchyManager hierarchyManager, GraphDataMaps<N, E> graphDataMaps) {
        if (nodesGroup == null) {
            GraphImplUtil.a(15);
        }
        for (Node node2 : graph2D.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node2) && !hierarchyManager.isGroupNode(node2)) continue;
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node2))) {
                return node2;
            }
            Node node3 = GraphImplUtil.a(nodesGroup, hierarchyManager, graph2D, hierarchyManager.getChildren(node2), graphDataMaps);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node a(NodesGroup nodesGroup, HierarchyManager hierarchyManager, Graph2D graph2D, NodeCursor nodeCursor, GraphDataMaps<N, E> graphDataMaps) {
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node2))) {
                return node2;
            }
            Node node3 = GraphImplUtil.a(nodesGroup, hierarchyManager, graph2D, hierarchyManager.getChildren(node2), graphDataMaps);
            if (node3 != null) {
                return node3;
            }
            nodeCursor.next();
        }
        return null;
    }

    @Nullable
    public static <N, E> NodesGroup getGroupNode(GraphDataMaps<N, E> dataMaps, Node node2) {
        return dataMaps.getGroupNodeDataMap().get(node2);
    }

    public static <N, E> boolean isGroupNode(GraphDataMaps<N, E> dataMaps, Node node2) {
        return dataMaps.getGroupNodeDataMap().get(node2) != null;
    }

    public static <N, E> void setEdgeObject(GraphDataMaps<N, E> dataMaps, Edge edge, E edgeObject) {
        dataMaps.getEdgeObjectDataMap().put((Object)edge, edgeObject);
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E e10) {
        if (dataMaps == null) {
            GraphImplUtil.a(16);
        }
        if (e10 == null) {
            GraphImplUtil.a(17);
        }
        return dataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(dataMaps, e10));
    }

    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        String string;
        if (dataMaps == null) {
            GraphImplUtil.a(18);
        }
        if (edge == null) {
            GraphImplUtil.a(19);
        }
        return (string = dataMaps.getEdgeNameDataMap().get(edge)) == null ? "" : string;
    }

    public static <N, E> void setEdgeName(GraphDataMaps<N, E> dataMaps, Edge edge, @NotNull String name) {
        if (name == null) {
            GraphImplUtil.a(20);
        }
        dataMaps.getEdgeNameDataMap().put(edge, name);
    }

    public static <N, E> Edge createEdge(GraphDataMaps<N, E> dataMaps, Node node1, Node node2, @NotNull String name, Object[] equalityObjects) {
        if (name == null) {
            GraphImplUtil.a(21);
        }
        Edge edge = HierarchyManager.Statics.getInstance((Graph)dataMaps.getGraph()).createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put(edge, GraphImplUtil.a(dataMaps, name, node1, node2, equalityObjects));
        return edge;
    }

    @Nullable
    public static <N, E> N getNodeObject(GraphDataMaps<N, E> dataMaps, Node node2) {
        return (N)dataMaps.getNodeObjectDataMap().get((Object)node2);
    }

    @Nullable
    public static <N, E> E getEdgeObject(GraphDataMaps<N, E> dataMaps, Edge edge) {
        return (E)dataMaps.getEdgeObjectDataMap().get((Object)edge);
    }

    @Nullable
    public static <N, E> Node getNode(GraphDataMaps<N, E> dataMaps, N node2) {
        return node2 == null ? null : (Node)ContainerUtil.getFirstItem((List)dataMaps.getNodeObjectDataMap().getKeysByValue(node2));
    }

    @Nullable
    public static <N, E> Edge getEdge(GraphDataMaps<N, E> dataMaps, @NotNull E edge) {
        if (edge == null) {
            GraphImplUtil.a(22);
        }
        return (Edge)ContainerUtil.getFirstItem((List)dataMaps.getEdgeObjectDataMap().getKeysByValue(edge));
    }

    public static <N, E> void setNodeWasDragged(GraphDataMaps<N, E> dataMaps, Node node2) {
        dataMaps.getDraggedNodesList().add(node2);
    }

    public static <N, E> void updateDraggedNodesInfo(GraphBuilderImpl<N, E> builder) {
        GraphDataMaps<N, E> graphDataMaps = builder.getDataMaps();
        for (Node node2 : graphDataMaps.getGraph().getNodeArray()) {
            if (!graphDataMaps.getDraggedNodesList().contains(node2)) continue;
            if ((builder.getGraphUpdateModel().isNodeWasUpdated(node2) || builder.getGraphUpdateModel().isNodeWasCreated(node2)) && !GraphImplUtil.b(builder, node2)) {
                builder.getGraphUpdateModel().setNodeWasViewed(node2);
                graphDataMaps.getDraggedNodesList().remove(node2);
                continue;
            }
            GraphImplUtil.a(builder, node2);
        }
    }

    private static boolean b(GraphBuilderImpl graphBuilderImpl, Node node2) {
        return NODE_DRAGGED_INFO.equals(graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().get((Object)node2));
    }

    private static void a(GraphBuilderImpl graphBuilderImpl, Node node2) {
        graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().set((Object)node2, (Object)NODE_DRAGGED_INFO);
    }

    private static <N, E> ComparableNode a(GraphDataMaps<N, E> graphDataMaps, Node node2) {
        return graphDataMaps.getNodeEqualityDataMap().get(node2);
    }

    static {
        a = lb.a(-1755203972794746654L, 1462042417729499678L, MethodHandles.lookup().lookupClass()).a(49604215667574L);
        long l2 = a ^ 0x7501BAC87928L;
        NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3EAEF52B3968L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMaps";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGraph";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataMaps";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExistedEdge";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createComparableNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createComparableEdge";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNodeName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNode";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

