/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import a.b.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphBuilderEventHelper;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    private static final Logger b;
    private final Graph2D k;
    private final Graph2DView o;
    private final Project j;
    private final GraphDataMaps<N, E> c;
    private final GraphUpdateModel g;
    private final GraphDataModel<N, E> e;
    private final GraphPresentationModel<N, E> n;
    private final MergingUpdateQueue i;
    private Overview p;
    private boolean f;
    private boolean l;
    private final EditMode a;
    private final HierarchyManager h;
    private final List<CustomGraphUpdater> m;
    private boolean q;
    private GraphBuilderEventHelper d;
    private static final long r;

    public GraphBuilderImpl(Project project, Graph2D graph, Graph2DView view, GraphDataModel<N, E> graphDataModel, GraphPresentationModel<N, E> graphPresentationModel) {
        long l2 = r ^ 0x482AC91CD1DDL;
        this.m = new ArrayList<CustomGraphUpdater>();
        this.q = false;
        this.j = project;
        this.k = graph;
        this.o = view;
        this.c = new GraphDataMaps(this.k);
        this.h = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.e = graphDataModel;
        this.n = graphPresentationModel;
        this.g = new GraphUpdateModel((Graph)graph);
        this.o.setGraph2D(this.getGraph());
        this.a = this.createEditMode();
        this.i = new MergingUpdateQueue("YFiles", 100, true, this.o.getJComponent());
        this.o.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.c();
        this.d = new GraphBuilderEventHelper(this.a, this);
        Disposer.register((Disposable)this, this.e);
        Disposer.register((Disposable)this, this.n);
        Disposer.register((Disposable)this, (Disposable)this.i);
    }

    public final void initialize() {
        this.h();
        this.f = true;
        this.updateGraph();
    }

    public void updateGraph() {
        try {
            this.updateDataModel();
            this.updateView();
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    public void updateDataModel() {
        if (!this.a()) {
            this.initialize();
        }
        this.buildModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.b((Graph)this.getGraph());
        this.a((Graph)this.getGraph());
    }

    private void a(Graph graph) {
        Set set = this.getDataMaps().getEdgeObjectDataMap().keySet();
        for (Edge edge : set.toArray(new Edge[set.size()])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void a(Graph graph, Edge edge) {
        this.getDataMaps().removeEdge(edge);
        if (graph.contains(edge)) {
            graph.removeEdge(edge);
        }
    }

    private void b(Graph graph) {
        for (Node node2 : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node2) && !this.a(node2)) {
                this.getDataMaps().removeNode(node2);
                graph.removeNode(node2);
            }
            if (!this.getHierarchyManager().isFolderNode(node2)) continue;
            this.b(this.getHierarchyManager().getInnerGraph(node2));
            this.a(this.getHierarchyManager().getInnerGraph(node2));
        }
    }

    private void h() {
        this.g();
        this.getGraphPresentationModel().customizeSettings(this.getView(), this.a);
    }

    private void g() {
        Graph2DView graph2DView = this.getView();
        this.a.allowResizeNodes(false);
        this.a.allowNodeCreation(false);
        this.a.showNodeTips(true);
        this.a.showEdgeTips(true);
        this.a.allowEdgeCreation(true);
        this.a.allowMoveLabels(false);
        this.a.allowMovePorts(false);
        this.a.allowMoveSelection(true);
        graph2DView.setAntialiasedPainting(false);
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor(Color.LIGHT_GRAY);
        graph2DView.setGridType(Graph2DView.GRID_POINTS);
        graph2DView.addViewMode((ViewMode)this.a);
    }

    public Overview getOverview() {
        if (this.p == null) {
            this.p = GraphManager.getGraphManager().createOverview(this.getView());
        }
        return this.p;
    }

    protected EditMode createEditMode() {
        GraphEditModeFactory graphEditModeFactory = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = graphEditModeFactory.createEditMode(this);
        editMode.setPopupMode((ViewMode)graphEditModeFactory.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = graphEditModeFactory.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        return editMode;
    }

    public void updateView() {
        this.updateRealizers(false);
        this.e();
        this.d();
        this.b();
        for (CustomGraphUpdater customGraphUpdater : this.m) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void updateRealizers(boolean updateAllNodes) {
        for (Node node2 : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node2) && (updateAllNodes || this.isNodeWasCreated(node2))) {
                this.getGraph().setRealizer(node2, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node2)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node2);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private List<Edge> f() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (!this.isEdgeWasCreated(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    private List<Node> i() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node2 : this.getGraph().getNodeArray()) {
            if (this.a(node2) || !this.isNodeWasCreated(node2)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private void e() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabelArray;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.a(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private static void a(EdgeRealizer edgeRealizer) {
        for (int i10 = 0; i10 < edgeRealizer.labelCount(); ++i10) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i10));
        }
        edgeRealizer.setLabelText("");
    }

    private void b() {
        if (this.getGraph().getNodeArray().length > 0) {
            GraphUtil.doLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.l;
    }

    public final synchronized void queueUpdate() {
        long l2 = r ^ 0x3FDD42D5DF9L;
        if (this.isUpdating()) {
            return;
        }
        final Cursor cursor = this.o.getJComponent().getCursor();
        this.o.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
        this.l = true;
        this.i.queue(new Update("Update"){

            public void run() {
                GraphBuilderImpl.this.updateGraph();
                GraphBuilderImpl.this.l = false;
                GraphBuilderImpl.this.o.getJComponent().setCursor(cursor);
            }
        });
    }

    public GraphDataModel<N, E> getGraphDataModel() {
        return this.e;
    }

    @NotNull
    public String getNodeName(Node node2) {
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node2);
        if (string == null) {
            GraphBuilderImpl.a(0);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(Node node2) {
        return GraphImplUtil.getNodeObject(this.getDataMaps(), node2);
    }

    @Nullable
    public E getEdgeObject(Edge edge) {
        return GraphImplUtil.getEdgeObject(this.getDataMaps(), edge);
    }

    public void buildModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        this.createDataModel();
    }

    public void createDataModel() {
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        Collection collection = graphDataModel.getNodes();
        for (Object e10 : collection) {
            this.addNode(graphDataModel.getNodeName(e10), e10);
        }
        for (Object e10 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10);
        }
    }

    private void d() {
        NodeList nodeList;
        Object object3;
        Node node2;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node2 = this.getNode(object22);
                if (node2 == null || this.getHierarchyManager().isRootGraph(node2.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node2)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node2.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node3 : graph.getNodeArray()) {
                        if (this.a(node3)) continue;
                        nodeList.add((Object)node3);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node2);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node2 = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.h, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node2);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node2);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node2)) {
                arrayList.add(node2);
            }
            nodeList = graphManager.createNodeList();
            for (Object e10 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e10));
            }
            if (nodeList.size() <= 0 || !this.h.isGroupNode(node2)) continue;
            this.h.groupSubgraph(nodeList, node2);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.h.closeGroup((Node)nodesGroup2);
                node2 = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node2 instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node2).setGroupClosed(true);
                object3 = this.h.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.b();
            }
            catch (Throwable throwable) {
                b.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.a((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    private boolean a(Node node2) {
        return this.h.isFolderNode(node2) || this.h.isGroupNode(node2);
    }

    public void addNode(N nodeObject) {
        String string = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(string == null ? nodeObject.toString() : string, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.a(1);
        }
        this.addNode(name, nodeObject, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject, Object ... equalityObjects) {
        Node node2;
        if (name == null) {
            GraphBuilderImpl.a(2);
        }
        if ((node2 = GraphImplUtil.getExistedNode(this.getDataMaps(), name, equalityObjects)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node2)) {
                this.getGraphUpdateModel().setNodeWasViewed(node2);
                GraphImplUtil.setNodeName(this.getDataMaps(), node2, name);
            }
        } else {
            node2 = GraphImplUtil.createNode((Graph)this.getGraph(), this.b(nodeObject), this.getDataMaps(), name, equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node2);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node2, nodeObject);
    }

    @Nullable
    private Graph b(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node2 = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node2)) {
                return this.getHierarchyManager().getInnerGraph(node2);
            }
        }
        return null;
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(3);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(4);
        }
        return this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(5);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(6);
        }
        if (name == null) {
            GraphBuilderImpl.a(7);
        }
        return this.a(nodeObject1, nodeObject2, name, edgeObject, edgeObject);
    }

    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(8);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(9);
        }
        if (string == null) {
            GraphBuilderImpl.a(10);
        }
        Node node2 = this.a(n2);
        Node node3 = this.a(n3);
        return this.a(node2, node3, string, e10, objectArray);
    }

    private Edge a(@NotNull Node node2, @NotNull Node node3, @NotNull String string, E e10, Object ... objectArray) {
        Edge edge;
        if (node2 == null) {
            GraphBuilderImpl.a(11);
        }
        if (node3 == null) {
            GraphBuilderImpl.a(12);
        }
        if (string == null) {
            GraphBuilderImpl.a(13);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node2, node3, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getDataMaps(), node2, node3, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        return edge;
    }

    private Node a(N n2) {
        Node node2 = this.getNode(n2);
        if (node2 == null) {
            this.addNode(n2);
            node2 = this.getNode(n2);
        }
        if (node2 == null) {
            b.error("null node for " + n2 + " in " + this.e);
        }
        return node2;
    }

    public void dispose() {
        this.i.cancelAllUpdates();
        if (this.q) {
            return;
        }
        this.c.dispose();
        this.q = true;
    }

    @Nullable
    public String getNodeName(N nodeObject) {
        Node node2 = this.getNode(nodeObject);
        return node2 == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node2);
    }

    @Nullable
    public String getEdgeName(E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(N nodeObject) {
        return GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(E edgeObject) {
        return GraphImplUtil.getEdge(this.getDataMaps(), edgeObject);
    }

    public boolean isNodeWasCreated(Node node2) {
        return node2 != null && this.getGraphUpdateModel().isNodeWasCreated(node2);
    }

    public boolean isEdgeWasCreated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(Node node2) {
        return node2 != null && this.getGraphUpdateModel().isNodeWasUpdated(node2);
    }

    public boolean isEdgeWasUpdated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    public final Graph2D getGraph() {
        return this.k;
    }

    public Graph2DView getView() {
        return this.o;
    }

    public Project getProject() {
        return this.j;
    }

    public GraphUpdateModel getGraphUpdateModel() {
        return this.g;
    }

    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        return this.n;
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    public void setZoom(double zoom, boolean fireEvents) {
        if (fireEvents) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        }
        double d10 = MathUtil.clamp((double)zoom, (double)0.1, (double)20.0);
        Graph2DView graph2DView = this.getView();
        graph2DView.setZoom(d10);
        graph2DView.updateView();
        if (fireEvents) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
        }
    }

    public void fitContent() {
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        graph2DView.fitContent();
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.a(14);
        }
        this.d.fireEvent(event, before);
    }

    private boolean a() {
        return this.f;
    }

    private void c() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), string -> {
            if (string.equals(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    public HierarchyManager getHierarchyManager() {
        return this.h;
    }

    public void addCustomUpdater(CustomGraphUpdater updater) {
        this.m.add(updater);
    }

    public EditMode getEditMode() {
        return this.a;
    }

    public GraphDataMaps<N, E> getDataMaps() {
        return this.c;
    }

    public Collection<N> getNodeObjects() {
        return this.getDataMaps().getNodeObjectDataMap().values();
    }

    public Collection<E> getEdgeObjects() {
        return this.getDataMaps().getEdgeObjectDataMap().values();
    }

    public boolean removeNode(N n2) {
        Node node2 = this.getNode(n2);
        if (node2 != null) {
            this.getDataMaps().removeNode(node2);
            node2.getGraph().removeNode(node2);
            return true;
        }
        return false;
    }

    public boolean removeEdge(E e10) {
        Edge edge = this.getEdge(e10);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    public void addGraphBuilderListener(GraphBuilderListener listener, Disposable parent) {
        this.d.dispatcher.addListener((EventListener)listener, parent);
    }

    public void removeGraphBuilderListener(GraphBuilderListener listener) {
        this.d.dispatcher.removeListener((EventListener)listener);
    }

    static {
        r = lb.a(380159400413849266L, -3893202820386721481L, MethodHandles.lookup().lookupClass()).a(275862798463521L);
        b = Logger.getInstance(GraphBuilderImpl.class);
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x37A5624DF775L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

