/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;

class GraphBuilderEventHelper
implements MouseMotionListener,
KeyListener,
MouseWheelListener,
FocusListener {
    final EventDispatcher<GraphBuilderListener> dispatcher = EventDispatcher.create(GraphBuilderListener.class);
    private final Graph2DView h;
    private final EditMode e;
    private final ViewMode c = new NavigationMode();
    private final MagnifierViewMode g = new MagnifierViewMode();
    private volatile boolean f = false;
    private volatile boolean b = false;
    private final GraphBuilder a;
    private boolean d = false;

    GraphBuilderEventHelper(EditMode mode, GraphBuilder builder) {
        this.a = builder;
        this.h = builder.getView();
        this.e = mode;
        this.g.setMagnifierRadius(150);
        JComponent jComponent = this.h.getCanvasComponent();
        jComponent.addMouseMotionListener(this);
        jComponent.addKeyListener(this);
        jComponent.addMouseWheelListener(this);
        jComponent.addFocusListener(this);
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                if (e10.isPopupTrigger() && GraphBuilderEventHelper.this.f) {
                    GraphBuilderEventHelper.this.e.mousePressed(e10);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e10) {
                if (GraphBuilderEventHelper.this.d) {
                    GraphBuilderEventHelper.this.d = false;
                    GraphBuilderEventHelper.this.fireEvent(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    @Override
    public void mouseDragged(MouseEvent e10) {
        if (e10.isControlDown() && !e10.isAltDown()) {
            this.c();
        } else if (e10.isAltDown() && !e10.isControlDown()) {
            this.b();
        } else {
            if (!this.d) {
                this.d = true;
                this.fireEvent(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.a();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e10) {
        if (!e10.isAltDown() && this.b || !e10.isControlDown() && this.f) {
            this.a();
        }
    }

    @Override
    public void keyTyped(KeyEvent e10) {
    }

    @Override
    public void keyPressed(KeyEvent e10) {
        int n2 = e10.getKeyCode();
        boolean bl2 = e10.isAltDown();
        boolean bl3 = e10.isControlDown();
        if (bl3 && GraphBuilderEventHelper.b(n2)) {
            this.a(n2);
        } else if (n2 == 17 && !bl2) {
            this.c();
        } else if (n2 == 18 && !bl3) {
            this.b();
        } else {
            this.a();
        }
    }

    private void a(int n2) {
        Graph2D graph2D = this.h.getGraph2D();
        List list2 = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list2.size() > 0) {
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node2 : list2) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node2);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean b(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void c() {
        if (!this.f) {
            this.h.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.e.setEditing(false);
            this.e.reactivateParent();
            this.f = true;
            this.h.removeViewMode((ViewMode)(this.b ? this.g : this.e));
            this.b = false;
            this.h.addViewMode(this.c);
        }
    }

    private synchronized void b() {
        if (!this.b) {
            this.b = true;
            double d10 = this.h.getZoom();
            d10 = d10 < 1.0 ? 1.5 / d10 : 2.0 * d10;
            this.g.setMagnifierZoomFactor(d10);
            this.h.removeViewMode((ViewMode)(this.f ? this.c : this.e));
            this.f = false;
            this.h.addViewMode((ViewMode)this.g);
        }
    }

    private synchronized void a() {
        if (this.f) {
            this.fireEvent(GraphBuilderEvent.GRAPH_MOVED, false);
            this.f = false;
            this.h.removeViewMode(this.c);
            this.h.addViewMode((ViewMode)this.e);
        } else if (this.b) {
            this.b = false;
            this.h.removeViewMode((ViewMode)this.g);
            this.h.updateView();
            this.h.addViewMode((ViewMode)this.e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e10) {
        if (e10.getKeyCode() == 17 || e10.getKeyCode() == 18) {
            this.a();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e10) {
        int n2 = e10.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (e10.isControlDown()) {
            double d10 = this.h.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)ComponentUtil.getParentOfType(Magnificator.class, (Component)this.h.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d10 / this.h.getZoom(), e10.getPoint());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e10) {
    }

    @Override
    public void focusLost(FocusEvent e10) {
        this.a();
    }

    public void fireEvent(GraphBuilderEvent event, boolean before) {
        if (before) {
            ((GraphBuilderListener)this.dispatcher.getMulticaster()).beforeActionPerformed(this.a, event);
        } else {
            ((GraphBuilderListener)this.dispatcher.getMulticaster()).actionPerformed(this.a, event);
        }
    }
}

