/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import a.b.lb;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger b;
    private Int2ObjectMap<List<List<PsiFragment>>> e = new Int2ObjectOpenHashMap();
    private final int a;
    private boolean c = false;
    private final int d;
    private static final long f;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.a = bound;
        this.d = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.c = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.c = readOnly;
    }

    public void add(int hash, int cost, PsiFragment frag, NodeSpecificHasher visitor2) {
        this.a(hash, cost, frag);
    }

    private void a(int n2, int n3, PsiFragment psiFragment) {
        Object object;
        if (psiFragment == null) {
            this.e.put(n2, new ArrayList());
            return;
        }
        psiFragment.setCost(n3);
        List list2 = (List)this.e.get(n2);
        if (list2 == null) {
            if (!this.c) {
                ArrayList arrayList = new ArrayList();
                ArrayList<PsiFragment> arrayList2 = new ArrayList<PsiFragment>();
                arrayList2.add(psiFragment);
                arrayList.add(arrayList2);
                this.e.put(n2, arrayList);
            }
            return;
        }
        boolean bl2 = false;
        PsiElement[] psiElementArray = psiFragment.getElements();
        int n4 = 0;
        if (this.d >= 0) {
            n4 = this.d;
        } else {
            object = DuplocatorUtil.getDuplocatorState(psiFragment);
            if (object != null) {
                n4 = object.getDiscardCost();
            }
        }
        object = list2.iterator();
        while (object.hasNext() && !bl2) {
            List list3 = (List)object.next();
            PsiFragment psiFragment2 = (PsiFragment)list3.get(0);
            if (!psiFragment2.isEqual(psiElementArray, n4)) continue;
            boolean bl3 = false;
            Iterator iterator2 = list3.iterator();
            while (iterator2.hasNext() && !bl3) {
                PsiFragment psiFragment3 = (PsiFragment)iterator2.next();
                if (!psiFragment.intersectsWith(psiFragment3)) continue;
                if (psiFragment3.getCost() < psiFragment.getCost() || psiFragment.contains(psiFragment3)) {
                    iterator2.remove();
                    continue;
                }
                bl3 = true;
            }
            if (!bl3) {
                list3.add(psiFragment);
            }
            bl2 = true;
        }
        if (!bl2) {
            object = new ArrayList<PsiFragment>();
            object.add(psiFragment);
            list2.add(object);
        }
    }

    @Override
    public void add(int hash, int cost, PsiFragment frag) {
        int n2;
        if (this.a >= 0) {
            n2 = this.a;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            n2 = duplocatorState.getLowerBound();
        }
        if (cost >= n2) {
            this.a(hash, cost, frag);
        }
    }

    public DupInfo getInfo() {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (Int2ObjectMap.Entry entry : this.e.int2ObjectEntrySet()) {
            for (List list2 : (List)entry.getValue()) {
                int n2 = list2.size();
                if (n2 <= 1) continue;
                PsiFragment[] psiFragmentArray3 = new PsiFragment[n2];
                int n3 = 0;
                for (PsiFragment psiFragment : list2) {
                    psiFragment.markDuplicate();
                    psiFragmentArray3[n3++] = psiFragment;
                }
                object2IntOpenHashMap.put((Object)psiFragmentArray3, entry.getIntKey());
            }
        }
        this.e = null;
        final PsiFragment[][] psiFragmentArray4 = object2IntOpenHashMap.object2IntEntrySet().iterator();
        while (psiFragmentArray4.hasNext()) {
            Int2ObjectMap.Entry entry;
            entry = (Object2IntMap.Entry)psiFragmentArray4.next();
            PsiFragment[] psiFragmentArray5 = (PsiFragment[])entry.getKey();
            b.assertTrue(psiFragmentArray5.length > 1);
            boolean bl2 = false;
            for (PsiFragment psiFragment : psiFragmentArray5) {
                if (!psiFragment.isNested()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            psiFragmentArray4.remove();
        }
        psiFragmentArray4 = (PsiFragment[][])object2IntOpenHashMap.keySet().toArray((Object[])new PsiFragment[0][]);
        Arrays.sort(psiFragmentArray4, (psiFragmentArray, psiFragmentArray2) -> psiFragmentArray2[0].getCost() - psiFragmentArray[0].getCost());
        return new DupInfo((Object2IntMap)object2IntOpenHashMap){
            private final Int2ObjectMap<GroupNodeDescription> a = new Int2ObjectOpenHashMap();
            final /* synthetic */ Object2IntMap val$duplicateList;
            private static final long b = lb.a(3796226234737579776L, 5934732370447961465L, MethodHandles.lookup().lookupClass()).a(173556279391400L);
            {
                this.val$duplicateList = object2IntMap;
            }

            @Override
            public int getPatterns() {
                return psiFragmentArray4.length;
            }

            @Override
            public int getPatternCost(int number) {
                return psiFragmentArray4[number][0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return psiFragmentArray4[number].length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return psiFragmentArray4[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] psiFragmentArray = this.getFragmentOccurences(pattern);
                UsageInfo[] usageInfoArray = new UsageInfo[psiFragmentArray.length];
                for (int i10 = 0; i10 < usageInfoArray.length; ++i10) {
                    usageInfoArray[i10] = psiFragmentArray[i10].getUsageInfo();
                }
                return usageInfoArray;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.a.containsKey(pattern)) {
                    return ((GroupNodeDescription)this.a.get(pattern)).getFilesCount();
                }
                return this.a(pattern).getFilesCount();
            }

            private GroupNodeDescription a(int n2) {
                Object object;
                PsiFragment[] psiFragmentArray;
                long l2 = b ^ 0x214F5474D796L;
                HashSet<PsiFile> hashSet = new HashSet<PsiFile>();
                for (PsiFragment object22 : psiFragmentArray = this.getFragmentOccurences(n2)) {
                    object = object22.getFile();
                    if (object == null) continue;
                    hashSet.add((PsiFile)object);
                }
                int n3 = hashSet.size();
                PsiFile psiFile = psiFragmentArray[0].getFile();
                DuplicatesProfile duplicatesProfile = DuplicatesProfile.findProfileForDuplicate(this, n2);
                String string = duplicatesProfile != null ? duplicatesProfile.getComment(this, n2) : "";
                object = psiFile != null ? psiFile.getName() : DupLocatorBundle.message("duplicates.unknown.file.node.title", new Object[0]);
                GroupNodeDescription groupNodeDescription = new GroupNodeDescription(n3, (String)object, string);
                this.a.put(n2, (Object)groupNodeDescription);
                return groupNodeDescription;
            }

            @Override
            @Nullable
            @Nls
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.a.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.a.get(pattern)).getTitle();
                    }
                    return this.a(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            @Nls
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.a.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.a.get(pattern)).getComment();
                    }
                    return this.a(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i10) {
                return this.val$duplicateList.getInt((Object)psiFragmentArray4[i10]);
            }
        };
    }

    public void report(@NotNull Path dir, @NotNull Project project) throws IOException {
        long l2 = f ^ 0x7C0033902E09L;
        if (dir == null) {
            DuplocatorHashCallback.a(0);
        }
        if (project == null) {
            DuplocatorHashCallback.a(1);
        }
        int[] nArray = this.e.keySet().toIntArray();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(dir.resolve("fragments.xml"), new OpenOption[0]);){
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter((Writer)bufferedWriter);
            prettyPrintWriter.startNode("root");
            for (int n2 : nArray) {
                List list2 = (List)this.e.get(n2);
                prettyPrintWriter.startNode("hash");
                prettyPrintWriter.addAttribute("val", String.valueOf(n2));
                for (List list3 : list2) {
                    DuplocatorHashCallback.a(list3, (HierarchicalStreamWriter)prettyPrintWriter, project, false);
                }
                prettyPrintWriter.endNode();
            }
            prettyPrintWriter.endNode();
            prettyPrintWriter.flush();
        }
        DuplocatorHashCallback.writeDuplicates(dir, project, this.getInfo());
    }

    public static void writeDuplicates(@NotNull Path dir, @NotNull Project project, DupInfo info) throws IOException {
        long l2 = f ^ 0x6ED42AAC20F0L;
        if (dir == null) {
            DuplocatorHashCallback.a(2);
        }
        if (project == null) {
            DuplocatorHashCallback.a(3);
        }
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(dir.resolve("duplicates.xml"), new OpenOption[0]);){
            PrettyPrintWriter prettyPrintWriter = new PrettyPrintWriter((Writer)bufferedWriter);
            prettyPrintWriter.startNode("root");
            int n2 = info.getPatterns();
            for (int i10 = 0; i10 < n2; ++i10) {
                prettyPrintWriter.startNode("duplicate");
                prettyPrintWriter.addAttribute("cost", String.valueOf(info.getPatternCost(i10)));
                prettyPrintWriter.addAttribute("hash", String.valueOf(info.getHash(i10)));
                DuplocatorHashCallback.a(Arrays.asList(info.getFragmentOccurences(i10)), (HierarchicalStreamWriter)prettyPrintWriter, project, true);
                prettyPrintWriter.endNode();
            }
            prettyPrintWriter.endNode();
            prettyPrintWriter.flush();
        }
    }

    private static void a(List<? extends PsiFragment> list2, HierarchicalStreamWriter hierarchicalStreamWriter, @NotNull Project project, boolean bl2) {
        long l2 = f ^ 0x27FA51B44F9FL;
        if (project == null) {
            DuplocatorHashCallback.a(4);
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        for (PsiFragment psiFragment : list2) {
            PsiFile psiFile = psiFragment.getFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) continue;
            hierarchicalStreamWriter.startNode("fragment");
            hierarchicalStreamWriter.addAttribute("file", pathMacroManager.collapsePath(virtualFile.getUrl()));
            if (bl2) {
                Document document = psiDocumentManager.getDocument(psiFile);
                b.assertTrue(document != null);
                int n2 = psiFragment.getStartOffset();
                int n3 = document.getLineNumber(n2);
                hierarchicalStreamWriter.addAttribute("line", String.valueOf(n3));
                int n4 = document.getLineStartOffset(n3);
                if (Strings.isEmptyOrSpaces((CharSequence)document.getText().substring(n4, n2))) {
                    n2 = n4;
                }
                hierarchicalStreamWriter.addAttribute("start", String.valueOf(n2));
                hierarchicalStreamWriter.addAttribute("end", String.valueOf(psiFragment.getEndOffset()));
                if (psiFragment.containsMultipleFragments()) {
                    int[][] nArray;
                    for (int[] nArray2 : nArray = psiFragment.getOffsets()) {
                        hierarchicalStreamWriter.startNode("offset");
                        hierarchicalStreamWriter.addAttribute("start", String.valueOf(nArray2[0]));
                        hierarchicalStreamWriter.addAttribute("end", String.valueOf(nArray2[1]));
                        hierarchicalStreamWriter.endNode();
                    }
                }
            }
            hierarchicalStreamWriter.endNode();
        }
    }

    static {
        f = lb.a(7074864319992161637L, 1639394434308116276L, MethodHandles.lookup().lookupClass()).a(77079344839040L);
        b = Logger.getInstance(DuplocatorHashCallback.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x561696869A6DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/DuplocatorHashCallback";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

