/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts;

import a.b.lb;
import com.intellij.charts.BarChart;
import com.intellij.charts.BarDataset;
import com.intellij.charts.ChartWrapperKt;
import com.intellij.charts.Coordinates;
import com.intellij.charts.GridLine;
import com.intellij.charts.MinMax;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\u00072\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J)\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J>\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u0012H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/charts/HorizontalBarChart;", "T", "", "Lcom/intellij/charts/BarChart;", "()V", "findGridLabelOffset", "Lcom/intellij/charts/Coordinates;", "", "line", "Lcom/intellij/charts/GridLine;", "g", "Ljava/awt/Graphics2D;", "findGridLineX", "gl", "", "x", "findY", "xy", "Lcom/intellij/charts/MinMax;", "y", "(Lcom/intellij/charts/MinMax;Ljava/lang/Number;)D", "paintDataset", "", "Lcom/intellij/charts/BarDataset;", "datasetIndex", "datasetCount", "intellij.profiler.common"})
public final class HorizontalBarChart<T extends Number>
extends BarChart<T> {
    private static final long q = lb.a(1492891213791879839L, -1534632577182104058L, MethodHandles.lookup().lookupClass()).a(103591809267690L);

    @Override
    protected void paintDataset(@NotNull BarDataset<T> $this$paintDataset, int datasetIndex, int datasetCount, @NotNull Graphics2D g10, @NotNull MinMax<Integer, T> xy) {
        long l2 = q ^ 0x30C8428E8A81L;
        Intrinsics.checkNotNullParameter($this$paintDataset, (String)"$this$paintDataset");
        Intrinsics.checkNotNullParameter((Object)g10, (String)"g");
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        int n2 = xy.getXMin() == 0 ? 1 : 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && n2 == 0) {
            boolean bl3 = false;
            String string = "Int value must start with 0";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n2 = xy.getXMax() + 1;
        double d10 = ((Number)xy.getYMax()).doubleValue();
        double d11 = 0.0;
        boolean bl4 = false;
        double d12 = Math.max(d10, d11);
        if (d12 == (d10 = Double.min(((Number)xy.getYMin()).doubleValue(), 0.0))) {
            return;
        }
        Rectangle rectangle = g10.getClipBounds();
        double d13 = (double)rectangle.height / (d12 - d10);
        boolean bl5 = false;
        int n3 = (int)(d13 * Math.abs(d10));
        Iterable iterable = $this$paintDataset.getData();
        boolean bl6 = false;
        int n4 = 0;
        for (Object t2 : iterable) {
            Rectangle2D rectangle2D;
            Function1<T, String> function1;
            boolean bl7;
            Function1<T, String> function12;
            boolean bl8;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n4++;
            boolean bl9 = false;
            if (n9 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Number number = (Number)t2;
            int n10 = n9;
            boolean bl10 = false;
            int n11 = (int)(number.doubleValue() * d13);
            int n12 = rectangle.height - n11 - n3;
            int n13 = rectangle.width / n2 - this.getGap();
            int n14 = n10 * rectangle.width / n2 + this.getGap() / 2;
            if (this.getSpace() < 0) {
                n8 = 1;
                n7 = n13 / 10;
                n6 = 0;
                n5 = Math.max(n8, n7);
            } else {
                n5 = this.getSpace();
            }
            int n15 = n5;
            n7 = 1;
            n6 = (n13 - n15 * (datasetCount - 1)) / datasetCount;
            boolean bl11 = false;
            n8 = Math.max(n7, n6);
            n7 = n14 + datasetIndex * n8 + n15 * datasetIndex;
            if (n11 < 0) {
                n12 += n11;
                n6 = n11;
                bl11 = false;
                n11 = Math.abs(n6);
            }
            if ($this$paintDataset.getLineColor() != null) {
                Function1<T, String> function13;
                bl11 = false;
                bl8 = false;
                function12 = function13;
                bl7 = false;
                g10.setPaint($this$paintDataset.getLineColor());
                g10.drawRect(n7, n12, n8, n11);
            }
            if ($this$paintDataset.getFillColor() != null) {
                Paint paint;
                bl11 = false;
                bl8 = false;
                function12 = paint;
                bl7 = false;
                g10.setPaint((Paint)function12);
                g10.fillRect(n7, n12, n8, n11);
            }
            if ($this$paintDataset.getStacked()) {
                Area area = new Area(g10.getClip());
                area.subtract(new Area(new Rectangle(n7, n12, n8, n11)));
                g10.setClip(area);
            }
            if ($this$paintDataset.getShowValues() == null) continue;
            bl11 = false;
            bl8 = false;
            function12 = function1;
            bl7 = false;
            String string = (String)function12.invoke((Object)number);
            Rectangle2D rectangle2D2 = rectangle2D = g10.getFontMetrics().getStringBounds(string, g10);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"bounds");
            g10.drawString(string, n7 + (n8 - (int)rectangle2D2.getWidth()) / 2, n12 - 5);
        }
    }

    @Override
    protected double findGridLineX(@NotNull GridLine<Integer, T, ?> gl2, int x2) {
        long l2 = q ^ 0x43C4675FA4B0L;
        Intrinsics.checkNotNullParameter(gl2, (String)"gl");
        return (double)this.getGridWidth() * ((double)(x2 + 1) - (double)((Number)gl2.getXY().getXMin()).intValue()) / ((double)((Number)gl2.getXY().getXMax()).intValue() - (double)((Number)gl2.getXY().getXMin()).intValue() + 1.0);
    }

    @Override
    protected double findY(@NotNull MinMax<Integer, T> xy, @NotNull T y2) {
        long l2 = q ^ 0x28E1966A41F1L;
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        boolean bl2 = ((Number)xy.getYMin()).doubleValue() <= 0.0 && 0.0 <= ((Number)xy.getYMax()).doubleValue();
        double d10 = bl2 || ((Number)xy.getYMin()).doubleValue() < 0.0 ? ((Number)xy.getYMin()).doubleValue() : 0.0;
        double d11 = bl2 || ((Number)xy.getYMax()).doubleValue() > 0.0 ? ((Number)xy.getYMax()).doubleValue() : 0.0;
        int n2 = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        return (double)n2 - (double)n2 * (((Number)y2).doubleValue() - d10) / (d11 - d10);
    }

    @Override
    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g10) {
        long l2 = q ^ 0x5D2E9D8C0F66L;
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g10, (String)"g");
        Coordinates<Double, Double> coordinates = super.findGridLabelOffset(line, g10);
        if (line.getOrientation() == 1) {
            int n2 = this.getWidth() - (this.getMargins().left + this.getMargins().right);
            double d10 = (double)n2 / (((Number)line.getXY().getXMax()).doubleValue() - ((Number)line.getXY().getXMin()).doubleValue() + 1.0);
            return ChartWrapperKt.to(coordinates.getX() + d10 / (double)2, coordinates.getY());
        }
        return coordinates;
    }
}

