/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.ApkEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class Apk {
    public final String name;
    public final String checksum;
    public final String path;
    public final String packageName;
    public final List<String> targetPackages;
    public final Map<String, ApkEntry> apkEntries;

    private Apk(String name, String checksum, String path, String packageName, List<String> targetPackages, Map<String, ApkEntry> apkEntries) {
        this.name = name;
        this.checksum = checksum;
        this.path = path;
        this.packageName = packageName;
        this.targetPackages = targetPackages;
        this.apkEntries = apkEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "";
        private String checksum = "";
        private String path = "";
        private String packageName = "";
        private List<String> targetPackages = null;
        private ImmutableMap.Builder<String, ApkEntry> apkEntries = ImmutableMap.builder();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setTargetPackages(List<String> targetPackages) {
            this.targetPackages = targetPackages;
            return this;
        }

        @VisibleForTesting
        public Builder addApkEntry(String name, long checksum) {
            this.apkEntries.put((Object)name, (Object)new ApkEntry(name, checksum, null));
            return this;
        }

        public Builder addApkEntry(ZipUtils.ZipEntry zipEntry) {
            this.apkEntries.put((Object)zipEntry.name, (Object)new ApkEntry(zipEntry));
            return this;
        }

        public Apk build() {
            this.targetPackages = this.targetPackages == null ? ImmutableList.of() : this.targetPackages;
            Apk apk = new Apk(this.name, this.checksum, this.path, this.packageName, this.targetPackages, (Map)this.apkEntries.build());
            apk.apkEntries.values().forEach(entry -> entry.setApk(apk));
            return apk;
        }
    }
}

