/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.JvmtiErrorCode;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.List;

public class InstallerResponseHandler {
    public void handle(Deploy.SwapResponse response) throws DeployerException {
        if (response.getStatus() == Deploy.SwapResponse.Status.OK) {
            return;
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.PROCESS_CRASHING) {
            throw DeployerException.processCrashing(response.getExtra());
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.PROCESS_NOT_RESPONDING) {
            throw DeployerException.processNotResponding(response.getExtra());
        }
        if (response.getStatus() != Deploy.SwapResponse.Status.AGENT_ERROR) {
            throw DeployerException.swapFailed(response.getStatus());
        }
        this.handleAgentFailures(response.getFailedAgentsList());
    }

    private void handleAgentFailures(List<Deploy.AgentSwapResponse> failedAgents) throws DeployerException {
        if (failedAgents.size() == 0) {
            return;
        }
        Deploy.AgentSwapResponse failedAgent = failedAgents.get(0);
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.CLASS_NOT_FOUND) {
            throw DeployerException.classNotFound(failedAgent.getClassName());
        }
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.JVMTI_ERROR) {
            this.handleJvmtiError(failedAgent.getJvmtiError());
        }
        throw DeployerException.agentSwapFailed(failedAgent.getStatus());
    }

    private void handleJvmtiError(Deploy.JvmtiError jvmtiError) throws DeployerException {
        if (jvmtiError.getDetailsCount() == 0) {
            Optional errorCode = Enums.getIfPresent(JvmtiErrorCode.class, (String)jvmtiError.getErrorCode());
            throw DeployerException.jvmtiError((JvmtiErrorCode)((Object)errorCode.or((Object)JvmtiErrorCode.UNKNOWN_JVMTI_ERROR)));
        }
        Deploy.JvmtiError.Details details = (Deploy.JvmtiError.Details)jvmtiError.getDetailsList().get(0);
        String parentClass = details.getClassName();
        String resType = parentClass.substring(parentClass.lastIndexOf(36) + 1);
        if (details.getType() == Deploy.JvmtiError.Details.Type.FIELD_ADDED) {
            throw DeployerException.addedResources(details.getName(), resType);
        }
        if (details.getType() == Deploy.JvmtiError.Details.Type.FIELD_REMOVED) {
            throw DeployerException.removedResources(details.getName(), resType);
        }
        throw DeployerException.unknownJvmtiError(details.getType().name());
    }
}

