/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class InstallOptions {
    private final List<String> flags;

    private InstallOptions(List<String> flags) {
        this.flags = flags;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallOptions that = (InstallOptions)o;
        return this.flags.equals(that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public static final class Builder {
        private final List<String> flags = new ArrayList<String>();

        private Builder() {
        }

        public Builder setAllowDebuggable() {
            this.flags.add("-t");
            return this;
        }

        public Builder setGrantAllPermissions() {
            this.flags.add("-g");
            return this;
        }

        public Builder setInstallFullApk() {
            this.flags.add("--full");
            return this;
        }

        public Builder setUserInstallOptions(String[] userSpecifiedFlags) {
            if (userSpecifiedFlags == null) {
                return this;
            }
            this.flags.addAll(Arrays.asList(userSpecifiedFlags));
            return this;
        }

        public Builder setUserInstallOptions(String userSpecifiedFlag) {
            if (userSpecifiedFlag == null) {
                return this;
            }
            this.flags.add(userSpecifiedFlag);
            return this;
        }

        public InstallOptions build() {
            return new InstallOptions(this.flags);
        }
    }
}

