/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.tracer.Trace;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class D8DexSplitter
implements DexSplitter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<DexClass> split(ApkEntry dex, Predicate<DexClass> keepCode) {
        try (Trace ignored = Trace.begin((String)("split " + dex.getName()));){
            D8Command.Builder newBuilder = D8Command.builder();
            DexConsumer consumer = new DexConsumer(dex, keepCode);
            newBuilder.addDexProgramData(this.readDex(dex), Origin.unknown());
            newBuilder.setDexClassChecksumFilter(consumer::parseFilter);
            newBuilder.setProgramConsumer((ProgramConsumer)consumer);
            D8.run((D8Command)((D8Command)newBuilder.build()));
            consumer.join();
            Collection<DexClass> collection = consumer.classes.values();
            return collection;
        }
        catch (CompilationFailedException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[] readDex(ApkEntry dex) {
        byte[] byArray;
        ZipFile file = new ZipFile(dex.getApk().path);
        Throwable throwable = null;
        try {
            ZipEntry entry = file.getEntry(dex.getName());
            byArray = ByteStreams.toByteArray((InputStream)file.getInputStream(entry));
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    D8DexSplitter.$closeResource(throwable, file);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        D8DexSplitter.$closeResource(throwable, file);
        return byArray;
    }

    private static String typeNameToClassName(String typeName) {
        assert (typeName.startsWith("L"));
        assert (typeName.endsWith(";"));
        return typeName.substring(1, typeName.length() - 1).replace('/', '.');
    }

    private static class DexConsumer
    implements DexFilePerClassFileConsumer {
        private final Map<String, DexClass> classes = new HashMap<String, DexClass>();
        private final CountDownLatch finished = new CountDownLatch(1);
        private final Predicate<DexClass> keepCode;
        private final ApkEntry dex;

        private DexConsumer(ApkEntry dex, Predicate<DexClass> keepCode) {
            this.dex = dex;
            this.keepCode = keepCode;
        }

        public void finished(DiagnosticsHandler handler) {
            this.finished.countDown();
        }

        public void join() throws InterruptedException {
            this.finished.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean parseFilter(String classDescriptor, Long checksum) {
            DexClass c = new DexClass(D8DexSplitter.typeNameToClassName(classDescriptor), checksum == null ? 0L : checksum, null, this.dex);
            DexConsumer dexConsumer = this;
            synchronized (dexConsumer) {
                this.classes.put(classDescriptor, c);
            }
            if (this.keepCode != null) {
                return this.keepCode.test(c);
            }
            return false;
        }

        public synchronized void accept(String name, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
            DexClass clazz = this.classes.get(name);
            String className = D8DexSplitter.typeNameToClassName(name);
            if (clazz == null) {
                CRC32 crc = new CRC32();
                crc.update(data.getBuffer(), data.getOffset(), data.getLength());
                long newChecksum = crc.getValue();
                clazz = new DexClass(className, newChecksum, null, this.dex);
                this.classes.put(name, clazz);
            }
            if (this.keepCode != null && this.keepCode.test(clazz)) {
                this.classes.put(name, new DexClass(className, clazz.checksum, data.copyByteData(), this.dex));
            }
        }
    }
}

