/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.H2dbExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.H2dbIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2JdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> H2_UNLIMITED_TYPES = new HashSet<String>(Arrays.asList("uuid", "geometry", "other", "array", "timestamp with time zone", "null", "result_set"));
    private static final Set<String> H2_LIMITED_TYPES = new HashSet<String>(Arrays.asList("varchar", "varchar_ignorecase", "char", "tid"));

    public H2JdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("H2", version, connection);
    }

    public H2JdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            H2JdbcHelper.$$$reportNull$$$0(0);
        }
        return new H2dbIntermediateFacade(ds, H2dbExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            H2JdbcHelper.$$$reportNull$$$0(1);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        int n = e.length;
        if (n == 0x7FFFFFFE) {
            e.length = Integer.MAX_VALUE;
        } else if (H2_UNLIMITED_TYPES.contains(t) || n == 1 && "boolean".equals(t) || H2_LIMITED_TYPES.contains(t) && n == Integer.MAX_VALUE || t.equals("decimal") && e.scale == Short.MAX_VALUE && e.length == 65535) {
            e.length = -1;
        } else if (t.equals("varbinary")) {
            e.typeName = "binary";
            if (e.length == Integer.MAX_VALUE) {
                e.length = -1;
            }
        }
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return H2JdbcHelper.extractVersion(version);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "H2")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return H2JdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static H2JdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new H2JdbcHelper(H2JdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/H2JdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

