/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.DirectoryItem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.Item;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.intellij.xdebugger.XDebugSession;
import io.netty.util.CharsetUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0000\u001a\u001c\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0001\u001a&\u0010$\u001a\u0004\u0018\u00010\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\b\u001a\u0012\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a$\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-H\u0002\u001a\u0010\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001a\u0010/\u001a\u0004\u0018\u00010\f*\u00020\u001e2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0014\u00100\u001a\u0004\u0018\u00010\u0001*\u0002012\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u00102\u001a\u00020 *\u00020\u001d\u001a\n\u00103\u001a\u000204*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"ASAR", "", "REFERENCE_LINE", "REFERENCE_PATTERN_FILE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REFERENCE_PATTERN_LINE", "canonicalizeUrl", "Lcom/intellij/util/Url;", "url", "baseUrl", "decodeLocalSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "path", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "decodeString", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "charBuffer", "Ljava/nio/CharBuffer;", "findSourceMap", "parsedUrl", "findSourceMapLocally", "script", "Lorg/jetbrains/debugger/Script;", "getSourceMapUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/file/Path;", "string", "", "pattern", "getStringFromDataUri", "dataUrl", "loadFromDataUri", "sourceMapUrl", "baseFileUrl", "loadRemoteSourceMapData", "regularFile", "tail", "channel", "Ljava/nio/channels/SeekableByteChannel;", "size", "", "offset", "decodeSourceMap", "getSourceMapUrlFromAsar", "Lcom/intellij/util/io/AsarFileSystem;", "loadFile", "looksLikeInternalNodeScript", "", "intellij.javascript.debugger"})
public final class SourceMapLoaderKt {
    @NotNull
    public static final String ASAR = ".asar/";
    private static final String REFERENCE_LINE = "//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$";
    private static final Pattern REFERENCE_PATTERN_FILE = Pattern.compile("[\\r\\n]//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$");
    private static final Pattern REFERENCE_PATTERN_LINE = Pattern.compile("//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getSourceMapUrlFromAsar(@NotNull AsarFileSystem $this$getSourceMapUrlFromAsar, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceMapUrlFromAsar, (String)"$this$getSourceMapUrlFromAsar");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileItem fileItem = $this$getSourceMapUrlFromAsar.getFile(path);
        if (fileItem != null) {
            FileItem fileItem2 = fileItem;
            boolean bl = false;
            boolean bl2 = false;
            FileItem fileItem3 = fileItem2;
            boolean bl3 = false;
            Closeable closeable = $this$getSourceMapUrlFromAsar.openFileChannel();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                SeekableByteChannel it = (SeekableByteChannel)closeable;
                boolean bl6 = false;
                CharSequence charSequence = SourceMapLoaderKt.tail(it, fileItem3.getSize(), fileItem3.getOffset());
                Pattern pattern = REFERENCE_PATTERN_LINE;
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
                String string2 = SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean looksLikeInternalNodeScript(@NotNull Url $this$looksLikeInternalNodeScript) {
        Intrinsics.checkNotNullParameter((Object)$this$looksLikeInternalNodeScript, (String)"$this$looksLikeInternalNodeScript");
        if ($this$looksLikeInternalNodeScript.getScheme() != null) return false;
        if ($this$looksLikeInternalNodeScript.getAuthority() != null) return false;
        if ($this$looksLikeInternalNodeScript.getParameters() != null) return false;
        if (FileUtil.isAbsolutePlatformIndependent((String)$this$looksLikeInternalNodeScript.getPath())) return false;
        String string = $this$looksLikeInternalNodeScript.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) return false;
        String string2 = $this$looksLikeInternalNodeScript.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
        if (!StringsKt.endsWith$default((String)string2, (String)".js", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public static final SourceMap findSourceMapLocally(@NotNull Script script, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Path path;
        int n;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (SourceMapLoaderKt.looksLikeInternalNodeScript(script.getUrl())) {
            return null;
        }
        String string = ScriptDebuggerUrls.INSTANCE.toFilePath(script.getUrl());
        if (string == null) {
            return null;
        }
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)ASAR, (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            JSCachingFileFinder jSCachingFileFinder = debugProcess.getFinder();
            Object object = scriptPath;
            int n2 = 0;
            n = index + 5;
            boolean bl = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
            Project project = xDebugSession.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
            AsarFileSystem asarFileSystem = jSCachingFileFinder.getAsarFs$intellij_javascript_debugger(string3, project);
            if (asarFileSystem != null) {
                object = asarFileSystem;
                n2 = 0;
                n = 0;
                Object fs = object;
                boolean bl2 = false;
                String string4 = scriptPath;
                int n3 = index + ASAR.length();
                boolean bl3 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                String scriptRelativePath = string6;
                String string7 = SourceMapLoaderKt.getSourceMapUrlFromAsar((AsarFileSystem)fs, scriptRelativePath);
                if (string7 != null) {
                    SourceMap sourceMap;
                    string4 = string7;
                    n3 = 0;
                    bl3 = false;
                    String url = string4;
                    boolean bl4 = false;
                    Object object2 = url;
                    boolean bl5 = false;
                    if (object2.length() == 0) {
                        return null;
                    }
                    if (URLUtil.isDataUri((String)url)) {
                        return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
                    }
                    if (FileUtil.isAbsolutePlatformIndependent((String)url)) {
                        return SourceMapLoaderKt.decodeLocalSourceMap(url, debugProcess);
                    }
                    String string8 = PathUtilRt.getParentPath((String)scriptRelativePath);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"PathUtilRt.getParentPath(scriptRelativePath)");
                    DirectoryItem directoryItem = ((AsarFileSystem)fs).getDir(string8);
                    Item item = directoryItem != null ? directoryItem.findChild(url) : null;
                    if (!(item instanceof FileItem)) {
                        item = null;
                    }
                    FileItem fileItem = (FileItem)item;
                    if (fileItem != null) {
                        object2 = fileItem;
                        bl5 = false;
                        boolean bl6 = false;
                        Object it = object2;
                        boolean bl7 = false;
                        CharSequence charSequence = ((AsarFileSystem)fs).loadText((FileItem)it);
                        boolean bl8 = false;
                        boolean bl9 = false;
                        CharSequence it2 = charSequence;
                        boolean bl10 = false;
                        sourceMap = debugProcess.decodeSourceMap(it2, script.getUrl(), true);
                    } else {
                        sourceMap = null;
                    }
                    return sourceMap;
                }
            }
        }
        if ((path = SourceMapLoaderKt.regularFile(scriptPath)) == null) {
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
            Project project = xDebugSession.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
            VirtualFile virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(scriptPath, project);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                n = 0;
                boolean bl = false;
                VirtualFile it = virtualFile2;
                boolean bl11 = false;
                String string9 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"it.path");
                path = SourceMapLoaderKt.regularFile(string9);
            } else {
                path = null;
            }
        }
        if (path == null) {
            return null;
        }
        Path path2 = path;
        String url = SourceMapLoaderKt.getSourceMapUrl(path2);
        if (url == null) {
            Path mapPath = path2.getParent().resolve(path2.getFileName() + ".map");
            if (Files.isRegularFile(mapPath, new LinkOption[0]) && Files.getLastModifiedTime(mapPath, new LinkOption[0]).toMillis() + (long)100 >= Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis()) {
                Path path3 = mapPath;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"mapPath");
                return debugProcess.decodeSourceMap(PathKt.readChars((Path)path3), script.getUrl(), true);
            }
            return null;
        }
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        if (URLUtil.isDataUri((String)url)) {
            return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
        }
        Path path4 = path2.getParent().resolve(url);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path.parent.resolve(url)");
        return SourceMapLoaderKt.decodeSourceMap(path4, debugProcess);
    }

    private static final SourceMap decodeLocalSourceMap(String path, JavaScriptDebugProcess<?> debugProcess) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
        return SourceMapLoaderKt.decodeSourceMap(path2, debugProcess);
    }

    private static final SourceMap decodeSourceMap(Path $this$decodeSourceMap, JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        if (Files.isRegularFile($this$decodeSourceMap, new LinkOption[0])) {
            Path path = $this$decodeSourceMap.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize()");
            CharSequence charSequence = PathKt.readChars((Path)path);
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence;
            boolean bl3 = false;
            sourceMap = debugProcess.decodeSourceMap(it, Urls.newLocalFileUrl((String)((Object)$this$decodeSourceMap).toString()), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    private static final SourceMap loadFromDataUri(JavaScriptDebugProcess<?> debugProcess, Script script, String url) {
        SourceMap sourceMap;
        CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(url, script.getUrl());
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence2;
            boolean bl3 = false;
            sourceMap = debugProcess.decodeSourceMap(it, script.getUrl(), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    @Nullable
    public static final Path regularFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        boolean bl = false;
        boolean bl2 = false;
        Path it = path2;
        boolean bl3 = false;
        return Files.isRegularFile(it, new LinkOption[0]) ? it : null;
    }

    @Nullable
    public static final SourceMap findSourceMap(@NotNull Url parsedUrl, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMapFromLocalFile;
        String path;
        Intrinsics.checkNotNullParameter((Object)parsedUrl, (String)"parsedUrl");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (parsedUrl.isInLocalFileSystem() && (path = ScriptDebuggerUrls.INSTANCE.toFilePath(parsedUrl)) != null && (sourceMapFromLocalFile = SourceMapLoaderKt.decodeLocalSourceMap(path, debugProcess)) != null) {
            return sourceMapFromLocalFile;
        }
        Function1<String, SourceMap> $fun$findFile$1 = new Function1<String, SourceMap>(debugProcess, parsedUrl){
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ Url $parsedUrl;

            @Nullable
            public final SourceMap invoke(@Nullable String sourceContent) {
                String content = sourceContent;
                JSCachingFileFinder jSCachingFileFinder = this.$debugProcess.getFinder();
                XDebugSession xDebugSession = this.$debugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                Project project = xDebugSession.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
                VirtualFile sourceMapFile = jSCachingFileFinder.findFile(this.$parsedUrl, project, false, sourceContent, null);
                if (sourceMapFile != null || sourceContent != null) {
                    if (sourceContent == null) {
                        VirtualFile virtualFile = sourceMapFile;
                        Intrinsics.checkNotNull((Object)virtualFile);
                        virtualFile.refresh(false, false);
                        content = VfsUtil.loadText((VirtualFile)sourceMapFile);
                    }
                    Url baseUrl = sourceMapFile != null ? Urls.newLocalFileUrl((VirtualFile)sourceMapFile) : this.$parsedUrl;
                    String string = content;
                    Intrinsics.checkNotNull((Object)string);
                    return this.$debugProcess.decodeSourceMap(string, baseUrl, true);
                }
                return null;
            }
            {
                this.$debugProcess = javaScriptDebugProcess;
                this.$parsedUrl = url;
                super(1);
            }
        };
        if (BuiltInServerManager.Companion.getInstance().isOnBuiltInWebServer(parsedUrl)) {
            SourceMap sourceMap = $fun$findFile$1.invoke(null);
            if (sourceMap != null) {
                sourceMapFromLocalFile = sourceMap;
                boolean bl = false;
                boolean bl2 = false;
                SourceMap it = sourceMapFromLocalFile;
                boolean bl3 = false;
                return it;
            }
        }
        boolean isSchemeAcceptable = false;
        String sourceContent = null;
        if (Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"https")) {
            isSchemeAcceptable = true;
            CharSequence charSequence = SourceMapLoaderKt.loadRemoteSourceMapData(parsedUrl);
            sourceContent = charSequence != null ? ((Object)charSequence).toString() : null;
        }
        SourceMap sourceMap = $fun$findFile$1.invoke(sourceContent);
        if (sourceMap != null) {
            SourceMap sourceMap2 = sourceMap;
            boolean bl = false;
            boolean bl4 = false;
            SourceMap it = sourceMap2;
            boolean bl5 = false;
            return it;
        }
        if (!isSchemeAcceptable && !parsedUrl.isInLocalFileSystem()) {
            CommandProcessorKt.getLOG().warn("Cannot load source map from '" + parsedUrl + "': scheme " + parsedUrl.getScheme() + " is not supported");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private static final CharSequence loadRemoteSourceMapData(Url parsedUrl) {
        CharSequence charSequence;
        long start = System.nanoTime();
        String string = parsedUrl.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parsedUrl.toExternalForm()");
        String url = string;
        try {
            CharSequence result2;
            CharSequence charSequence2 = HttpRequests.request((Url)parsedUrl).productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(parsedUrl){
                final /* synthetic */ Url $parsedUrl;

                public final void tune(@NotNull URLConnection it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (BuiltInServerManager.Companion.getInstance().isOnBuiltInWebServer(this.$parsedUrl)) {
                        it.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
                    }
                }
                {
                    this.$parsedUrl = url;
                }
            }).readChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"HttpRequests.request(par\u2026     }\n      .readChars()");
            charSequence = result2 = charSequence2;
            boolean bl = false;
            charSequence = charSequence.length() == 0 ? null : result2;
        }
        catch (HttpRequests.HttpStatusException e) {
            CommandProcessorKt.getLOG().debug((Throwable)e);
            CharSequence charSequence3 = null;
            Logger $this$debug$iv = CommandProcessorKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "Loading of %s took %d ms";
                Object[] objectArray = new Object[]{url, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)};
                boolean bl2 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                logger.debug(string4, (Throwable)e$iv);
            }
            return charSequence3;
        }
        catch (Exception e2) {
            CommandProcessorKt.getLOG().warn((Throwable)e2);
            {
                catch (Throwable throwable) {
                    Logger $this$debug$iv = CommandProcessorKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string5 = "Loading of %s took %d ms";
                        Object[] objectArray = new Object[]{url, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)};
                        boolean bl3 = false;
                        String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                        String string7 = string6;
                        logger.debug(string7, (Throwable)e$iv);
                    }
                    throw throwable;
                }
            }
            Logger $this$debug$iv2 = CommandProcessorKt.getLOG();
            Exception e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                Logger logger = $this$debug$iv2;
                boolean bl = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string8 = "Loading of %s took %d ms";
                Object[] objectArray = new Object[]{url, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)};
                boolean bl4 = false;
                String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"java.lang.String.format(format, *args)");
                String string10 = string9;
                logger.debug(string10, (Throwable)e$iv2);
            }
        }
        Logger $this$debug$iv = CommandProcessorKt.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string11 = "Loading of %s took %d ms";
            Object[] objectArray = new Object[]{url, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)};
            boolean bl5 = false;
            String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"java.lang.String.format(format, *args)");
            String string13 = string12;
            logger.debug(string13, (Throwable)e$iv);
        }
        return charSequence;
        return null;
    }

    @Nullable
    public static final String getStringFromDataUri(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        Matcher matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String string;
                String content = matcher.group(4);
                if (StringsKt.equals((String)";base64", (String)matcher.group(3), (boolean)true)) {
                    byte[] byArray = Base64.getDecoder().decode(content);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(content)");
                    byte[] byArray2 = byArray;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    boolean bl2 = false;
                    string = new String(byArray2, charset);
                } else {
                    string = content;
                }
                return string;
            }
            catch (IllegalArgumentException e) {
                CommandProcessorKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static final CharSequence loadFromDataUri(@NotNull String sourceMapUrl, @NotNull Url baseFileUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceMapUrl, (String)"sourceMapUrl");
        Intrinsics.checkNotNullParameter((Object)baseFileUrl, (String)"baseFileUrl");
        String string = baseFileUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseFileUrl.path");
        if (StringsKt.endsWith$default((String)string, (String)"nodent.min.js", (boolean)false, (int)2, null)) {
            return null;
        }
        String sourceMapData = SourceMapLoaderKt.getStringFromDataUri(sourceMapUrl);
        if (sourceMapData == null) {
            String message = "Cannot decode sourcemap data URI " + baseFileUrl;
            CommandProcessorKt.getLOG().error(message);
            return null;
        }
        CharSequence charSequence = sourceMapData;
        boolean bl = false;
        return charSequence.length() == 0 ? null : (CharSequence)sourceMapData;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return Urls.newFromEncoded((String)url);
        }
        return SourceResolverKt.doCanonicalize((String)url, (Url)baseUrl, (boolean)true, (boolean)false);
    }

    @NotNull
    public static final CharSequence loadFile(@NotNull VirtualFile $this$loadFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadFile, (String)"$this$loadFile");
        return IoKt.readCharSequence((Reader)new InputStreamReader($this$loadFile.getInputStream(), $this$loadFile.getCharset()), (int)((int)$this$loadFile.getLength()));
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            if (file2.isInLocalFileSystem()) {
                Path path = Paths.get(file2.getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(file.path)");
                return SourceMapLoaderKt.getSourceMapUrl(path);
            }
            CharSequence charSequence = SourceMapLoaderKt.loadFile(file2);
            Pattern pattern = REFERENCE_PATTERN_FILE;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_FILE");
            return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
        }
        catch (IOException e) {
            CommandProcessorKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CharSequence charSequence = SourceMapLoaderKt.tail(file2);
        Pattern pattern = REFERENCE_PATTERN_LINE;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
        return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
    }

    private static final String getSourceMapUrl(CharSequence string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final CharSequence tail(@NotNull Path file2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Closeable closeable = Files.newByteChannel(file2, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl3 = false;
            SeekableByteChannel seekableByteChannel = it;
            Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"it");
            charSequence = SourceMapLoaderKt.tail$default(seekableByteChannel, (int)Files.size(file2), 0, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return charSequence;
    }

    /*
     * Unable to fully structure code
     */
    private static final CharSequence tail(SeekableByteChannel channel, int size, int offset) {
        bufferSize = Math.min(4096, size);
        trim = true;
        stringBuilder = null;
        charBuffer = null;
        buffer = ByteBuffer.allocate(bufferSize);
        position = offset + (size - bufferSize);
        while (position >= offset) {
            channel.position(position);
            for (count = 0; count < bufferSize && (n = channel.read(buffer)) > 0; count += n) {
            }
            n = buffer.position() - 1;
            var11_11 = false;
            while (n >= 0) {
                c = (char)buffer.get((int)p);
                if (!trim) ** GOTO lbl22
                if (c == '\n' || c == '\r' || c == ';' || c == ')' || c == '}') {
                    buffer.limit((int)p);
                } else {
                    trim = false;
lbl22:
                    // 2 sources

                    if (c == '\n') {
                        buffer.position((int)(p + true));
                        if (charBuffer == null) {
                            charBuffer = CharBuffer.allocate(buffer.remaining());
                        }
                        v0 = buffer;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"buffer");
                        v1 = charBuffer;
                        Intrinsics.checkNotNull((Object)v1);
                        SourceMapLoaderKt.decodeString(v0, v1);
                        return stringBuilder == null ? (CharSequence)charBuffer : (CharSequence)stringBuilder.insert(0, charBuffer);
                    }
                }
                --p;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(bufferSize * 2);
            }
            if (charBuffer == null) {
                charBuffer = CharBuffer.allocate(bufferSize);
            }
            buffer.position(0);
            v2 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"buffer");
            v3 = charBuffer;
            Intrinsics.checkNotNull((Object)v3);
            SourceMapLoaderKt.decodeString(v2, v3);
            stringBuilder.insert(0, charBuffer);
            buffer.clear();
            charBuffer.clear();
            if (position == 0) break;
            if (position < bufferSize) {
                bufferSize = position;
                buffer.limit(position);
                position = 0;
                continue;
            }
            position -= bufferSize;
        }
        return null;
    }

    static /* synthetic */ CharSequence tail$default(SeekableByteChannel seekableByteChannel, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return SourceMapLoaderKt.tail(seekableByteChannel, n, n2);
    }

    private static final void decodeString(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)Charsets.UTF_8);
        CoderResult coderResult2 = coderResult = decoder.decode(byteBuffer, charBuffer, true);
        Intrinsics.checkNotNullExpressionValue((Object)coderResult2, (String)"coderResult");
        if (!coderResult2.isUnderflow()) {
            coderResult.throwException();
        }
        CoderResult coderResult3 = coderResult = decoder.flush(charBuffer);
        Intrinsics.checkNotNullExpressionValue((Object)coderResult3, (String)"coderResult");
        if (!coderResult3.isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
    }
}

