/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.DynamicBundle;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.javascript.debugger.settings.SteppingFilter;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaScriptSteppingConfigurableUi
implements ConfigurableUi<JavaScriptDebuggerSettings> {
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{new TableModelEditor.EditableColumnInfo<SteppingFilter, Boolean>(){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(SteppingFilter item) {
            return item.isEnabled();
        }

        public void setValue(SteppingFilter item, Boolean value) {
            item.setEnabled(value);
        }
    }, new TableModelEditor.EditableColumnInfo<SteppingFilter, String>(){

        public String valueOf(SteppingFilter item) {
            return item.getUrlPattern();
        }

        public void setValue(SteppingFilter item, String value) {
            item.setUrlPattern(value);
        }
    }};
    private JCheckBox doNotStepIntoLibraryCodeCheckbox;
    private JCheckBox alwaysDoSmartStepIntoCheckbox;
    private JCheckBox steppingFiltersEnabledCheckbox;
    private JComponent steppingFiltersPanel;
    private JPanel panel;
    private TableModelEditor<SteppingFilter> steppingFiltersEditor;

    JavaScriptSteppingConfigurableUi() {
        this.$$$setupUI$$$();
        this.steppingFiltersEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent e) {
                JavaScriptSteppingConfigurableUi.this.updateFiltersTable();
            }
        });
    }

    private void updateFiltersTable() {
        this.steppingFiltersEditor.enabled(this.steppingFiltersEnabledCheckbox.isSelected());
    }

    public void reset(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptSteppingConfigurableUi.$$$reportNull$$$0(0);
        }
        this.doNotStepIntoLibraryCodeCheckbox.setSelected(settings.isDoNotStepIntoLibraryCode());
        this.alwaysDoSmartStepIntoCheckbox.setSelected(settings.isAlwaysDoSmartStepInto());
        this.steppingFiltersEnabledCheckbox.setSelected(settings.isSteppingFiltersEnabled());
        this.steppingFiltersEditor.reset(settings.getSteppingFilters());
        this.updateFiltersTable();
    }

    public boolean isModified(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptSteppingConfigurableUi.$$$reportNull$$$0(1);
        }
        return this.doNotStepIntoLibraryCodeCheckbox.isSelected() != settings.isDoNotStepIntoLibraryCode() || this.steppingFiltersEnabledCheckbox.isSelected() != settings.isSteppingFiltersEnabled() || this.alwaysDoSmartStepIntoCheckbox.isSelected() != settings.isAlwaysDoSmartStepInto() || this.steppingFiltersEditor.isModified();
    }

    public void apply(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            JavaScriptSteppingConfigurableUi.$$$reportNull$$$0(2);
        }
        settings.setDoNotStepIntoLibraryCode(this.doNotStepIntoLibraryCodeCheckbox.isSelected());
        settings.setAlwaysDoSmartStepInto(this.alwaysDoSmartStepIntoCheckbox.isSelected());
        settings.setSteppingFiltersEnabled(this.steppingFiltersEnabledCheckbox.isSelected());
        if (this.steppingFiltersEditor.isModified()) {
            settings.setSteppingFilters(this.steppingFiltersEditor.apply());
        }
        JavaScriptDebuggerSettings.onSettingsChanged(false, true);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            JavaScriptSteppingConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        TableModelEditor.DialogItemEditor<SteppingFilter> itemEditor = new TableModelEditor.DialogItemEditor<SteppingFilter>(){

            public SteppingFilter clone(@NotNull SteppingFilter item, boolean forInPlaceEditing) {
                if (item == null) {
                    4.$$$reportNull$$$0(0);
                }
                return new SteppingFilter(item.isEnabled(), item.getUrlPattern());
            }

            @NotNull
            public Class<SteppingFilter> getItemClass() {
                return SteppingFilter.class;
            }

            public void edit(@NotNull SteppingFilter item, @NotNull Function<SteppingFilter, SteppingFilter> mutator, boolean isAdd) {
                String pattern;
                if (item == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (mutator == null) {
                    4.$$$reportNull$$$0(2);
                }
                if ((pattern = Messages.showInputDialog((Component)JavaScriptSteppingConfigurableUi.this.panel, (String)JSDebuggerBundle.message("label.text.specify.url.pattern", new Object[0]), (String)JSDebuggerBundle.message("dialog.title.stepping.filter", new Object[0]), null, (String)item.getUrlPattern(), (InputValidator)new NonEmptyInputValidator())) != null) {
                    ((SteppingFilter)mutator.fun((Object)item)).setUrlPattern(pattern);
                }
            }

            public void applyEdited(@NotNull SteppingFilter oldItem, @NotNull SteppingFilter newItem) {
                if (oldItem == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (newItem == null) {
                    4.$$$reportNull$$$0(4);
                }
                newItem.setUrlPattern(oldItem.getUrlPattern());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mutator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldItem";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "clone";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "edit";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyEdited";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.steppingFiltersEditor = new TableModelEditor(COLUMNS, (CollectionItemEditor)itemEditor, JSDebuggerBundle.message("text.no.filters", new Object[0]));
        this.steppingFiltersPanel = this.steppingFiltersEditor.createComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.doNotStepIntoLibraryCodeCheckbox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/JSDebuggerBundle", JavaScriptSteppingConfigurableUi.class).getString("checkbox.text.do.not.step.into.library.scripts"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.steppingFiltersEnabledCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/JSDebuggerBundle", JavaScriptSteppingConfigurableUi.class).getString("checkbox.text.do.not.step.into.scripts"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComponent jComponent = this.steppingFiltersPanel;
        jPanel.add((Component)jComponent, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.alwaysDoSmartStepIntoCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JSDebuggerBundle", JavaScriptSteppingConfigurableUi.class).getString("javascript.debugger.settings.always.do.smart.step.into"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

