/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.util.Key;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"$\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"VM_SCRIPT_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getVM_SCRIPT_FILE_KEY", "()Lcom/intellij/openapi/util/Key;", "createdVmFiles", "", "", "getVmFile", "script", "Lorg/jetbrains/debugger/Script;", "toVirtualFilePath", "url", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
public final class VmScriptFileSystemKt {
    @NotNull
    private static final Key<VmScriptFile> VM_SCRIPT_FILE_KEY;
    private static final Map<String, VmScriptFile> createdVmFiles;

    @NotNull
    public static final Key<VmScriptFile> getVM_SCRIPT_FILE_KEY() {
        return VM_SCRIPT_FILE_KEY;
    }

    @NotNull
    public static final String toVirtualFilePath(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.trimParameters().toDecodedForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.trimParameters().toDecodedForm()");
        return string;
    }

    @NotNull
    public static final VmScriptFile getVmFile(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        VmScriptFile file2 = (VmScriptFile)((Object)script.getUserData(VM_SCRIPT_FILE_KEY));
        if (file2 != null) {
            return file2;
        }
        String filePath = VmScriptFileSystemKt.toVirtualFilePath(script.getUrl());
        VmScriptFile vmScriptFile = createdVmFiles.get(filePath);
        if (vmScriptFile != null) {
            vmScriptFile.setScript(script);
            return vmScriptFile;
        }
        file2 = new VmScriptFile(script);
        script.putUserDataIfAbsent(VM_SCRIPT_FILE_KEY, (Object)file2);
        createdVmFiles.put(filePath, file2);
        return file2;
    }

    static {
        Key key = Key.create((String)"js.debugger.vm.script.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<VmScriptFile>\u2026debugger.vm.script.file\")");
        VM_SCRIPT_FILE_KEY = key;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConcurrentWeakValueMap()");
        createdVmFiles = concurrentMap;
    }

    public static final /* synthetic */ Map access$getCreatedVmFiles$p() {
        return createdVmFiles;
    }
}

