/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.DirectoryInfoKt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Url;
import gnu.trove.THashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nH\u0014J\b\u0010 \u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "name", "", "url", "Lcom/intellij/util/Url;", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Lcom/intellij/util/Url;Ljavax/swing/Icon;)V", "childNameToInfo", "Lgnu/trove/THashMap;", "getChildNameToInfo", "()Lgnu/trove/THashMap;", "children", "", "getChildren$intellij_javascript_debugger", "()Ljava/util/List;", "isFile", "", "()Z", "singleChild", "getSingleChild", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "weight", "", "getWeight", "()I", "addChild", "", "script", "Lorg/jetbrains/debugger/Script;", "computeAndGetChildren", "getIcon", "hasChildren", "removeChild", "intellij.javascript.debugger"})
public class DirectoryInfo
extends FileInfo {
    @NotNull
    private final THashMap<String, FileInfo> childNameToInfo;
    private final boolean isFile;

    @NotNull
    public final THashMap<String, FileInfo> getChildNameToInfo() {
        return this.childNameToInfo;
    }

    @Override
    public int getWeight() {
        return Intrinsics.areEqual((Object)this.get_icon$intellij_javascript_debugger(), (Object)PlatformIcons.FOLDER_ICON) ? 20 : 15;
    }

    @NotNull
    protected THashMap<String, FileInfo> computeAndGetChildren() {
        return this.childNameToInfo;
    }

    @Override
    public boolean hasChildren() {
        return !this.childNameToInfo.isEmpty();
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    @Nullable
    public FileInfo getSingleChild() {
        return this.childNameToInfo.size() == 1 ? (FileInfo)this.childNameToInfo.values().iterator().next() : null;
    }

    @Override
    @NotNull
    public List<FileInfo> getChildren$intellij_javascript_debugger() {
        THashMap<String, FileInfo> list = this.computeAndGetChildren();
        if (list.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList(list.size());
        list.forEachValue((TObjectProcedure)new TObjectProcedure<FileInfo>(result2){
            final /* synthetic */ ArrayList $result;

            public final boolean execute(FileInfo it) {
                this.$result.add(it);
                return true;
            }
            {
                this.$result = arrayList;
            }
        });
        return result2;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.get_icon$intellij_javascript_debugger();
        Intrinsics.checkNotNull((Object)icon);
        return icon;
    }

    public void addChild(@NotNull Script script, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            String string = url.getPath();
            String string2 = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
            this.childNameToInfo.put((Object)string, (Object)new FileInfo(string2, url, CollectionsKt.mutableListOf((Object[])new Script[]{script})));
        } else {
            DirectoryInfoKt.addEntry(script, url, this, null);
        }
    }

    public void removeChild(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            this.childNameToInfo.remove((Object)url.getPath());
            return;
        }
        DirectoryInfoKt.access$removeEntry(url, this);
    }

    public DirectoryInfo(@NotNull String name, @NotNull Url url, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(name, url, null, 4, null);
        this.childNameToInfo = new THashMap();
        this.set_icon$intellij_javascript_debugger(icon);
    }

    public /* synthetic */ DirectoryInfo(String string, Url url, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Icon icon2 = PlatformIcons.FOLDER_ICON;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PlatformIcons.FOLDER_ICON");
            icon = icon2;
        }
        this(string, url, icon);
    }
}

