/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.javascript.debugger.locationResolving.FileUrlMappingsStorage;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00130\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "", "()V", "storage", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMappingsStorage;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "sourceContent", "", "findByName", "", "script", "Lorg/jetbrains/debugger/Script;", "finder", "Lkotlin/Function0;", "Lcom/intellij/javascript/debugger/locationResolving/SearchResult;", "findUrls", "", "file", "intellij.javascript.debugger"})
public final class JSFileUrlMappings {
    private final FileUrlMappingsStorage storage = new FileUrlMappingsStorage();

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @Nullable String sourceContent, boolean findByName2, @Nullable Script script, @NotNull Function0<SearchResult> finder) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(finder, (String)"finder");
        this.storage.removeOutdatedResults(url, sourceContent);
        if (script != null) {
            this.storage.scriptFound(url, script);
        }
        SearchAccuracy accuracy = sourceContent != null ? SearchAccuracy.BY_CONTENT : (findByName2 ? SearchAccuracy.BY_NAME : SearchAccuracy.BY_URL);
        VirtualFile cachedFile = this.storage.findSuitableMapping(url, accuracy);
        if (cachedFile != null) {
            return cachedFile;
        }
        SearchResult searchResult = (SearchResult)finder.invoke();
        this.storage.addMapping(new FileUrlMapping(url, searchResult.getFile(), searchResult.getAccuracy(), sourceContent));
        return searchResult.getFile();
    }

    @NotNull
    public final List<Url> findUrls(@NotNull VirtualFile file2, @NotNull Function0<? extends List<? extends Url>> finder) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(finder, (String)"finder");
        Collection collection = this.storage.findUrls(file2);
        boolean bl = false;
        return (List)(collection.isEmpty() ? finder.invoke() : collection);
    }
}

