/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.javascript.debugger.execution.VisibleNodeFileFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u001c\u0010\u0018\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001aR\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/execution/JSLocalFilesMappingPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "layout", "Ljava/awt/LayoutManager;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/LayoutManager;)V", "mappingTree", "Lcom/intellij/util/ui/tree/AbstractFileTreeTable;", "", "mappingTreePanel", "getMappingTreePanel", "()Ljavax/swing/JPanel;", "applyEditorTo", "", "mappings", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createMapping", "localPath", "remote", "initUI", "resetEditorFrom", "allowConfigureMappings", "", "intellij.javascript.debugger"})
public class JSLocalFilesMappingPanel
extends JPanel {
    @NotNull
    private final JPanel mappingTreePanel;
    private final AbstractFileTreeTable<String> mappingTree;

    @NotNull
    protected final JPanel getMappingTreePanel() {
        return this.mappingTreePanel;
    }

    public void initUI() {
        if (this.mappingTree != null) {
            this.mappingTreePanel.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.mappingTree)));
        } else {
            this.setVisible(false);
        }
    }

    public final void resetEditorFrom(@NotNull List<RemoteUrlMappingBean> mappings, boolean allowConfigureMappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        if (!allowConfigureMappings) {
            this.setVisible(false);
        } else if (this.mappingTree != null) {
            THashMap map2 = new THashMap();
            VirtualFile toSelect = null;
            for (RemoteUrlMappingBean bean : mappings) {
                VirtualFile file2 = LocalFileFinder.findFile((String)bean.localFilePath);
                if (file2 == null) continue;
                ((Map)map2).put(file2, bean.getRemoteUrl());
                if (toSelect != null && !VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)toSelect, (boolean)false)) continue;
                toSelect = file2;
            }
            this.mappingTree.reset((Map)map2);
            this.mappingTree.select(toSelect);
        }
    }

    public final void applyEditorTo(@NotNull List<RemoteUrlMappingBean> mappings, @NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (this.mappingTree != null) {
            mappings.clear();
            for (Map.Entry mapping : this.mappingTree.getValues().entrySet()) {
                String remote;
                String string = remote = (String)mapping.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remote");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) continue;
                Object k = mapping.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"mapping.key");
                String string2 = ((VirtualFile)k).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mapping.key.path");
                mappings.add(this.createMapping(string2, remote));
            }
            Iterator iterator = XDebuggerManager.getInstance((Project)this.mappingTree.getProject()).getDebugProcesses(JavaScriptDebugProcess.class).iterator();
            while (iterator.hasNext()) {
                JavaScriptDebugProcess process;
                JavaScriptDebugProcess javaScriptDebugProcess = process = (JavaScriptDebugProcess)((Object)iterator.next());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)javaScriptDebugProcess), (String)"process");
                XDebugSession xDebugSession = javaScriptDebugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"process.session");
                if (xDebugSession.getRunProfile() != configuration) continue;
                process.updateRemoteUrlMappings(mappings);
            }
        }
    }

    @NotNull
    protected RemoteUrlMappingBean createMapping(@NotNull String localPath, @NotNull String remote) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return new RemoteUrlMappingBean(localPath, remote);
    }

    public JSLocalFilesMappingPanel(@NotNull Project project, @NotNull LayoutManager layout) {
        AbstractFileTreeTable abstractFileTreeTable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(layout);
        this.mappingTreePanel = new JPanel(new BorderLayout());
        if (project.isDefault()) {
            abstractFileTreeTable = null;
        } else {
            String string = JSDebuggerBundle.message("column.title.remote.url", new Object[0]);
            DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)directoryIndex, (String)"DirectoryIndex.getInstance(project)");
            abstractFileTreeTable = new AbstractFileTreeTable(project, String.class, string, (VirtualFileFilter)new VisibleNodeFileFilter(directoryIndex), true, false);
        }
        this.mappingTree = abstractFileTreeTable;
    }
}

