/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor$convertCssDataToSegments$segments$2;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor$sam$java_util_function_Function$0;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipStyleSheet;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.org.jetbrains.wip.WipCssManager;
import org.jetbrains.wip.protocol.css.RuleUsageValue;
import org.jetbrains.wip.protocol.profiler.CoverageRangeValue;
import org.jetbrains.wip.protocol.profiler.ScriptCoverageValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001GB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020!0\u0007J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0007H\u0002J&\u0010$\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000fH\u0002JV\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00102\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014012\u0006\u00102\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J5\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0010062\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00109JL\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010=\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002J\u001e\u0010>\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0010062\u0006\u0010?\u001a\u00020\u0010H\u0002J!\u0010@\u001a\u0004\u0018\u00010\f2\b\u0010A\u001a\u0004\u0018\u00010\f2\b\u0010B\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010CJ\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020&H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cssExtensions", "", "", "append", "", "offset", "", "count", "result", "", "Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "computeLines", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport$LineHits;", "document", "Lcom/intellij/openapi/editor/Document;", "segments", "scriptStartLine", "scriptEndLine", "convertCoverageFormat", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport;", "jsDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "coverageResult", "Lorg/jetbrains/wip/protocol/profiler/ScriptCoverageValue;", "convertCssCoverageFormat", "Lorg/jetbrains/wip/protocol/css/RuleUsageValue;", "convertCssDataToSegments", "rules", "convertSegmentsOffsets", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptStartOffset", "convertToDisjointSegments", "ranges", "Lorg/jetbrains/wip/protocol/profiler/CoverageRangeValue;", "findNextValidMapping", "Lkotlin/Pair;", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mapping", "segment", "nullableSourcesCache", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "insertSegment", "sourceSegments", "Ljava/util/TreeSet;", "startOffsetInclusive", "endOffsetExclusive", "(Ljava/util/TreeSet;IILjava/lang/Integer;)V", "mapCoverage", "", "generatedSegments", "generatedDocument", "merge", "endSegment", "nullableMax", "a", "b", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;", "supportedExtension", "", "file", "CoverageSegment", "intellij.javascript.debugger"})
public final class WipCoverageReportProcessor {
    private static final Logger LOG;
    private static final List<String> cssExtensions;
    public static final WipCoverageReportProcessor INSTANCE;

    @NotNull
    public final Promise<LcovCoverageReport> convertCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends ScriptCoverageValue> coverageResult) {
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        Vm vm = jsDebugProcess.getVm();
        if (vm == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
        }
        WipVm vm2 = (WipVm)vm;
        LcovCoverageReport lcov = new LcovCoverageReport();
        boolean bl = false;
        List promises = new ArrayList();
        for (ScriptCoverageValue scriptCoverageValue : coverageResult) {
            WipScript wipScript = (WipScript)vm2.getScriptManager().findScriptById(scriptCoverageValue.scriptId());
            if (wipScript == null) continue;
            Promise<VirtualFile> promise2 = VmScriptFileSystemKt.getVmFile((Script)wipScript).ensureDownloaded();
            promise2.onSuccess((Consumer)new Consumer<VirtualFile>(scriptCoverageValue, wipScript, jsDebugProcess, lcov){
                final /* synthetic */ ScriptCoverageValue $script;
                final /* synthetic */ WipScript $wipScript;
                final /* synthetic */ JavaScriptDebugProcess $jsDebugProcess;
                final /* synthetic */ LcovCoverageReport $lcov;

                public final void accept(VirtualFile scriptFile) {
                    ReadAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this, scriptFile){
                        final /* synthetic */ convertCoverageFormat.1 this$0;
                        final /* synthetic */ VirtualFile $scriptFile;

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            try {
                                Stream<R> stream = this.this$0.$script.functions().stream().flatMap(convertCoverageFormat.ranges.1.INSTANCE);
                                Intrinsics.checkNotNullExpressionValue(stream, (String)"script.functions().strea\u2026 { it.ranges().stream() }");
                                List ranges2 = CollectionsKt.toMutableList((Collection)StreamsKt.toList(stream));
                                List segments2 = WipCoverageReportProcessor.access$convertToDisjointSegments(WipCoverageReportProcessor.INSTANCE, ranges2);
                                Document document = FileDocumentManager.getInstance().getDocument(this.$scriptFile);
                                if (document == null) {
                                    return;
                                }
                                int scriptStartLine = this.this$0.$wipScript.getLine();
                                int scriptEndLine = this.this$0.$wipScript.getEndLine();
                                int scriptStartOffset = document.getLineStartOffset(scriptStartLine) + this.this$0.$wipScript.getColumn();
                                VirtualFile virtualFile = this.$scriptFile;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"scriptFile");
                                WipCoverageReportProcessor.access$convertSegmentsOffsets(WipCoverageReportProcessor.INSTANCE, segments2, virtualFile, scriptStartOffset);
                                if (this.this$0.$wipScript.getSourceMap() != null) {
                                    Map coverageMap;
                                    SourceMap sourceMap = this.this$0.$wipScript.getSourceMap();
                                    Intrinsics.checkNotNull((Object)sourceMap);
                                    Map map2 = coverageMap = WipCoverageReportProcessor.access$mapCoverage(WipCoverageReportProcessor.INSTANCE, segments2, document, sourceMap, this.this$0.$jsDebugProcess);
                                    boolean bl = false;
                                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        VirtualFile sourceFile;
                                        void sourceDocument;
                                        Map.Entry<K, V> entry;
                                        Map.Entry<K, V> entry2 = entry = iterator.next();
                                        boolean bl2 = false;
                                        map2 = (Document)entry2.getKey();
                                        entry2 = entry;
                                        bl2 = false;
                                        List sourceSegments = (List)entry2.getValue();
                                        Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile((Document)sourceDocument));
                                        Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"FileDocumentManager.getI\u2026getFile(sourceDocument)!!");
                                        try {
                                            if (!WipCoverageReportProcessor.access$supportedExtension(WipCoverageReportProcessor.INSTANCE, sourceFile)) continue;
                                            List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, (Document)sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                                            this.this$0.$lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                                        }
                                        catch (Exception e) {
                                            WipCoverageReportProcessor.access$getLOG$p(WipCoverageReportProcessor.INSTANCE).debug("Failed to process coverage for " + this.this$0.$wipScript.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                                        }
                                    }
                                }
                                if (!(this.$scriptFile instanceof LightVirtualFile)) {
                                    VirtualFile virtualFile2 = this.$scriptFile;
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"scriptFile");
                                    if (WipCoverageReportProcessor.access$supportedExtension(WipCoverageReportProcessor.INSTANCE, virtualFile2)) {
                                        List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, document, segments2, scriptStartLine, scriptEndLine);
                                        LcovCoverageReport lcovCoverageReport = this.this$0.$lcov;
                                        VirtualFile virtualFile3 = this.$scriptFile;
                                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"scriptFile");
                                        lcovCoverageReport.mergeFileReport(null, virtualFile3.getPath(), lines);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Logger logger = WipCoverageReportProcessor.access$getLOG$p(WipCoverageReportProcessor.INSTANCE);
                                StringBuilder stringBuilder = new StringBuilder().append("Failed to process coverage for ").append(this.this$0.$wipScript.getUrl()).append(". Matched file: ");
                                VirtualFile virtualFile = this.$scriptFile;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"scriptFile");
                                logger.debug(stringBuilder.append(virtualFile.getPath()).append(".\n").append(e.getMessage()).toString());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$scriptFile = virtualFile;
                        }
                    }));
                }
                {
                    this.$script = scriptCoverageValue;
                    this.$wipScript = wipScript;
                    this.$jsDebugProcess = javaScriptDebugProcess;
                    this.$lcov = lcovCoverageReport;
                }
            });
            promises.add(promise2);
        }
        Promise promise2 = Promises.all((Collection)promises, null, (boolean)true).then(new com.intellij.util.Function(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;

            public final LcovCoverageReport fun(@Nullable Void it) {
                return this.$lcov;
            }
            {
                this.$lcov = lcovCoverageReport;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"promises.all(null, true).then { lcov }");
        return promise2;
    }

    private final boolean supportedExtension(VirtualFile file2) {
        boolean bl;
        block3: {
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String path = string;
            Iterable $this$any$iv = cssExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<LcovCoverageReport> convertCssCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends RuleUsageValue> coverageResult) {
        Map.Entry $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        LcovCoverageReport lcov = new LcovCoverageReport();
        boolean bl = false;
        List promises = new ArrayList();
        Object $this$groupBy$iv = coverageResult;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            RuleUsageValue p1 = (RuleUsageValue)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = p1.styleSheetId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void styleSheetId;
            Map.Entry entry;
            $this$groupByTo$iv$iv = entry = iterator2.next();
            boolean destination$iv$iv2 = false;
            $this$groupBy$iv = (String)$this$groupByTo$iv$iv.getKey();
            $this$groupByTo$iv$iv = entry;
            destination$iv$iv2 = false;
            List rules = (List)$this$groupByTo$iv$iv.getValue();
            WipCssManager wipCssManager = jsDebugProcess.getCssManager();
            Intrinsics.checkNotNull((Object)wipCssManager);
            WipStyleSheet styleSheet = wipCssManager.getIdToStyleSheet().get(styleSheetId);
            if (styleSheet == null) continue;
            VirtualFile file2 = JavaScriptDebugProcess.findFile$default(jsDebugProcess, styleSheet.getUrl(), false, null, 4, null);
            Promise promise2 = file2 == null ? Promises.rejectedPromise() : Promises.resolvedPromise((Object)file2);
            promise2.onSuccess((Consumer)new Consumer<VirtualFile>(rules, styleSheet, jsDebugProcess, lcov){
                final /* synthetic */ List $rules;
                final /* synthetic */ WipStyleSheet $styleSheet;
                final /* synthetic */ JavaScriptDebugProcess $jsDebugProcess;
                final /* synthetic */ LcovCoverageReport $lcov;

                public final void accept(VirtualFile scriptFile) {
                    ReadAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this, scriptFile){
                        final /* synthetic */ convertCssCoverageFormat.2 this$0;
                        final /* synthetic */ VirtualFile $scriptFile;

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            try {
                                List segments2 = WipCoverageReportProcessor.access$convertCssDataToSegments(WipCoverageReportProcessor.INSTANCE, this.this$0.$rules);
                                Document document = FileDocumentManager.getInstance().getDocument(this.$scriptFile);
                                if (document == null) {
                                    return;
                                }
                                int scriptStartLine = 0;
                                int scriptEndLine = document.getLineCount();
                                VirtualFile virtualFile = this.$scriptFile;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"scriptFile");
                                WipCoverageReportProcessor.access$convertSegmentsOffsets(WipCoverageReportProcessor.INSTANCE, segments2, virtualFile, 0);
                                if (this.this$0.$styleSheet.getSourceMap() != null) {
                                    Map coverageMap;
                                    SourceMap sourceMap = this.this$0.$styleSheet.getSourceMap();
                                    Intrinsics.checkNotNull((Object)sourceMap);
                                    Map map2 = coverageMap = WipCoverageReportProcessor.access$mapCoverage(WipCoverageReportProcessor.INSTANCE, segments2, document, sourceMap, this.this$0.$jsDebugProcess);
                                    boolean bl = false;
                                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        VirtualFile sourceFile;
                                        void sourceDocument;
                                        Map.Entry<K, V> entry;
                                        Map.Entry<K, V> entry2 = entry = iterator.next();
                                        boolean bl2 = false;
                                        map2 = (Document)entry2.getKey();
                                        entry2 = entry;
                                        bl2 = false;
                                        List sourceSegments = (List)entry2.getValue();
                                        Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile((Document)sourceDocument));
                                        Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"FileDocumentManager.getI\u2026getFile(sourceDocument)!!");
                                        try {
                                            List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, (Document)sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                                            this.this$0.$lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                                        }
                                        catch (Exception e) {
                                            WipCoverageReportProcessor.access$getLOG$p(WipCoverageReportProcessor.INSTANCE).debug("Failed to process coverage for " + this.this$0.$styleSheet.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                                        }
                                    }
                                }
                                if (!(this.$scriptFile instanceof LightVirtualFile)) {
                                    List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, document, segments2, scriptStartLine, scriptEndLine);
                                    LcovCoverageReport lcovCoverageReport = this.this$0.$lcov;
                                    VirtualFile virtualFile2 = this.$scriptFile;
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"scriptFile");
                                    lcovCoverageReport.mergeFileReport(null, virtualFile2.getPath(), lines);
                                }
                            }
                            catch (Exception e) {
                                Logger logger = WipCoverageReportProcessor.access$getLOG$p(WipCoverageReportProcessor.INSTANCE);
                                StringBuilder stringBuilder = new StringBuilder().append("Failed to process coverage for ").append(this.this$0.$styleSheet).append(". Matched file: ");
                                VirtualFile virtualFile = this.$scriptFile;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"scriptFile");
                                logger.debug(stringBuilder.append(virtualFile.getPath()).append(".\n").append(e.getMessage()).toString());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$scriptFile = virtualFile;
                        }
                    }));
                }
                {
                    this.$rules = list;
                    this.$styleSheet = wipStyleSheet;
                    this.$jsDebugProcess = javaScriptDebugProcess;
                    this.$lcov = lcovCoverageReport;
                }
            });
            promises.add(promise2);
        }
        Promise promise3 = Promises.all((Collection)promises, null, (boolean)true).then(new com.intellij.util.Function(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;

            public final LcovCoverageReport fun(@Nullable Void it) {
                return this.$lcov;
            }
            {
                this.$lcov = lcovCoverageReport;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"promises.all(null, true).then { lcov }");
        return promise3;
    }

    private final List<CoverageSegment> convertCssDataToSegments(List<? extends RuleUsageValue> rules) {
        Stream stream = rules.stream().flatMap(convertCssDataToSegments.segments.1.INSTANCE);
        Object object = (Function1)WipCoverageReportProcessor$convertCssDataToSegments$segments$2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new WipCoverageReportProcessor$sam$java_util_function_Function$0(function1);
        }
        Stream stream2 = stream.sorted(Comparator.comparing((Function)object)).filter(convertCssDataToSegments.segments.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"rules.stream()\n      .fl\u2026endOffsetExclusive != 0 }");
        List segments2 = CollectionsKt.toMutableList((Collection)StreamsKt.toList(stream2));
        return segments2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Document, List<CoverageSegment>> mapCoverage(List<CoverageSegment> generatedSegments, Document generatedDocument, SourceMap sourceMap, JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess) {
        Object object;
        Object object2;
        StringBuilder stringBuilder;
        Object it;
        int currentOffset = 0;
        boolean bl = false;
        Map coverageMap = new LinkedHashMap();
        boolean bl2 = false;
        Map nullableSourcesCache = new LinkedHashMap();
        Url[] $this$forEachIndexed$iv = sourceMap.getSources();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Url item$iv : $this$forEachIndexed$iv) {
            Document document;
            void url;
            int n = index$iv++;
            Url url2 = item$iv;
            int i = n;
            boolean bl3 = false;
            Map map2 = nullableSourcesCache;
            Integer n2 = i;
            if (JavaScriptDebugProcess.findFile$default(jsDebugProcess, (Url)url, false, null, 4, null) != null) {
                void it2;
                VirtualFile virtualFile;
                boolean bl4 = false;
                boolean bl5 = false;
                VirtualFile virtualFile2 = virtualFile;
                Integer n3 = n2;
                Map map3 = map2;
                boolean bl6 = false;
                Document document2 = FileDocumentManager.getInstance().getDocument((VirtualFile)it2);
                map2 = map3;
                n2 = n3;
                document = document2;
            } else {
                document = null;
            }
            map2.put(n2, document);
        }
        for (CoverageSegment segment : generatedSegments) {
            block14: {
                Document sourceDocument;
                boolean item$iv;
                int n;
                MappingEntry mapping = null;
                try {
                    MappingEntry nextMapping;
                    do {
                        Object object3;
                        MappingEntry currentMapping;
                        MappingEntry mappingEntry;
                        if ((nextMapping = this.findNextValidMapping(mapping, currentOffset, segment, nullableSourcesCache, sourceMap, generatedDocument)) == null) continue;
                        n = 0;
                        item$iv = false;
                        it = mappingEntry;
                        boolean bl7 = false;
                        sourceDocument = (Document)it.getFirst();
                        mapping = (MappingEntry)it.getSecond();
                        Intrinsics.checkNotNull((Object)mapping);
                        currentOffset = generatedDocument.getLineStartOffset(currentMapping.getGeneratedLine()) + currentMapping.getGeneratedColumn();
                        Mappings mappings = sourceMap.findSourceMappings(currentMapping.getSource());
                        if (mappings == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                        }
                        MappingList mappings2 = (MappingList)mappings;
                        Map $this$getOrPut$iv = coverageMap;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(sourceDocument);
                        if (value$iv == null) {
                            boolean bl8 = false;
                            boolean bl9 = false;
                            TreeSet answer$iv = new TreeSet(new Comparator<T>(){

                                public final int compare(T a, T b) {
                                    boolean bl = false;
                                    T receiver = a;
                                    boolean bl2 = false;
                                    Comparable comparable = Integer.valueOf(((CoverageSegment)receiver).getEndOffsetExclusive());
                                    receiver = b;
                                    Comparable comparable2 = comparable;
                                    bl2 = false;
                                    Integer n = ((CoverageSegment)receiver).getEndOffsetExclusive();
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                                }
                            });
                            $this$getOrPut$iv.put(sourceDocument, answer$iv);
                            object3 = answer$iv;
                        } else {
                            object3 = value$iv;
                        }
                        TreeSet sourceSegments = (TreeSet)object3;
                        int lineStartOffset = sourceDocument.getLineStartOffset(mappings2.getLine(currentMapping));
                        int sourceEndOffset = mappings2.getEndOffset(currentMapping, lineStartOffset, sourceDocument);
                        if (sourceEndOffset == sourceDocument.getLineEndOffset(mappings2.getLine(currentMapping))) {
                            ++sourceEndOffset;
                        }
                        INSTANCE.insertSegment(sourceSegments, lineStartOffset + mappings2.getColumn(currentMapping), sourceEndOffset, segment.getCount());
                    } while (nextMapping != null && currentOffset < segment.getEndOffsetExclusive());
                }
                catch (IndexOutOfBoundsException e) {
                    MappingEntry mappingEntry;
                    Url url;
                    Logger logger = LOG;
                    StringBuilder stringBuilder2 = new StringBuilder().append(e.getMessage()).append("\nurl: ");
                    if (mapping != null) {
                        MappingEntry mappingEntry2;
                        n = 0;
                        item$iv = false;
                        it = mappingEntry2;
                        stringBuilder = stringBuilder2;
                        object2 = logger;
                        boolean bl10 = false;
                        Url[] urlArray = sourceMap.getSources();
                        MappingEntry mappingEntry3 = mapping;
                        Intrinsics.checkNotNull((Object)mappingEntry3);
                        object = urlArray[mappingEntry3.getSource()];
                        logger = object2;
                        stringBuilder2 = stringBuilder;
                        url = object;
                    } else {
                        url = null;
                    }
                    logger.debug(stringBuilder2.append(url).append(", segment: ").append(segment).toString());
                    if (mapping == null) break block14;
                    n = 0;
                    item$iv = false;
                    it = mappingEntry;
                    boolean bl11 = false;
                    if ((Document)nullableSourcesCache.get(it.getSource()) == null) break block14;
                    boolean bl12 = false;
                    boolean mappings2 = false;
                    Document it3 = sourceDocument;
                    boolean bl13 = false;
                    TreeSet cfr_ignored_0 = (TreeSet)coverageMap.remove(it3);
                }
            }
            currentOffset = segment.getEndOffsetExclusive();
        }
        $i$f$forEachIndexed = false;
        Map result2 = new LinkedHashMap();
        Map $this$mapValuesTo$iv = coverageMap;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $dstr$_u24__u24$segments;
            void it$iv;
            it = (Map.Entry)element$iv$iv;
            Map map4 = result2;
            boolean bl14 = false;
            Object k = it$iv.getKey();
            Map.Entry mappings2 = (Map.Entry)element$iv$iv;
            stringBuilder = k;
            object2 = map4;
            boolean bl15 = false;
            void var21_49 = $dstr$_u24__u24$segments;
            boolean bl16 = false;
            TreeSet segments2 = (TreeSet)var21_49.getValue();
            object = new ArrayList(segments2);
            object2.put(stringBuilder, object);
        }
        return result2;
    }

    private final Pair<Document, MappingEntry> findNextValidMapping(MappingEntry mapping, int offset, CoverageSegment segment, Map<Integer, Document> nullableSourcesCache, SourceMap sourceMap, Document document) {
        Pair pair;
        int currentOffset = offset;
        MappingEntry nextMapping = mapping;
        Document sourceDocument = null;
        while (sourceDocument == null && currentOffset < segment.getEndOffsetExclusive()) {
            if (nextMapping == null) {
                int generatedLine = document.getLineNumber(currentOffset);
                int generatedColumn = currentOffset - document.getLineStartOffset(generatedLine);
                nextMapping = sourceMap.getGeneratedMappings().get(generatedLine, generatedColumn);
                if (nextMapping == null) {
                    if (currentOffset + 1 >= segment.getEndOffsetExclusive()) break;
                    ++currentOffset;
                }
            } else {
                if (nextMapping.getNextGenerated() == null) {
                    break;
                }
                currentOffset = document.getLineStartOffset(nextMapping.getGeneratedLine()) + nextMapping.getGeneratedColumn();
            }
            if (nextMapping == null || nextMapping.getSourceLine() < 0 || currentOffset >= segment.getEndOffsetExclusive()) continue;
            sourceDocument = nullableSourcesCache.get(nextMapping.getSource());
        }
        if (sourceDocument == null) {
            pair = null;
        } else {
            MappingEntry mappingEntry = nextMapping;
            Intrinsics.checkNotNull((Object)mappingEntry);
            pair = new Pair((Object)sourceDocument, (Object)mappingEntry);
        }
        return pair;
    }

    private final void convertSegmentsOffsets(List<CoverageSegment> segments2, VirtualFile scriptFile, int scriptStartOffset) {
        FileOffsetsManager fileOffsetsManager = FileOffsetsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileOffsetsManager, (String)"FileOffsetsManager.getInstance()");
        FileOffsetsManager offsetManager = fileOffsetsManager;
        for (CoverageSegment segment : segments2) {
            segment.setEndOffsetExclusive(scriptFile instanceof LightVirtualFile ? scriptStartOffset + segment.getEndOffsetExclusive() : offsetManager.getConvertedOffset(scriptFile, scriptStartOffset + segment.getEndOffsetExclusive()));
        }
    }

    private final void insertSegment(TreeSet<CoverageSegment> sourceSegments, int startOffsetInclusive, int endOffsetExclusive, Integer count) {
        CoverageSegment segment;
        CoverageSegment coverageSegment = segment = sourceSegments.higher(new CoverageSegment(startOffsetInclusive, null));
        CoverageSegment startSegment = new CoverageSegment(startOffsetInclusive, coverageSegment != null ? coverageSegment.getCount() : null);
        CoverageSegment endSegment = new CoverageSegment(endOffsetExclusive, count);
        if (segment == null) {
            if (startOffsetInclusive != 0 && !sourceSegments.contains(startSegment)) {
                sourceSegments.add(startSegment);
            }
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
            return;
        }
        if (startOffsetInclusive != 0 && Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count)) && !sourceSegments.contains(startSegment)) {
            sourceSegments.add(startSegment);
        }
        if (segment.getEndOffsetExclusive() == endOffsetExclusive) {
            segment.setCount(this.nullableMax(segment.getCount(), count));
            this.merge(sourceSegments, segment);
        } else if (Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count))) {
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
        }
    }

    private final void merge(TreeSet<CoverageSegment> sourceSegments, CoverageSegment endSegment) {
        CoverageSegment prev = sourceSegments.lower(endSegment);
        CoverageSegment current = sourceSegments.floor(endSegment);
        CoverageSegment coverageSegment = prev;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment != null ? coverageSegment.getCount() : null)) && prev != null) {
            sourceSegments.remove(prev);
        }
        CoverageSegment next = sourceSegments.higher(endSegment);
        CoverageSegment coverageSegment2 = next;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment2 != null ? coverageSegment2.getCount() : null))) {
            sourceSegments.remove(current);
        }
    }

    private final List<CoverageSegment> convertToDisjointSegments(List<CoverageRangeValue> ranges2) {
        CollectionsKt.sortWith(ranges2, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{convertToDisjointSegments.1.INSTANCE, convertToDisjointSegments.2.INSTANCE}));
        boolean bl = false;
        List result2 = new ArrayList();
        LinkedList<CoverageRangeValue> stack = new LinkedList<CoverageRangeValue>();
        for (CoverageRangeValue entry : ranges2) {
            CoverageRangeValue top = (CoverageRangeValue)stack.peek();
            while (top != null && top.getEndOffset() <= entry.getStartOffset()) {
                this.append(top.getEndOffset() + 1, top.getCount(), result2);
                stack.pop();
                top = (CoverageRangeValue)stack.peek();
            }
            if (top != null) {
                this.append(entry.getStartOffset(), top.getCount(), result2);
            }
            stack.push(entry);
        }
        while (!stack.isEmpty()) {
            CoverageRangeValue top = (CoverageRangeValue)stack.pop();
            this.append(top.getEndOffset() + 1, top.getCount(), result2);
        }
        return result2;
    }

    private final void append(int offset, int count, List<CoverageSegment> result2) {
        Collection collection = result2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            CoverageSegment last = (CoverageSegment)CollectionsKt.last(result2);
            if (last.getEndOffsetExclusive() == offset) {
                return;
            }
            Integer n = last.getCount();
            if (n != null && n == count) {
                last.setEndOffsetExclusive(offset);
                return;
            }
        }
        result2.add(new CoverageSegment(offset, count));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LcovCoverageReport.LineHits> computeLines(Document document, List<CoverageSegment> segments2, int scriptStartLine, int scriptEndLine) {
        List lines = new ArrayList(scriptEndLine - scriptStartLine);
        int currentLine = scriptStartLine;
        ListIterator<CoverageSegment> listIterator = segments2.listIterator();
        CoverageSegment segment = null;
        while (listIterator.hasNext()) {
            segment = listIterator.next();
            int inclusiveEnd = segment.getEndOffsetExclusive() - 1;
            int segmentEndLine = document.getLineNumber(inclusiveEnd);
            if (segment.getCount() != null) {
                int n = currentLine;
                int n2 = segmentEndLine;
                while (n < n2) {
                    void line;
                    void v0 = line + true;
                    Integer n3 = segment.getCount();
                    Intrinsics.checkNotNull((Object)n3);
                    lines.add(new LcovCoverageReport.LineHits((int)v0, n3.intValue()));
                    ++line;
                }
            }
            Integer endLineHits = segment.getCount();
            while (inclusiveEnd < document.getLineEndOffset(segmentEndLine) && listIterator.hasNext()) {
                segment = listIterator.next();
                inclusiveEnd = segment.getEndOffsetExclusive() - 1;
                endLineHits = this.nullableMax(endLineHits, segment.getCount());
            }
            if (inclusiveEnd > document.getLineEndOffset(segmentEndLine)) {
                listIterator.previous();
            }
            if (endLineHits != null) {
                lines.add(new LcovCoverageReport.LineHits(segmentEndLine + 1, endLineHits.intValue()));
            }
            currentLine = segmentEndLine + 1;
        }
        return lines;
    }

    @Nullable
    public final Integer nullableMax(@Nullable Integer a, @Nullable Integer b) {
        return a == null ? b : (b == null ? a : Integer.valueOf(Math.max(a, b)));
    }

    private WipCoverageReportProcessor() {
    }

    static {
        WipCoverageReportProcessor wipCoverageReportProcessor;
        INSTANCE = wipCoverageReportProcessor = new WipCoverageReportProcessor();
        Logger logger = Logger.getInstance(WipCoverageReportProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(WipCo\u2026ortProcessor::class.java)");
        LOG = logger;
        cssExtensions = CollectionsKt.listOf((Object[])new String[]{"css", "sass", "less", "styl"});
    }

    public static final /* synthetic */ List access$convertToDisjointSegments(WipCoverageReportProcessor $this, List ranges2) {
        return $this.convertToDisjointSegments(ranges2);
    }

    public static final /* synthetic */ void access$convertSegmentsOffsets(WipCoverageReportProcessor $this, List segments2, VirtualFile scriptFile, int scriptStartOffset) {
        $this.convertSegmentsOffsets(segments2, scriptFile, scriptStartOffset);
    }

    public static final /* synthetic */ Map access$mapCoverage(WipCoverageReportProcessor $this, List generatedSegments, Document generatedDocument, SourceMap sourceMap, JavaScriptDebugProcess jsDebugProcess) {
        return $this.mapCoverage(generatedSegments, generatedDocument, sourceMap, jsDebugProcess);
    }

    public static final /* synthetic */ boolean access$supportedExtension(WipCoverageReportProcessor $this, VirtualFile file2) {
        return $this.supportedExtension(file2);
    }

    public static final /* synthetic */ List access$computeLines(WipCoverageReportProcessor $this, Document document, List segments2, int scriptStartLine, int scriptEndLine) {
        return $this.computeLines(document, segments2, scriptStartLine, scriptEndLine);
    }

    public static final /* synthetic */ Logger access$getLOG$p(WipCoverageReportProcessor $this) {
        WipCoverageReportProcessor wipCoverageReportProcessor = $this;
        return LOG;
    }

    public static final /* synthetic */ List access$convertCssDataToSegments(WipCoverageReportProcessor $this, List rules) {
        return $this.convertCssDataToSegments(rules);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "", "endOffsetExclusive", "", "count", "(ILjava/lang/Integer;)V", "getCount", "()Ljava/lang/Integer;", "setCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getEndOffsetExclusive", "()I", "setEndOffsetExclusive", "(I)V", "component1", "component2", "copy", "(ILjava/lang/Integer;)Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "equals", "", "other", "hashCode", "toString", "", "intellij.javascript.debugger"})
    public static final class CoverageSegment {
        private int endOffsetExclusive;
        @Nullable
        private Integer count;

        public final int getEndOffsetExclusive() {
            return this.endOffsetExclusive;
        }

        public final void setEndOffsetExclusive(int n) {
            this.endOffsetExclusive = n;
        }

        @Nullable
        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(@Nullable Integer n) {
            this.count = n;
        }

        public CoverageSegment(int endOffsetExclusive, @Nullable Integer count) {
            this.endOffsetExclusive = endOffsetExclusive;
            this.count = count;
        }

        public final int component1() {
            return this.endOffsetExclusive;
        }

        @Nullable
        public final Integer component2() {
            return this.count;
        }

        @NotNull
        public final CoverageSegment copy(int endOffsetExclusive, @Nullable Integer count) {
            return new CoverageSegment(endOffsetExclusive, count);
        }

        public static /* synthetic */ CoverageSegment copy$default(CoverageSegment coverageSegment, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = coverageSegment.endOffsetExclusive;
            }
            if ((n3 & 2) != 0) {
                n2 = coverageSegment.count;
            }
            return coverageSegment.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CoverageSegment(endOffsetExclusive=" + this.endOffsetExclusive + ", count=" + this.count + ")";
        }

        public int hashCode() {
            Integer n = this.count;
            return Integer.hashCode(this.endOffsetExclusive) * 31 + (n != null ? ((Object)n).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CoverageSegment)) break block3;
                    CoverageSegment coverageSegment = (CoverageSegment)object;
                    if (this.endOffsetExclusive != coverageSegment.endOffsetExclusive || !Intrinsics.areEqual((Object)this.count, (Object)coverageSegment.count)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

