/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.AboutHttpServiceKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/browserConnection/IdeInfoServerHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.javascript.debugger"})
public final class IdeInfoServerHandler
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri()");
        if (!StringsKt.startsWith$default((String)string, (String)"/browserConnection/buildInfo", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        JsonGenerator writer;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)urlDecoder.path(), (Object)"/browserConnection/buildInfo") ^ true) {
            return false;
        }
        StringWriter sb = new StringWriter();
        JsonGenerator jsonGenerator = writer = new JsonFactory().createGenerator((Writer)sb).useDefaultPrettyPrinter();
        Intrinsics.checkNotNullExpressionValue((Object)jsonGenerator, (String)"writer");
        JsonGenerator $this$obj$iv = jsonGenerator;
        String fieldName$iv = null;
        boolean $i$f$obj = false;
        $this$obj$iv.writeStartObject();
        boolean bl = false;
        AboutHttpServiceKt.writeAboutJson((JsonGenerator)writer);
        $this$obj$iv.writeEndObject();
        writer.close();
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        HttpResponse httpResponse = (HttpResponse)Responses.response$default((CharSequence)string, null, (int)2, null);
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
        Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (int)4, null);
        return true;
    }
}

