/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u001c\u0010\u0011\u001a\u00020\u00102\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/breakpoints/JSLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "breakpointTypeClass", "Ljava/lang/Class;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "manager", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "(Ljava/lang/Class;Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;)V", "getManager", "()Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "getVMsOfBreakpoint", "", "Lorg/jetbrains/debugger/Vm;", "breakpoint", "registerBreakpoint", "", "unregisterBreakpoint", "temporary", "", "intellij.javascript.debugger"})
public final class JSLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<?>> {
    @NotNull
    private final JavaScriptLineBreakpointManager manager;

    public void registerBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable $this$forEach$iv = this.getVMsOfBreakpoint(breakpoint);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm it = (Vm)element$iv;
            boolean bl = false;
            this.manager.setBreakpoint(it, breakpoint);
        }
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable $this$forEach$iv = this.getVMsOfBreakpoint(breakpoint);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vm it = (Vm)element$iv;
            boolean bl = false;
            this.manager.removeBreakpoint(it, breakpoint, temporary);
        }
    }

    private final List<Vm> getVMsOfBreakpoint(XLineBreakpoint<?> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        VirtualFile file2 = xSourcePosition != null ? xSourcePosition.getFile() : null;
        return file2 instanceof VmScriptFile ? CollectionsKt.listOf((Object)((VmScriptFile)file2).getScript().getVm()) : this.manager.getDebugProcess$intellij_javascript_debugger().getCollectVMs();
    }

    @NotNull
    public final JavaScriptLineBreakpointManager getManager() {
        return this.manager;
    }

    public JSLineBreakpointHandler(@NotNull Class<? extends XLineBreakpointType<?>> breakpointTypeClass, @NotNull JavaScriptLineBreakpointManager manager) {
        Intrinsics.checkNotNullParameter(breakpointTypeClass, (String)"breakpointTypeClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(breakpointTypeClass);
        this.manager = manager;
    }
}

