/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.actions;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipSuspendContextManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J`\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062M\b\u0004\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\fH\u0082\bJ\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/actions/JSRestartFrameAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSession", "Lcom/intellij/xdebugger/XDebugSession;", "isAvailable", "", "onAvailableRunnable", "Lkotlin/Function3;", "Lorg/jetbrains/wip/WipSuspendContextManager;", "Lkotlin/ParameterName;", "name", "suspendContextManager", "Lorg/jetbrains/wip/WipCallFrame;", "callFrame", "session", "update", "intellij.javascript.debugger"})
public final class JSRestartFrameAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Presentation presentation2 = presentation;
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        JSRestartFrameAction this_$iv = this;
        boolean $i$f$isAvailable = false;
        XDebugSession xDebugSession = this_$iv.getSession(e);
        if (xDebugSession == null) {
            bl = false;
        } else {
            XDebugSession session$iv = xDebugSession;
            XStackFrame xStackFrame = session$iv.getCurrentStackFrame();
            if (!(xStackFrame instanceof CallFrameView)) {
                xStackFrame = null;
            }
            CallFrameView callFrameView = (CallFrameView)xStackFrame;
            if (callFrameView == null) {
                bl = false;
            } else {
                CallFrameView stackFrame$iv = callFrameView;
                Vm vm = stackFrame$iv.getVm();
                Object object = vm != null ? vm.getSuspendContextManager() : null;
                if (!(object instanceof WipSuspendContextManager)) {
                    object = null;
                }
                WipSuspendContextManager wipSuspendContextManager = (WipSuspendContextManager)object;
                if (wipSuspendContextManager == null) {
                    bl = false;
                } else {
                    WipSuspendContextManager suspendContextManager$iv = wipSuspendContextManager;
                    if (!suspendContextManager$iv.isRestartFrameSupported()) {
                        bl = false;
                    } else {
                        CallFrame callFrame$iv = stackFrame$iv.getCallFrame();
                        if (!suspendContextManager$iv.canRestartFrame(callFrame$iv)) {
                            bl = false;
                        } else {
                            CallFrame callFrame = callFrame$iv;
                            if (callFrame == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.wip.WipCallFrame");
                            }
                            XDebugSession xDebugSession2 = session$iv;
                            WipCallFrame wipCallFrame = (WipCallFrame)callFrame;
                            WipSuspendContextManager wipSuspendContextManager2 = suspendContextManager$iv;
                            Presentation presentation3 = presentation2;
                            boolean bl2 = false;
                            Unit unit = Unit.INSTANCE;
                            presentation2 = presentation3;
                            bl = true;
                        }
                    }
                }
            }
        }
        presentation2.setEnabled(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JSRestartFrameAction this_$iv = this;
        boolean $i$f$isAvailable = false;
        XDebugSession xDebugSession = this_$iv.getSession(e);
        if (xDebugSession == null) {
        } else {
            XDebugSession session$iv = xDebugSession;
            XStackFrame xStackFrame = session$iv.getCurrentStackFrame();
            if (!(xStackFrame instanceof CallFrameView)) {
                xStackFrame = null;
            }
            CallFrameView callFrameView = (CallFrameView)xStackFrame;
            if (callFrameView == null) {
            } else {
                CallFrameView stackFrame$iv = callFrameView;
                Vm vm = stackFrame$iv.getVm();
                Object object = vm != null ? vm.getSuspendContextManager() : null;
                if (!(object instanceof WipSuspendContextManager)) {
                    object = null;
                }
                WipSuspendContextManager wipSuspendContextManager = (WipSuspendContextManager)object;
                if (wipSuspendContextManager == null) {
                } else {
                    CallFrame callFrame$iv;
                    WipSuspendContextManager suspendContextManager$iv = wipSuspendContextManager;
                    if (suspendContextManager$iv.isRestartFrameSupported() && suspendContextManager$iv.canRestartFrame(callFrame$iv = stackFrame$iv.getCallFrame())) {
                        void session;
                        void callFrame;
                        CallFrame callFrame2 = callFrame$iv;
                        if (callFrame2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.wip.WipCallFrame");
                        }
                        XDebugSession xDebugSession2 = session$iv;
                        WipCallFrame wipCallFrame = (WipCallFrame)callFrame2;
                        WipSuspendContextManager suspendContextManager = suspendContextManager$iv;
                        boolean bl = false;
                        suspendContextManager.restartFrame((CallFrame)callFrame).onSuccess((Consumer)new Consumer<Boolean>((XDebugSession)session){
                            final /* synthetic */ XDebugSession $session;

                            public final void accept(Boolean it) {
                                this.$session.positionReached(this.$session.getSuspendContext());
                            }
                            {
                                this.$session = xDebugSession;
                            }
                        });
                    }
                }
            }
        }
    }

    private final boolean isAvailable(AnActionEvent e, Function3<? super WipSuspendContextManager, ? super WipCallFrame, ? super XDebugSession, Unit> onAvailableRunnable) {
        int $i$f$isAvailable = 0;
        XDebugSession xDebugSession = this.getSession(e);
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession session = xDebugSession;
        XStackFrame xStackFrame = session.getCurrentStackFrame();
        if (!(xStackFrame instanceof CallFrameView)) {
            xStackFrame = null;
        }
        CallFrameView callFrameView = (CallFrameView)xStackFrame;
        if (callFrameView == null) {
            return false;
        }
        CallFrameView stackFrame = callFrameView;
        Vm vm = stackFrame.getVm();
        Object object = vm != null ? vm.getSuspendContextManager() : null;
        if (!(object instanceof WipSuspendContextManager)) {
            object = null;
        }
        WipSuspendContextManager wipSuspendContextManager = (WipSuspendContextManager)object;
        if (wipSuspendContextManager == null) {
            return false;
        }
        WipSuspendContextManager suspendContextManager = wipSuspendContextManager;
        if (!suspendContextManager.isRestartFrameSupported()) {
            return false;
        }
        CallFrame callFrame = stackFrame.getCallFrame();
        if (!suspendContextManager.canRestartFrame(callFrame)) {
            return false;
        }
        CallFrame callFrame2 = callFrame;
        if (callFrame2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.wip.WipCallFrame");
        }
        onAvailableRunnable.invoke((Object)suspendContextManager, (Object)((WipCallFrame)callFrame2), (Object)session);
        return true;
    }

    private final XDebugSession getSession(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return null");
        Project project2 = project;
        XDebugSession xDebugSession = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
        if (xDebugSession == null) {
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
            xDebugSession = xDebuggerManager.getCurrentSession();
        }
        return xDebugSession;
    }

    public JSRestartFrameAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        Presentation presentation2 = presentation;
        presentation2.setText(JSDebuggerBundle.message("js.restart.frame.text", new Object[0]));
        presentation2.setDescription(JSDebuggerBundle.message("js.restart.frame.description", new Object[0]));
        presentation2.setIcon(AllIcons.Actions.RestartFrame);
    }
}

