/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.BaseCollector;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.VariablesAndExpressionsCollector;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0,J\u0018\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002042\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002042\u0006\u00108\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002042\u0006\u00108\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002042\u0006\u0010.\u001a\u00020#H\u0016J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020AH\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0014\u001a\u0004\b&\u0010'R\u0016\u0010)\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/javascript/debugger/VariablesAndExpressionsCollector;", "Lcom/intellij/javascript/debugger/BaseCollector;", "positionOffset", "", "host", "Lcom/intellij/psi/PsiElement;", "nameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "positionElement", "(ILcom/intellij/psi/PsiElement;Lcom/intellij/javascript/debugger/NameMapper;Lcom/intellij/psi/PsiElement;)V", "QUALIFIER_LIMIT", "collectExpression", "", "expressions", "", "", "Lcom/intellij/javascript/debugger/NavigatableVariableBackedPsiElement;", "getExpressions", "()Ljava/util/Map;", "expressions$delegate", "Lkotlin/Lazy;", "hostFile", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "hostTextRange", "Lcom/intellij/openapi/util/TextRange;", "ignoreReferences", "isProcessAllQualifiers", "()Z", "isProcessAllQualifiers$delegate", "processedReferenceTargets", "Lgnu/trove/THashMap;", "qualifierCount", "tempQualifiers", "", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "getValueModifier", "()Lorg/jetbrains/debugger/ValueModifier;", "valueModifier$delegate", "variableDeclaredAfter", "", "getVariableDeclaredAfter", "", "isSuitableTarget", "referenceExpression", "target", "isVisible", "element", "Lcom/intellij/lang/javascript/psi/JSElement;", "visitJSCallExpression", "", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "visitJSFunctionDeclaration", "node", "Lcom/intellij/lang/javascript/psi/JSFunction;", "visitJSFunctionExpression", "Lcom/intellij/lang/javascript/psi/JSFunctionExpression;", "visitJSIndexedPropertyAccessExpression", "Lcom/intellij/lang/javascript/psi/JSIndexedPropertyAccessExpression;", "visitJSReferenceExpression", "visitJSVariable", "variable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "intellij.javascript.debugger"})
public final class VariablesAndExpressionsCollector
extends BaseCollector {
    private final Lazy isProcessAllQualifiers$delegate;
    private final int QUALIFIER_LIMIT;
    private final boolean collectExpression;
    private final TextRange hostTextRange;
    private final PsiFile hostFile;
    private Set<String> variableDeclaredAfter;
    @NotNull
    private final Lazy expressions$delegate;
    private final Lazy valueModifier$delegate;
    private final THashMap<PsiElement, Boolean> processedReferenceTargets;
    private List<JSReferenceExpression> tempQualifiers;
    private final Map<String, Integer> qualifierCount;
    private boolean ignoreReferences;
    private final int positionOffset;
    private final NameMapper nameMapper;
    private final PsiElement positionElement;

    private final boolean isProcessAllQualifiers() {
        Lazy lazy = this.isProcessAllQualifiers$delegate;
        VariablesAndExpressionsCollector variablesAndExpressionsCollector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Map<String, NavigatableVariableBackedPsiElement> getExpressions() {
        Lazy lazy = this.expressions$delegate;
        VariablesAndExpressionsCollector variablesAndExpressionsCollector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private final ValueModifier getValueModifier() {
        Lazy lazy = this.valueModifier$delegate;
        VariablesAndExpressionsCollector variablesAndExpressionsCollector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueModifier)lazy.getValue();
    }

    public void visitJSCallExpression(@NotNull JSCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        boolean ignoreState = this.ignoreReferences;
        this.ignoreReferences = false;
        JSArgumentList jSArgumentList = callExpression.getArgumentList();
        if (jSArgumentList != null) {
            jSArgumentList.accept((PsiElementVisitor)this);
        }
        this.ignoreReferences = true;
        PsiElement firstChild = callExpression.getFirstChild();
        if (firstChild instanceof JSReferenceExpression) {
            JSExpression jSExpression = ((JSReferenceExpression)firstChild).getQualifier();
            if (jSExpression != null) {
                jSExpression.accept((PsiElementVisitor)this);
            }
        }
        this.ignoreReferences = ignoreState;
    }

    public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JSExpression jSExpression = node.getQualifier();
            if (!(jSExpression instanceof JSReferenceExpression)) {
                jSExpression = null;
            }
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)jSExpression;
            if (jSReferenceExpression != null) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                JSExpression jSExpression2;
                JSReferenceExpression jSReferenceExpression2 = jSReferenceExpression;
                boolean bl4 = false;
                boolean bl5 = false;
                JSReferenceExpression qualifier = jSReferenceExpression2;
                boolean bl6 = false;
                JSExpression jSExpression3 = node.getIndexExpression();
                if (jSExpression3 != null) {
                    jSExpression2 = jSExpression3;
                    bl3 = false;
                    bl2 = false;
                    JSExpression it = jSExpression2;
                    boolean bl7 = false;
                    bl = SideEffectChecker.mayHaveSideEffects((JSExpression)it);
                } else {
                    bl = true;
                }
                boolean hasSideEffects = bl;
                PsiElement psiElement = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)((PsiPolyVariantReference)qualifier));
                if (psiElement != null) {
                    jSExpression2 = psiElement;
                    bl3 = false;
                    bl2 = false;
                    JSExpression arrayTarget = jSExpression2;
                    boolean bl8 = false;
                    JSExpression jSExpression4 = arrayTarget;
                    Intrinsics.checkNotNullExpressionValue((Object)jSExpression4, (String)"arrayTarget");
                    if (this.isSuitableTarget(qualifier, (PsiElement)jSExpression4) && !hasSideEffects) {
                        String name = node.getText();
                        if (this.getExpressions().containsKey(name)) {
                            NavigatableVariableBackedPsiElement navigatableVariableBackedPsiElement = this.getExpressions().get(name);
                            Intrinsics.checkNotNull((Object)navigatableVariableBackedPsiElement);
                            navigatableVariableBackedPsiElement.addInlineReference((PsiElement)node);
                        } else {
                            Map<String, NavigatableVariableBackedPsiElement> map2 = this.getExpressions();
                            String string = node.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                            map2.putIfAbsent(name, new NavigatableVariableBackedPsiElement(string, (PsiElement)node, this.getValueModifier()));
                        }
                    }
                }
            }
            JSExpression jSExpression5 = node.getIndexExpression();
            if (jSExpression5 == null) break block8;
            jSExpression5.accept((PsiElementVisitor)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
        void thisGeneratedName;
        JSExpression qualifier;
        String string;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                if (!this.collectExpression || this.ignoreReferences || SideEffectChecker.mayHaveSideEffects((JSExpression)((JSExpression)referenceExpression))) break block16;
                Map<String, Integer> map2 = this.qualifierCount;
                JSExpression jSExpression = referenceExpression.getQualifier();
                string = jSExpression != null ? jSExpression.getText() : null;
                Integer n = 0;
                boolean bl = false;
                Map<String, Integer> map3 = map2;
                if (map3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                if (((Number)map3.getOrDefault(string, n)).intValue() < this.QUALIFIER_LIMIT) break block17;
            }
            return;
        }
        if (this.tempQualifiers == null) {
            this.tempQualifiers = (List)new SmartList();
        } else {
            List<JSReferenceExpression> list = this.tempQualifiers;
            Intrinsics.checkNotNull(list);
            list.clear();
        }
        List<JSReferenceExpression> list = this.tempQualifiers;
        Intrinsics.checkNotNull(list);
        List<JSReferenceExpression> qualifiers = list;
        qualifiers.add(referenceExpression);
        string = new Ref.ObjectRef();
        ((Ref.ObjectRef)string).element = null;
        JSReferenceExpression expression = referenceExpression;
        while ((qualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier;
            qualifiers.add(expression);
        }
        if (qualifier instanceof JSThisExpression) {
            NameMapper nameMapper = this.nameMapper;
            thisGeneratedName.element = nameMapper != null ? NameMapper.map$default((NameMapper)nameMapper, (PsiElement)((PsiElement)qualifier), (boolean)false, (int)2, null) : null;
        }
        Function1<JSReferenceExpression, String> $fun$computeRawName$1 = new Function1<JSReferenceExpression, String>(this, (Ref.ObjectRef)thisGeneratedName){
            final /* synthetic */ VariablesAndExpressionsCollector this$0;
            final /* synthetic */ Ref.ObjectRef $thisGeneratedName;

            @NotNull
            public final String invoke(@NotNull JSReferenceExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                String sourceQualifiedName = expression.getText();
                if ((String)this.$thisGeneratedName.element == null) {
                    Object object = VariablesAndExpressionsCollector.access$getNameMapper$p(this.this$0);
                    if (object == null || (object = NameMapper.map$default((NameMapper)object, (PsiElement)((PsiElement)expression), (boolean)false, (int)2, null)) == null) {
                        String string = sourceQualifiedName;
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceQualifiedName");
                    }
                    return object;
                }
                StringBuilder builder = new StringBuilder(sourceQualifiedName.length() + ((String)this.$thisGeneratedName.element).length());
                builder.append((String)this.$thisGeneratedName.element);
                builder.append(sourceQualifiedName, "this".length(), sourceQualifiedName.length());
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                String rawQualifiedName = string;
                NameMapper nameMapper = VariablesAndExpressionsCollector.access$getNameMapper$p(this.this$0);
                Intrinsics.checkNotNull((Object)nameMapper);
                String string2 = sourceQualifiedName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceQualifiedName");
                nameMapper.addMapping(rawQualifiedName, string2);
                return rawQualifiedName;
            }
            {
                this.this$0 = variablesAndExpressionsCollector;
                this.$thisGeneratedName = objectRef;
                super(1);
            }
        };
        PsiElement prevTarget = null;
        int n = ((Collection)qualifiers).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            void i;
            expression = qualifiers.get((int)i);
            PsiElement target = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)((PsiPolyVariantReference)expression));
            if (target == null && !(prevTarget instanceof JSVariable)) {
                if (!this.isProcessAllQualifiers()) break;
            } else {
                prevTarget = target;
                if (target != null && !this.isSuitableTarget(expression, target)) {
                    if (i != CollectionsKt.getLastIndex(qualifiers)) break;
                    return;
                }
            }
            --i;
        }
        String name = $fun$computeRawName$1.invoke(expression);
        if (!this.getExpressions().containsKey(name)) {
            this.getExpressions().put(name, new NavigatableVariableBackedPsiElement(name, (PsiElement)expression, this.getValueModifier()));
            JSExpression jSExpression = expression.getQualifier();
            if (jSExpression != null) {
                JSExpression jSExpression2 = jSExpression;
                boolean bl2 = false;
                boolean bl3 = false;
                JSExpression it = jSExpression2;
                boolean bl4 = false;
                JSExpression jSExpression3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)jSExpression3, (String)"it");
                this.qualifierCount.compute(jSExpression3.getText(), visitJSReferenceExpression.2.1.INSTANCE);
            }
        } else {
            NavigatableVariableBackedPsiElement navigatableVariableBackedPsiElement = this.getExpressions().get(name);
            Intrinsics.checkNotNull((Object)navigatableVariableBackedPsiElement);
            NavigatableVariableBackedPsiElement variable = navigatableVariableBackedPsiElement;
            variable.addInlineReference((PsiElement)expression);
        }
    }

    private final boolean isSuitableTarget(JSReferenceExpression referenceExpression, PsiElement target) {
        if (this.processedReferenceTargets.contains((Object)target)) {
            Object object = this.processedReferenceTargets.get((Object)target);
            Intrinsics.checkNotNull((Object)object);
            return (Boolean)object;
        }
        boolean belongsToHostFile = Intrinsics.areEqual((Object)target.getContainingFile(), (Object)this.hostFile);
        PsiElement psiElement = target;
        if (psiElement instanceof JSProperty) {
            if (belongsToHostFile && !this.isVisible((JSElement)target)) {
                return false;
            }
            JSFunction jSFunction = ((JSProperty)target).tryGetFunctionInitializer();
            CharSequence charSequence = jSFunction != null ? jSFunction.getName() : null;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || charSequence.length() == 0;
        }
        if (psiElement instanceof JSDefinitionExpression) {
            if (belongsToHostFile && !this.isVisible((JSElement)target)) {
                return false;
            }
            return ((JSDefinitionExpression)target).isDeclaration() && referenceExpression.getQualifier() != null;
        }
        if (psiElement instanceof JSParameter) {
            return true;
        }
        if (psiElement instanceof LightElement) {
            return false;
        }
        if (psiElement instanceof JSVariable) {
            if (belongsToHostFile) {
                JSExpression initializer = ((JSVariable)target).getInitializer();
                if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                    return false;
                }
                boolean visible = this.isVisible((JSElement)target);
                if (((JSVariable)target).getName() != null) {
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        nameMapper.map(target, visible);
                    }
                }
                return visible;
            }
            return true;
        }
        return psiElement instanceof TypeScriptPropertySignature;
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visitJSVariable(@NotNull JSVariable variable) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            String name = variable.getName();
            if (name != null) {
                if (!this.isVisible((JSElement)variable)) {
                    if (this.variableDeclaredAfter == null) {
                        this.variableDeclaredAfter = (Set)new THashSet();
                    }
                    Set<String> set2 = this.variableDeclaredAfter;
                    Intrinsics.checkNotNull(set2);
                    set2.add(name);
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        NameMapper nameMapper2 = nameMapper;
                        boolean bl = false;
                        boolean bl2 = false;
                        NameMapper it = nameMapper2;
                        boolean bl3 = false;
                        String string = it.map((PsiElement)variable, false);
                        if (string != null) {
                            String string2 = string;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String generatedName = string2;
                            boolean bl6 = false;
                            Set<String> set3 = this.variableDeclaredAfter;
                            Intrinsics.checkNotNull(set3);
                            set3.add(generatedName);
                        }
                    }
                } else {
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        NameMapper.map$default((NameMapper)nameMapper, (PsiElement)((PsiElement)variable), (boolean)false, (int)2, null);
                    }
                }
            }
            JSExpression jSExpression = variable.getInitializerOrStub();
            if (jSExpression == null) break block7;
            jSExpression.accept((PsiElementVisitor)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisible(JSElement element) {
        TextRange textRange = element.getTextRange();
        if (this.hostTextRange.contains(textRange)) {
            TextRange textRange2 = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
            if (textRange2.getStartOffset() >= this.positionOffset) {
                return false;
            }
        }
        if (element instanceof JSNamedElement) {
            PsiElement psiElement = JSUseScopeProvider.getUseScopeElement((JSNamedElement)((JSNamedElement)element));
            if (psiElement == null) return true;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"JSUseScopeProvider.getUs\u2026t(element) ?: return true");
            PsiElement scope = psiElement;
            return PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)this.positionElement, (boolean)false);
        }
        SearchScope searchScope = element.getUseScope();
        if (!(searchScope instanceof LocalSearchScope)) {
            searchScope = null;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
        if (localSearchScope == null) return true;
        PsiElement[] psiElementArray = localSearchScope.getScope();
        PsiElement[] scope = psiElementArray;
        if (scope == null) return true;
        PsiElement[] $this$any$iv = scope;
        boolean $i$f$any = false;
        PsiElement[] psiElementArray2 = $this$any$iv;
        int n = psiElementArray2.length;
        int n2 = 0;
        while (n2 < n) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray2[n2];
            boolean bl = false;
            if (PsiTreeUtil.isAncestor((PsiElement)it, (PsiElement)this.positionElement, (boolean)false)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public final Set<String> getVariableDeclaredAfter() {
        Set set2 = this.variableDeclaredAfter;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    public VariablesAndExpressionsCollector(int positionOffset, @NotNull PsiElement host, @Nullable NameMapper nameMapper, @NotNull PsiElement positionElement) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)positionElement, (String)"positionElement");
        this.positionOffset = positionOffset;
        this.nameMapper = nameMapper;
        this.positionElement = positionElement;
        this.isProcessAllQualifiers$delegate = LazyKt.lazy((Function0)isProcessAllQualifiers.2.INSTANCE);
        this.QUALIFIER_LIMIT = 9;
        XDebuggerSettingsManager xDebuggerSettingsManager = XDebuggerSettingsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerSettingsManager, (String)"XDebuggerSettingsManager.getInstance()");
        XDebuggerSettingsManager.DataViewSettings dataViewSettings = xDebuggerSettingsManager.getDataViewSettings();
        Intrinsics.checkNotNullExpressionValue((Object)dataViewSettings, (String)"XDebuggerSettingsManager\u2026stance().dataViewSettings");
        this.collectExpression = dataViewSettings.isAutoExpressions() && !DumbService.isDumb((Project)host.getProject());
        this.hostTextRange = host.getTextRange();
        this.hostFile = host.getContainingFile();
        this.expressions$delegate = LazyKt.lazy((Function0)expressions.2.INSTANCE);
        this.valueModifier$delegate = LazyKt.lazy((Function0)valueModifier.2.INSTANCE);
        this.processedReferenceTargets = new THashMap();
        boolean bl = false;
        this.qualifierCount = new LinkedHashMap();
    }

    public static final /* synthetic */ NameMapper access$getNameMapper$p(VariablesAndExpressionsCollector $this) {
        return $this.nameMapper;
    }
}

