/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/GlobalEvaluator;", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "vmConnection", "Lorg/jetbrains/debugger/connection/VmConnection;", "(Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/connection/VmConnection;)V", "values", "Lcom/intellij/javascript/debugger/SegmentList$SegmentListWithData;", "Lkotlin/Pair;", "", "Lorg/jetbrains/debugger/values/ObjectValue;", "getValues", "()Lcom/intellij/javascript/debugger/SegmentList$SegmentListWithData;", "valuesDocument", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/editor/Document;", "evaluate", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "isDocumentForEvaluation", "", "document", "printAndStoreValueToInspect", "", "value", "Lorg/jetbrains/debugger/values/Value;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "intellij.javascript.debugger"})
public final class GlobalEvaluator
extends ChromeEvaluator {
    @NotNull
    private final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> values;
    private final AtomicReference<Document> valuesDocument;
    private final DebuggerViewSupport viewSupport;
    private final VmConnection<?> vmConnection;

    @NotNull
    public final SegmentList.SegmentListWithData<Pair<String, ObjectValue>> getValues() {
        return this.values;
    }

    public final boolean isDocumentForEvaluation(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return Intrinsics.areEqual((Object)document, (Object)this.valuesDocument.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, @NotNull ConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        String valueString = null;
        if (value instanceof ObjectValue) {
            DocumentEx consoleViewDocument;
            LanguageConsoleImpl languageConsoleImpl;
            valueString = VariableViewKt.getObjectValueDescription((ObjectValue)((ObjectValue)value));
            ConsoleView consoleView2 = consoleView;
            if (!(consoleView2 instanceof LanguageConsoleImpl)) {
                consoleView2 = null;
            }
            DocumentEx documentEx = (languageConsoleImpl = (LanguageConsoleImpl)consoleView2) != null && (languageConsoleImpl = languageConsoleImpl.getHistoryViewer()) != null ? languageConsoleImpl.getDocument() : (consoleViewDocument = null);
            if (!this.valuesDocument.compareAndSet(null, (Document)consoleViewDocument)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GlobalEvaluator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.assertTrue(Intrinsics.areEqual((Object)this.valuesDocument.get(), (Object)consoleViewDocument));
            }
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = this.values;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (segmentListWithData) {
                boolean bl3 = false;
                int startOffset = consoleView.getContentSize();
                String string = expression;
                if (string == null) {
                    string = valueString;
                }
                this.values.add((Pair<String, ObjectValue>)new Pair((Object)string, (Object)value), startOffset, startOffset + valueString.length());
                Unit unit = Unit.INSTANCE;
            }
        } else {
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            valueString = string;
        }
        consoleView.print(valueString, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (expressionPosition != null && expressionPosition.getFile() instanceof LightVirtualFile && !(expressionPosition.getFile() instanceof VmScriptFile)) {
            ObjectValue objectValue;
            ObjectValue objectValue2 = this.values;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (objectValue2) {
                boolean bl3 = false;
                Pair<String, ObjectValue> pair = this.values.getValueByOffset(expressionPosition.getOffset());
                ObjectValue objectValue3 = pair != null ? (ObjectValue)pair.getSecond() : null;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                objectValue = objectValue3;
            }
            if (objectValue != null) {
                objectValue2 = objectValue;
                bl = false;
                boolean bl4 = false;
                ObjectValue it = objectValue2;
                boolean bl5 = false;
                return Promises.resolvedPromise((Object)new EvaluateResult((Value)it, false, 2, null));
            }
        }
        return super.evaluate(expression, expressionPosition);
    }

    public GlobalEvaluator(final @NotNull DebuggerViewSupport viewSupport, final @NotNull VmConnection<?> vmConnection) {
        Intrinsics.checkNotNullParameter((Object)viewSupport, (String)"viewSupport");
        Intrinsics.checkNotNullParameter(vmConnection, (String)"vmConnection");
        super(new VariableContext(){

            @NotNull
            public EvaluateContext getEvaluateContext() {
                Vm vm = vmConnection.getVm();
                Vm vm2 = vm;
                if (vm2 == null || (vm2 = vm2.getEvaluateContext()) == null) {
                    Object object;
                    throw (Throwable)new IllegalStateException("global evaluation context is null, vm " + vm + ", vm class " + ((object = vm) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                }
                return vm2;
            }

            public boolean watchableAsEvaluationExpression() {
                return false;
            }

            @NotNull
            public DebuggerViewSupport getViewSupport() {
                return viewSupport;
            }

            @Nullable
            public Vm getVm() {
                return vmConnection.getVm();
            }

            @NotNull
            public Promise<MemberFilter> getMemberFilter() {
                return VariableContext.DefaultImpls.getMemberFilter((VariableContext)this);
            }

            @Nullable
            public VariableContext getParent() {
                return VariableContext.DefaultImpls.getParent((VariableContext)this);
            }

            @Nullable
            public Scope getScope() {
                return VariableContext.DefaultImpls.getScope((VariableContext)this);
            }

            @Nullable
            public String getVariableName() {
                return VariableContext.DefaultImpls.getVariableName((VariableContext)this);
            }
        });
        this.viewSupport = viewSupport;
        this.vmConnection = vmConnection;
        this.values = new SegmentList.SegmentListWithData();
        this.valuesDocument = new AtomicReference<Object>(null);
    }
}

