/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e\u001a*\u0010\u000f\u001a\u0004\u0018\u00010\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"MODULE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RENAME_SCORE", "", "cutOffWebpackFooter", "", "sourceContent", "resolveFileBySourceUrl", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "url", "Lcom/intellij/util/Url;", "", "selectMostSimilarFile", "files", "", "source", "intellij.javascript.debugger"})
public final class FileResolverByContentKt {
    private static final int RENAME_SCORE = 60;
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("[\\\\/]node_modules[\\\\/](.+)$");

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = sourceContent;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && (Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)url.getScheme(), (Object)"https"))) {
            return null;
        }
        String string = PathUtilRt.getFileName((String)url.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtilRt.getFileName(url.path)");
        String fileName = string;
        CharSequence charSequence2 = fileName;
        bl2 = false;
        if (charSequence2.length() > 0) {
            String pathInNodeModules;
            GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"ProjectScope.getAllScope(project)");
            GlobalSearchScope scope = globalSearchScope;
            Collection files2 = CollectionsKt.emptyList();
            Matcher matcher = MODULE_NAME_PATTERN.matcher(url.getPath());
            if (matcher.find() && matcher.groupCount() >= 1 && (pathInNodeModules = matcher.group(1)) != null) {
                void $this$mapNotNullTo$iv$iv;
                NodeModulesDirectoryManager nodeModulesDirectoryManager = NodeModulesDirectoryManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)nodeModulesDirectoryManager, (String)"NodeModulesDirectoryManager.getInstance(project)");
                List list = nodeModulesDirectoryManager.getNodeModulesDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"NodeModulesDirectoryMana\u2026t).nodeModulesDirectories");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    NodeModulesLibraryDirectory it = (NodeModulesLibraryDirectory)element$iv$iv;
                    boolean bl4 = false;
                    NodeModulesLibraryDirectory nodeModulesLibraryDirectory = it;
                    Intrinsics.checkNotNullExpressionValue((Object)nodeModulesLibraryDirectory, (String)"it");
                    if (nodeModulesLibraryDirectory.getNodeModulesDir().findFileByRelativePath(pathInNodeModules) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    VirtualFile it$iv$iv = virtualFile;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                files2 = (List)destination$iv$iv;
            }
            if (files2.isEmpty()) {
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(project, fileName, scope){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $fileName$inlined;
                    final /* synthetic */ GlobalSearchScope $scope$inlined;
                    {
                        this.$project$inlined = project;
                        this.$fileName$inlined = string;
                        this.$scope$inlined = globalSearchScope;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)this.$fileName$inlined, (GlobalSearchScope)this.$scope$inlined);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { Filename\u2026oject, fileName, scope) }");
                files2 = (Collection)object;
            }
            if (files2.isEmpty() && PathUtil.getFileExtension((String)fileName) == null) {
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(project, fileName, scope){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $fileName$inlined;
                    final /* synthetic */ GlobalSearchScope $scope$inlined;
                    {
                        this.$project$inlined = project;
                        this.$fileName$inlined = string;
                        this.$scope$inlined = globalSearchScope;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)(this.$fileName$inlined + ".js"), (GlobalSearchScope)this.$scope$inlined);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { Filename\u2026 \"$fileName.js\", scope) }");
                files2 = (Collection)object;
            }
            Object object = files2;
            boolean bl8 = false;
            if (!object.isEmpty()) {
                object = sourceContent;
                bl8 = false;
                boolean bl9 = false;
                if (!(object == null || object.length() == 0)) {
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile(files2, sourceContent, project);
                    if (virtualFile != null) {
                        object = virtualFile;
                        bl8 = false;
                        bl9 = false;
                        Object it = object;
                        boolean bl10 = false;
                        return it;
                    }
                } else if (files2.size() == 1) {
                    return (VirtualFile)CollectionsKt.first((Iterable)files2);
                }
            }
        }
        return null;
    }

    private static final CharSequence cutOffWebpackFooter(CharSequence sourceContent) {
        int n = 0;
        int n2 = sourceContent.length() - 300;
        boolean bl = false;
        int footerIndex = StringsKt.indexOf$default((CharSequence)sourceContent, (String)"WEBPACK FOOTER", (int)Math.max(n, n2), (boolean)false, (int)4, null);
        if (footerIndex >= 0) {
            int lastNonSpaceIndex = -1;
            for (int i = footerIndex - 1; i > 0; --i) {
                char c = sourceContent.charAt(i);
                if (c == '/' || c == '*') {
                    lastNonSpaceIndex = i;
                    continue;
                }
                if (!CharsKt.isWhitespace((char)c)) break;
            }
            if (lastNonSpaceIndex > 0) {
                return sourceContent.subSequence(0, lastNonSpaceIndex);
            }
        }
        return sourceContent;
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files2, @NotNull CharSequence source, @Nullable Project project) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = ((Object)FileResolverByContentKt.cutOffWebpackFooter(source)).toString();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] sourceBytes = byArray;
        SimilarityIndex sourceIndex = null;
        VirtualFile matchedFile = null;
        int lastMatchedScore = 60;
        for (VirtualFile virtualFile : files2) {
            int contentScore;
            int score;
            int n;
            byte[] destination$iv;
            if (virtualFile.isDirectory()) continue;
            int length = (int)virtualFile.getLength();
            int n2 = sourceBytes.length;
            int n3 = 0;
            int max = Math.max(n2, length);
            n3 = sourceBytes.length;
            boolean bl2 = false;
            int min = Math.min(n3, length);
            if (min * 100 / max < 60) continue;
            if (project != null) {
                boolean $i$f$runReadAction = false;
                if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile, project){
                    final /* synthetic */ VirtualFile $file$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$file$inlined = virtualFile;
                        this.$project$inlined = project;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(JSMinifiedFileUtil.isFileMinified((VirtualFile)this.$file$inlined, (Project)this.$project$inlined));
                    }
                })).booleanValue()) continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.contentsToByteArray(), (String)"file.contentsToByteArray()");
            int maxScore$iv = 10000;
            boolean $i$f$similarityScore = false;
            if (Arrays.equals(sourceBytes, destination$iv)) {
                n = maxScore$iv;
            } else {
                boolean bl3 = false;
                if (sourceIndex == null) {
                    sourceIndex = SimilarityIndexKt.SimilarityIndex(sourceBytes);
                }
                SimilarityIndex similarityIndex = sourceIndex;
                Intrinsics.checkNotNull((Object)similarityIndex);
                n = SimilarityIndex.score$default(similarityIndex, SimilarityIndexKt.SimilarityIndex(destination$iv), 0, 2, null);
            }
            if ((score = ((contentScore = n) * 99 + 100) / 10000) <= lastMatchedScore) continue;
            matchedFile = virtualFile;
            lastMatchedScore = score;
        }
        return matchedFile;
    }

    public static /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, CharSequence charSequence, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile(collection, charSequence, project);
    }
}

