/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.firefox.FirefoxCallFrame;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxScript;
import com.jetbrains.firefox.FirefoxScriptManager;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Source;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u00172\u0006\u0010\b\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/firefox/FirefoxScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lcom/jetbrains/firefox/FirefoxScript;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "addScript", "", "script", "Lcom/jetbrains/firefox/rdp/Source;", "containsScript", "", "Lorg/jetbrains/debugger/Script;", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "Lorg/jetbrains/concurrency/Promise;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.firefox.connector"})
public final class FirefoxScriptManager
extends ScriptManagerBaseEx<FirefoxScript> {
    private final FirefoxVm vm;

    public final void addScript(@NotNull Source script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String rawScriptUrl = script.url();
        if (rawScriptUrl == null || Intrinsics.areEqual((Object)rawScriptUrl, (Object)"debugger eval code") || Intrinsics.areEqual((Object)rawScriptUrl, (Object)"self-hosted")) {
            return;
        }
        Url url = Urls.parseEncoded((String)rawScriptUrl);
        if (url == null && StringsKt.endsWith$default((String)rawScriptUrl, (String)"Bundle", (boolean)false, (int)2, null)) {
            return;
        }
        CommandProcessorKt.getLOG().assertTrue(url != null, (Object)rawScriptUrl);
        String string = script.actor();
        Script.Type type = script.isBlackBoxed() ? Script.Type.NATIVE : Script.Type.NORMAL;
        Url url2 = url;
        Intrinsics.checkNotNull((Object)url2);
        FirefoxScript vmScript = new FirefoxScript(string, type, rawScriptUrl, url2, 0, 0, -1, (Vm)this.vm);
        if (this.getIdToScript().putIfAbsent(script.actor(), vmScript) != null) {
            return;
        }
        this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)vmScript, null);
    }

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return script instanceof FirefoxScript && this.getIdToScript().containsKey(((FirefoxScript)script).actor);
    }

    @NotNull
    public Void getScript(@NotNull FunctionValue function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        FirefoxCallFrame fxFrame = (FirefoxCallFrame)frame;
        if (fxFrame.scriptId != null) {
            return (Script)this.getIdToScript().get(fxFrame.scriptId);
        }
        for (FirefoxScript script : this.getIdToScript().values()) {
            if (!Intrinsics.areEqual((Object)script.rawUrl, (Object)fxFrame.scriptUrl)) continue;
            return (Script)script;
        }
        return null;
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull FirefoxScript script) {
        Intrinsics.checkNotNullParameter((Object)((Object)script), (String)"script");
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = script.actor;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"script.actor");
        Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.getScriptSource(string)).then((Function)loadScriptSource.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"vm.commandProcessor.send\u2026    .then { it.source() }");
        return promise;
    }

    public FirefoxScriptManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }
}

