/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps.reference;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaParameterPomTarget;

public class CucumberJavaParameterTypeReference
extends PsiReferenceBase<PsiElement> {
    public CucumberJavaParameterTypeReference(@NotNull PsiElement element, @NotNull TextRange range) {
        if (element == null) {
            CucumberJavaParameterTypeReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CucumberJavaParameterTypeReference.$$$reportNull$$$0(1);
        }
        super(element, TextRange.create((int)(range.getStartOffset() + 1), (int)(range.getEndOffset() - 1)), false);
    }

    @Nullable
    public PsiElement resolve() {
        MapParameterTypeManager manager;
        PsiElement declaration;
        String parameterTypeName = this.getParameterTypeName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null && (declaration = (manager = CucumberJavaUtil.getAllParameterTypes(module)).getParameterTypeDeclaration(parameterTypeName)) != null) {
            return PomService.convertToPsi((PsiTarget)new CucumberJavaParameterPomTarget(declaration, parameterTypeName));
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getParameterTypeName();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CucumberJavaParameterTypeReference.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiNamedElement) || !(element instanceof PomTargetPsiElement)) {
            return false;
        }
        PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
        if (!(pomTarget instanceof CucumberJavaParameterPomTarget)) {
            return false;
        }
        String parameterTypeName = this.getParameterTypeName();
        if (!StringUtil.equals((CharSequence)((PsiNamedElement)element).getName(), (CharSequence)parameterTypeName)) {
            return false;
        }
        PsiElement resolved = this.resolve();
        return resolved != null && resolved.equals(element);
    }

    @NotNull
    private String getParameterTypeName() {
        String string = this.getRangeInElement().substring(this.myElement.getText());
        if (string == null) {
            CucumberJavaParameterTypeReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/steps/reference/CucumberJavaParameterTypeReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/steps/reference/CucumberJavaParameterTypeReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

