/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import org.jetbrains.plugins.cucumber.java.steps.CucumberVersionProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class AnnotationPackageProvider {
    private static final String CUCUMBER_1_1_ANNOTATION_BASE_PACKAGE = "cucumber.api.java.";
    private static final String CUCUMBER_1_0_ANNOTATION_BASE_PACKAGE = "cucumber.annotation.";
    private static final String CUCUMBER_4_5_ANNOTATION_BASE_PACKAGE = "io.cucumber.java.";
    public static final String[] CUCUMBER_ANNOTATION_PACKAGES = new String[]{"cucumber.api.java.", "cucumber.annotation.", "io.cucumber.java."};
    private final CucumberVersionProvider myVersionProvider;

    public AnnotationPackageProvider() {
        this(new CucumberVersionProvider());
    }

    public AnnotationPackageProvider(CucumberVersionProvider cucumberVersionProvider) {
        this.myVersionProvider = cucumberVersionProvider;
    }

    public String getAnnotationPackageFor(GherkinStep step) {
        return String.format("%s%s", this.annotationBasePackage(step), AnnotationPackageProvider.locale(step));
    }

    private static String locale(GherkinStep step) {
        GherkinFile file = (GherkinFile)step.getContainingFile();
        return file.getLocaleLanguage().replaceAll("-", "_");
    }

    private String annotationBasePackage(GherkinStep step) {
        String version = this.myVersionProvider.getVersion(step);
        if (version != null && version.compareTo("1.1") < 0) {
            return CUCUMBER_1_0_ANNOTATION_BASE_PACKAGE;
        }
        if (version != null && version.compareTo("4.5") < 0) {
            return CUCUMBER_1_1_ANNOTATION_BASE_PACKAGE;
        }
        return CUCUMBER_4_5_ANNOTATION_BASE_PACKAGE;
    }
}

