/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.CucumberJavaVersionUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class AbstractJavaStepDefinition
extends AbstractStepDefinition {
    public AbstractJavaStepDefinition(@NotNull PsiElement element) {
        if (element == null) {
            AbstractJavaStepDefinition.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @Nullable
    public String getCucumberRegex() {
        String definitionText = this.getExpression();
        if (definitionText == null) {
            return null;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && !CucumberJavaVersionUtil.isCucumber3OrMore(element)) {
            return definitionText;
        }
        if (CucumberJavaUtil.isCucumberExpression(definitionText)) {
            MapParameterTypeManager parameterTypes = module != null ? CucumberJavaUtil.getAllParameterTypes(module) : CucumberJavaUtil.JAVA_DEFAULT_PARAMETER_TYPE_MANAGER;
            return CucumberUtil.buildRegexpFromCucumberExpression((String)definitionText, (ParameterTypeManager)parameterTypes);
        }
        return definitionText;
    }

    public List<String> getVariableNames() {
        PsiElement element = this.getElement();
        if (element instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)element).getParameterList().getParameters();
            ArrayList<String> result = new ArrayList<String>();
            for (PsiParameter parameter : parameters) {
                result.add(parameter.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/java/steps/AbstractJavaStepDefinition", "<init>"));
    }
}

