/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CucumberConfigUtil {
    @NonNls
    private static final Pattern CUCUMBER_PATTERN = Pattern.compile("cucumber-core-(.*)\\.jar");
    @NonNls
    private static final String CUCUMBER_CLI_MAIN_1_0 = "cucumber.cli.Main";
    @NonNls
    private static final String CUCUMBER_API_CLI_MAIN_1_1 = "cucumber.api.cli.Main";
    @NonNls
    public static final String CUCUMBER_VERSION_1_0 = "1.0";
    @NonNls
    public static final String CUCUMBER_VERSION_1_1 = "1.1";
    @NonNls
    public static final String CUCUMBER_VERSION_4_5 = "4.5";

    @Nullable
    public static String getCucumberCoreVersion(@NotNull PsiElement place) {
        Module module;
        if (place == null) {
            CucumberConfigUtil.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) == null) {
            return null;
        }
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)CucumberConfigUtil.getCucumberCoreVersionImpl(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @Nullable
    private static String getCucumberCoreVersionImpl(Module module) {
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            VirtualFile[] files;
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            String libraryName = ((LibraryOrderEntry)orderEntry).getLibraryName();
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (libraryName != null && !StringUtil.toLowerCase((String)libraryName).contains("cucumber") || library == null) continue;
            for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
                String version = CucumberConfigUtil.getVersionByFile(file);
                if (version == null) continue;
                return version;
            }
        }
        return CucumberConfigUtil.getSimpleVersionFromMainClass(module);
    }

    private static String getSimpleVersionFromMainClass(Module module) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass oldMain = facade.findClass(CUCUMBER_CLI_MAIN_1_0, module.getModuleWithLibrariesScope());
        if (oldMain != null) {
            return CUCUMBER_VERSION_1_0;
        }
        PsiClass newMain = facade.findClass(CUCUMBER_API_CLI_MAIN_1_1, module.getModuleWithLibrariesScope());
        if (newMain != null) {
            return CUCUMBER_VERSION_1_1;
        }
        return null;
    }

    @Nullable
    private static String getVersionByFile(VirtualFile file) {
        String name = file.getName();
        Matcher matcher = CUCUMBER_PATTERN.matcher(name);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/cucumber/java/config/CucumberConfigUtil", "getCucumberCoreVersion"));
    }
}

