/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CucumberJavaVersionUtil {
    public static final String CUCUMBER_CORE_VERSION_5 = "5";
    public static final String CUCUMBER_CORE_VERSION_4_5 = "4.5";
    public static final String CUCUMBER_CORE_VERSION_4 = "4";
    public static final String CUCUMBER_CORE_VERSION_3 = "3";
    public static final String CUCUMBER_CORE_VERSION_2 = "2";
    public static final String CUCUMBER_CORE_VERSION_1_2 = "1.2";
    public static final String CUCUMBER_CORE_VERSION_1_1 = "1.1";
    public static final String CUCUMBER_CORE_VERSION_1_0 = "1";
    private static final List<Pair<String, String>> VERSION_CLASS_MARKERS = new ArrayList<Pair<String, String>>();
    private static final Logger LOG = Logger.getInstance(CucumberJavaVersionUtil.class);

    @NotNull
    public static String getCucumberCoreVersion(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(0);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        CachedValue result = manager.createCachedValue(() -> {
            String resultCucumberCoreVersion = CucumberJavaVersionUtil.computeCucumberCoreVersion(module, project);
            return CachedValueProvider.Result.create((Object)resultCucumberCoreVersion, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
        String string = (String)result.getValue();
        if (string == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isCucumber2OrMore(@NotNull Module module) {
        if (module == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(2);
        }
        return VersionComparatorUtil.compare((String)CucumberJavaVersionUtil.getCucumberCoreVersion(module, module.getProject()), (String)CUCUMBER_CORE_VERSION_2) >= 0;
    }

    public static boolean isCucumber3OrMore(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(3);
        }
        return VersionComparatorUtil.compare((String)CucumberJavaVersionUtil.getCucumberCoreVersion(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context), context.getProject()), (String)CUCUMBER_CORE_VERSION_3) >= 0;
    }

    @NotNull
    private static String computeCucumberCoreVersion(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(4);
        }
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true) : GlobalSearchScope.projectScope((Project)project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (Pair<String, String> marker : VERSION_CLASS_MARKERS) {
            if (facade.findClass((String)marker.first, scope) == null) continue;
            LOG.debug("Cucumber-core version detected by class: " + (String)marker.first + ", version: " + (String)marker.second);
            String string = (String)marker.second;
            if (string == null) {
                CucumberJavaVersionUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String theLatestVersion = (String)CucumberJavaVersionUtil.VERSION_CLASS_MARKERS.get((int)(CucumberJavaVersionUtil.VERSION_CLASS_MARKERS.size() - 1)).second;
        LOG.debug("Can't detect cucumber-core version by marker class, assume the latest version: " + theLatestVersion);
        String string = theLatestVersion;
        if (string == null) {
            CucumberJavaVersionUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    static {
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"io.cucumber.plugin.event.EventHandler", (Object)CUCUMBER_CORE_VERSION_5));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"io.cucumber.core.cli.Main", (Object)CUCUMBER_CORE_VERSION_4_5));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.api.event.ConcurrentEventListener", (Object)CUCUMBER_CORE_VERSION_4));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.runner.TestCase", (Object)CUCUMBER_CORE_VERSION_3));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.api.formatter.Formatter", (Object)CUCUMBER_CORE_VERSION_2));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.api.Plugin", (Object)CUCUMBER_CORE_VERSION_1_2));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.api.cli.Main", (Object)CUCUMBER_CORE_VERSION_1_1));
        VERSION_CLASS_MARKERS.add((Pair<String, String>)Pair.create((Object)"cucumber.cli.Main", (Object)CUCUMBER_CORE_VERSION_1_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/CucumberJavaVersionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/CucumberJavaVersionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCucumberCoreVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCucumberCoreVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberCoreVersion";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCucumber2OrMore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCucumber3OrMore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeCucumberCoreVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

