/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.text.VersionComparatorUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.java.config.CucumberConfigUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationProducer;
import org.jetbrains.plugins.cucumber.java.steps.AnnotationPackageProvider;
import org.jetbrains.plugins.cucumber.java.steps.reference.CucumberJavaAnnotationProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinRecursiveElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class CucumberJavaUtil {
    public static final String PARAMETER_TYPE_CLASS = "io.cucumber.cucumberexpressions.ParameterType";
    private static final Map<String, String> JAVA_PARAMETER_TYPES;
    public static final String CUCUMBER_EXPRESSIONS_CLASS_MARKER = "io.cucumber.cucumberexpressions.CucumberExpressionGenerator";
    private static final Pattern SCRIPT_STYLE_REGEXP;
    public static final String CUCUMBER_1_0_MAIN_CLASS = "cucumber.cli.Main";
    public static final String CUCUMBER_1_1_MAIN_CLASS = "cucumber.api.cli.Main";
    public static final String CUCUMBER_4_5_MAIN_CLASS = "io.cucumber.core.cli.Main";
    public static final String PARAMETER_TYPE_ANNOTATION_FQN = "io.cucumber.java.ParameterType";
    private static final CallMatcher FROM_ENUM_METHOD;
    public static final MapParameterTypeManager JAVA_DEFAULT_PARAMETER_TYPE_MANAGER;

    public static boolean isCucumberExpression(@NotNull String expression) {
        if (expression == null) {
            CucumberJavaUtil.$$$reportNull$$$0(0);
        }
        return !expression.startsWith("^") && !expression.endsWith("$") && !SCRIPT_STYLE_REGEXP.matcher(expression).find();
    }

    private static String getCucumberAnnotationSuffix(@NotNull String name) {
        if (name == null) {
            CucumberJavaUtil.$$$reportNull$$$0(1);
        }
        for (String pkg : AnnotationPackageProvider.CUCUMBER_ANNOTATION_PACKAGES) {
            if (!name.startsWith(pkg)) continue;
            return name.substring(pkg.length());
        }
        return "";
    }

    public static String getCucumberPendingExceptionFqn(@NotNull PsiElement context) {
        String version;
        if (context == null) {
            CucumberJavaUtil.$$$reportNull$$$0(2);
        }
        if ((version = CucumberConfigUtil.getCucumberCoreVersion(context)) == null || version.compareTo("1.1") >= 0) {
            return "cucumber.api.PendingException";
        }
        return "cucumber.runtime.PendingException";
    }

    @Nullable
    private static String getAnnotationName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(3);
        }
        Ref qualifiedAnnotationName = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            String qualifiedName = annotation.getQualifiedName();
            qualifiedAnnotationName.set((Object)qualifiedName);
        });
        return (String)qualifiedAnnotationName.get();
    }

    public static boolean isCucumberStepAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(4);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        if (annotationSuffix.contains(".")) {
            return true;
        }
        return CucumberJavaAnnotationProvider.STEP_MARKERS.contains(annotationName);
    }

    public static boolean isCucumberHookAnnotation(@NotNull PsiAnnotation annotation) {
        String annotationName;
        if (annotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(5);
        }
        if ((annotationName = CucumberJavaUtil.getAnnotationName(annotation)) == null) {
            return false;
        }
        String annotationSuffix = CucumberJavaUtil.getCucumberAnnotationSuffix(annotationName);
        return CucumberJavaAnnotationProvider.HOOK_MARKERS.contains(annotationSuffix);
    }

    public static boolean isStepDefinition(@NotNull PsiMethod method) {
        List<PsiAnnotation> stepAnnotations;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(6);
        }
        return (stepAnnotations = CucumberJavaUtil.getCucumberStepAnnotations(method)).size() > 0;
    }

    public static boolean isHook(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(7);
        }
        return CucumberJavaUtil.getCucumberHookAnnotation(method) != null;
    }

    public static boolean isParameterType(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(8);
        }
        return CucumberJavaUtil.getParameterTypeAnnotation(method) != null;
    }

    public static boolean isStepDefinitionClass(@NotNull PsiClass clazz) {
        PsiMethod[] methods;
        if (clazz == null) {
            CucumberJavaUtil.$$$reportNull$$$0(9);
        }
        for (PsiMethod method : methods = clazz.getAllMethods()) {
            if (CucumberJavaUtil.getCucumberStepAnnotations(method).size() <= 0 && CucumberJavaUtil.getCucumberHookAnnotation(method) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiAnnotation getParameterTypeAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(10);
        }
        for (PsiAnnotation annotation : method.getAnnotations()) {
            String annotationFqn = CucumberJavaUtil.getAnnotationName(annotation);
            if (!PARAMETER_TYPE_ANNOTATION_FQN.equals(annotationFqn)) continue;
            return annotation;
        }
        return null;
    }

    public static List<PsiAnnotation> getCucumberStepAnnotations(@NotNull PsiMethod method) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(11);
        }
        return CucumberJavaUtil.getCucumberStepAnnotations(method, null);
    }

    @NotNull
    public static List<PsiAnnotation> getCucumberStepAnnotations(@NotNull PsiMethod method, @Nullable String annotationClassName) {
        PsiAnnotation[] annotations;
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(12);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        if (!method.hasModifierProperty("public")) {
            ArrayList<PsiAnnotation> arrayList = result;
            if (arrayList == null) {
                CucumberJavaUtil.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || annotationClassName != null && !annotationClassName.equals(annotation.getQualifiedName()) || !CucumberJavaUtil.isCucumberStepAnnotation(annotation)) continue;
            result.add(annotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            CucumberJavaUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getStepAnnotationValues(@NotNull PsiMethod method, @Nullable String annotationClassName) {
        if (method == null) {
            CucumberJavaUtil.$$$reportNull$$$0(15);
        }
        ArrayList<String> result = new ArrayList<String>();
        List<PsiAnnotation> stepAnnotations = CucumberJavaUtil.getCucumberStepAnnotations(method, annotationClassName);
        for (PsiAnnotation stepAnnotation : stepAnnotations) {
            String annotationValue = CucumberJavaUtil.getAnnotationValue(stepAnnotation);
            if (annotationValue == null) continue;
            result.add(annotationValue);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CucumberJavaUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    public static String getAnnotationValue(@NotNull PsiAnnotation stepAnnotation) {
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(17);
        }
        return AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)stepAnnotation, (String)"value");
    }

    @Nullable
    public static PsiAnnotation getCucumberHookAnnotation(PsiMethod method) {
        PsiAnnotation[] annotations;
        if (!method.hasModifierProperty("public")) {
            return null;
        }
        for (PsiAnnotation annotation : annotations = method.getModifierList().getAnnotations()) {
            if (annotation == null || !CucumberJavaUtil.isCucumberHookAnnotation(annotation)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getPatternFromStepDefinition(@NotNull PsiAnnotation stepAnnotation) {
        String result;
        if (stepAnnotation == null) {
            CucumberJavaUtil.$$$reportNull$$$0(18);
        }
        if ((result = AnnotationUtil.getStringAttributeValue((PsiAnnotation)stepAnnotation, null)) != null) {
            result = result.replaceAll("\\\\", "\\\\\\\\");
        }
        return result;
    }

    @Nullable
    private static String getPackageOfStepDef(GherkinStep[] steps) {
        for (GherkinStep step : steps) {
            String pack = CucumberJavaUtil.getPackageOfStep(step);
            if (pack == null) continue;
            return pack;
        }
        return null;
    }

    @NotNull
    public static String getPackageOfStepDef(PsiElement element) {
        GherkinFeature feature;
        PsiFile file = element.getContainingFile();
        if (file instanceof GherkinFile && (feature = (GherkinFeature)PsiTreeUtil.getChildOfType((PsiElement)file, GherkinFeature.class)) != null) {
            List scenarioList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenario.class);
            for (GherkinScenario scenario : scenarioList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(19);
                }
                return string;
            }
            List scenarioOutlineList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)feature, GherkinScenarioOutline.class);
            for (GherkinScenarioOutline scenario : scenarioOutlineList) {
                String result = CucumberJavaUtil.getPackageOfStepDef(scenario.getSteps());
                if (result == null) continue;
                String string = result;
                if (string == null) {
                    CucumberJavaUtil.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        return "";
    }

    public static String getPackageOfStep(GherkinStep step) {
        for (PsiReference ref : step.getReferences()) {
            PsiClassOwner file;
            String packageName;
            ProgressManager.checkCanceled();
            PsiElement refElement = ref.resolve();
            if (!(refElement instanceof PsiMethod) && !(refElement instanceof PsiMethodCallExpression) || !StringUtil.isNotEmpty((String)(packageName = (file = (PsiClassOwner)refElement.getContainingFile()).getPackageName()))) continue;
            return packageName;
        }
        return null;
    }

    public static boolean addGlue(String glue, Set<String> glues) {
        boolean covered = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String existedGlue : glues) {
            if (glue.startsWith(existedGlue + ".")) {
                covered = true;
                break;
            }
            if (!existedGlue.startsWith(glue + ".")) continue;
            toRemove.add(existedGlue);
        }
        for (String removing : toRemove) {
            glues.remove(removing);
        }
        if (!covered) {
            glues.add(glue);
            return true;
        }
        return false;
    }

    public static MapParameterTypeManager getAllParameterTypes(@NotNull Module module) {
        PsiDirectory psiDirectory;
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(21);
        }
        Project project = module.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        PsiDirectory psiDirectory2 = psiDirectory = projectDir != null ? manager.findDirectory(projectDir) : null;
        if (psiDirectory != null) {
            return (MapParameterTypeManager)CachedValuesManager.getCachedValue((PsiElement)psiDirectory, () -> CachedValueProvider.Result.create((Object)CucumberJavaUtil.doGetAllParameterTypes(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return MapParameterTypeManager.DEFAULT;
    }

    @NotNull
    private static MapParameterTypeManager doGetAllParameterTypes(@NotNull Module module) {
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(22);
        }
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, SmartPsiElementPointer<PsiElement>> declarations = new HashMap<String, SmartPsiElementPointer<PsiElement>>();
        CucumberJavaUtil.processParameterTypesDefinedByAnnotation(module, dependenciesScope, values, declarations);
        CucumberJavaUtil.processParameterTypesDefinedByTypeRegistry(module, dependenciesScope, values, declarations);
        values.putAll(CucumberUtil.STANDARD_PARAMETER_TYPES);
        values.putAll(JAVA_PARAMETER_TYPES);
        return new MapParameterTypeManager(values, declarations);
    }

    private static void processParameterTypesDefinedByTypeRegistry(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull Map<String, String> values, @NotNull Map<String, SmartPsiElementPointer<PsiElement>> declarations) {
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            CucumberJavaUtil.$$$reportNull$$$0(24);
        }
        if (values == null) {
            CucumberJavaUtil.$$$reportNull$$$0(25);
        }
        if (declarations == null) {
            CucumberJavaUtil.$$$reportNull$$$0(26);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JavaMethodFindUsagesOptions options = new JavaMethodFindUsagesOptions((SearchScope)scope);
        PsiClass parameterTypeClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)module.getProject()), (String)PARAMETER_TYPE_CLASS);
        if (parameterTypeClass != null) {
            for (PsiMethod method : parameterTypeClass.getMethods()) {
                if ((!method.getModifierList().hasModifierProperty("public") || !method.getModifierList().hasModifierProperty("static")) && !method.isConstructor()) continue;
                JavaFindUsagesHelper.processElementUsages((PsiElement)method, (FindUsagesOptions)options, (Processor)processor);
            }
        }
        for (UsageInfo ui : processor.getResults()) {
            PsiElement element = ui.getElement();
            if (element == null) continue;
            if (element.getParent() instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
                CucumberJavaUtil.processParameterTypeFromConstructor(values, declarations, newExpression);
            }
            if (!(element.getParent() instanceof PsiMethodCallExpression)) continue;
            PsiMethodCallExpression call = (PsiMethodCallExpression)element.getParent();
            CucumberJavaUtil.processParameterTypeMethodDeclaration(values, declarations, call);
        }
    }

    private static void processParameterTypesDefinedByAnnotation(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull Map<String, String> values, @NotNull Map<String, SmartPsiElementPointer<PsiElement>> declarations) {
        PsiClass parameterTypeAnnotationClass;
        if (module == null) {
            CucumberJavaUtil.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            CucumberJavaUtil.$$$reportNull$$$0(28);
        }
        if (values == null) {
            CucumberJavaUtil.$$$reportNull$$$0(29);
        }
        if (declarations == null) {
            CucumberJavaUtil.$$$reportNull$$$0(30);
        }
        if ((parameterTypeAnnotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(PARAMETER_TYPE_ANNOTATION_FQN, scope)) != null) {
            Query parameterTypeMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)parameterTypeAnnotationClass, (SearchScope)scope);
            for (PsiMethod method : parameterTypeMethods.findAll()) {
                String parameterTypeAnnotationValue;
                PsiAnnotation parameterTypeAnnotation = CucumberJavaUtil.getParameterTypeAnnotation(method);
                if (parameterTypeAnnotation == null || !StringUtil.isNotEmpty((String)(parameterTypeAnnotationValue = CucumberJavaUtil.getAnnotationValue(parameterTypeAnnotation)))) continue;
                values.put(method.getName(), parameterTypeAnnotationValue);
                PsiIdentifier methodNameIdentifier = method.getNameIdentifier();
                if (methodNameIdentifier == null) continue;
                declarations.put(method.getName(), (SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)methodNameIdentifier));
            }
        }
    }

    private static void processParameterTypeMethodDeclaration(@NotNull Map<String, String> values, @NotNull Map<String, SmartPsiElementPointer<PsiElement>> declarations, @NotNull PsiMethodCallExpression call) {
        if (values == null) {
            CucumberJavaUtil.$$$reportNull$$$0(31);
        }
        if (declarations == null) {
            CucumberJavaUtil.$$$reportNull$$$0(32);
        }
        if (call == null) {
            CucumberJavaUtil.$$$reportNull$$$0(33);
        }
        if (!FROM_ENUM_METHOD.matches((PsiExpression)call)) {
            return;
        }
        PsiExpression[] arguments = call.getArgumentList().getExpressions();
        if (arguments.length <= 0) {
            return;
        }
        PsiExpression enumClass = arguments[0];
        if (!(enumClass instanceof PsiClassObjectAccessExpression)) {
            return;
        }
        PsiClassObjectAccessExpression objectAccessExpression = (PsiClassObjectAccessExpression)enumClass;
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)objectAccessExpression.getOperand().getType());
        if (psiClass == null || !psiClass.isEnum() || psiClass.getName() == null) {
            return;
        }
        String regex = Arrays.stream(psiClass.getFields()).map(f -> f.getName()).collect(Collectors.joining("|"));
        values.put(psiClass.getName(), regex);
        declarations.put(psiClass.getName(), (SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)psiClass));
    }

    private static void processParameterTypeFromConstructor(@NotNull Map<String, String> values, @NotNull Map<String, SmartPsiElementPointer<PsiElement>> declarations, @NotNull PsiNewExpression newExpression) {
        PsiExpressionList arguments;
        if (values == null) {
            CucumberJavaUtil.$$$reportNull$$$0(34);
        }
        if (declarations == null) {
            CucumberJavaUtil.$$$reportNull$$$0(35);
        }
        if (newExpression == null) {
            CucumberJavaUtil.$$$reportNull$$$0(36);
        }
        if ((arguments = newExpression.getArgumentList()) == null) {
            return;
        }
        PsiExpression[] expressions = arguments.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        PsiConstantEvaluationHelper evaluationHelper = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getConstantEvaluationHelper();
        Object constantValue = evaluationHelper.computeConstantExpression((PsiElement)expressions[0], false);
        if (constantValue == null) {
            return;
        }
        String name = constantValue.toString();
        constantValue = evaluationHelper.computeConstantExpression((PsiElement)expressions[1], false);
        if (constantValue == null) {
            return;
        }
        String value = constantValue.toString();
        values.put(name, value);
        declarations.put(name, (SmartPsiElementPointer<PsiElement>)SmartPointerManager.createPointer((PsiElement)expressions[0]));
    }

    public static boolean isCucumberExpressionsAvailable(@NotNull PsiElement context) {
        if (context == null) {
            CucumberJavaUtil.$$$reportNull$$$0(37);
        }
        PsiLocation location = new PsiLocation(context);
        return LocationUtil.isJarAttached((Location)location, (PsiDirectory[])PsiDirectory.EMPTY_ARRAY, (String[])new String[]{CUCUMBER_EXPRESSIONS_CLASS_MARKER});
    }

    public static void calculateGlueFromGherkinFile(@NotNull GherkinFile gherkinFile, final @NotNull Consumer<String> consumer) {
        if (gherkinFile == null) {
            CucumberJavaUtil.$$$reportNull$$$0(38);
        }
        if (consumer == null) {
            CucumberJavaUtil.$$$reportNull$$$0(39);
        }
        gherkinFile.accept((PsiElementVisitor)new GherkinRecursiveElementVisitor(){

            public void visitStep(GherkinStep step) {
                String glue = CucumberJavaUtil.getPackageOfStep(step);
                if (glue != null) {
                    consumer.accept(glue);
                }
            }
        });
    }

    public static void calculateGlueFromHooks(@NotNull PsiElement element, @NotNull Consumer<String> consumer) {
        Module module;
        if (element == null) {
            CucumberJavaUtil.$$$reportNull$$$0(40);
        }
        if (consumer == null) {
            CucumberJavaUtil.$$$reportNull$$$0(41);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        for (String fullyQualifiedAnnotationName : CucumberJavaRunConfigurationProducer.HOOK_ANNOTATION_NAMES) {
            ProgressManager.checkCanceled();
            PsiClass psiClass = javaPsiFacade.findClass(fullyQualifiedAnnotationName, dependenciesScope);
            if (psiClass == null) continue;
            Query psiMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)psiClass, (SearchScope)GlobalSearchScope.allScope((Project)element.getProject()));
            Collection methods = psiMethods.findAll();
            methods.forEach(it -> {
                PsiClassOwner file = (PsiClassOwner)it.getContainingFile();
                String packageName = file.getPackageName();
                if (StringUtil.isNotEmpty((String)packageName)) {
                    consumer.accept(packageName);
                }
            });
        }
    }

    @NotNull
    public static String getCucumberMainClass(@NotNull String cucumberCoreVersion) {
        if (cucumberCoreVersion == null) {
            CucumberJavaUtil.$$$reportNull$$$0(42);
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"4.5") >= 0) {
            return CUCUMBER_4_5_MAIN_CLASS;
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"1.1") >= 0) {
            return CUCUMBER_1_1_MAIN_CLASS;
        }
        return CUCUMBER_1_0_MAIN_CLASS;
    }

    static {
        SCRIPT_STYLE_REGEXP = Pattern.compile("^/(.*)/$");
        FROM_ENUM_METHOD = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)PARAMETER_TYPE_CLASS, (String[])new String[]{"fromEnum"})});
        HashMap<String, String> javaParameterTypes = new HashMap<String, String>();
        javaParameterTypes.put("short", (String)CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("biginteger", (String)CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("bigdecimal", "-?\\d*[.,]\\d+");
        javaParameterTypes.put("byte", (String)CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        javaParameterTypes.put("double", (String)CucumberUtil.STANDARD_PARAMETER_TYPES.get("float"));
        javaParameterTypes.put("long", (String)CucumberUtil.STANDARD_PARAMETER_TYPES.get("int"));
        JAVA_PARAMETER_TYPES = Collections.unmodifiableMap(javaParameterTypes);
        JAVA_DEFAULT_PARAMETER_TYPE_MANAGER = new MapParameterTypeManager(CucumberUtil.STANDARD_PARAMETER_TYPES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepAnnotation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 26: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gherkinFile";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberCoreVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/CucumberJavaUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCucumberStepAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepAnnotationValues";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageOfStepDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberAnnotationSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberPendingExceptionFqn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberStepAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberHookAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHook";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParameterType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinitionClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberStepAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStepAnnotationValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPatternFromStepDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllParameterTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doGetAllParameterTypes";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypesDefinedByTypeRegistry";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypesDefinedByAnnotation";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypeMethodDeclaration";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypeFromConstructor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpressionsAvailable";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "calculateGlueFromGherkinFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "calculateGlueFromHooks";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberMainClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

